/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.numismaticoverhaul.currency;

import com.glisco.numismaticoverhaul.currency.Currency;

public class CurrencyResolver {
    public static long[] splitValues(long rawValue) {
        long[] output = new long[]{0L, 0L, 0L};
        if (rawValue / 10000L != 0L) {
            output[2] = rawValue / 10000L;
            rawValue -= 10000L * output[2];
        }
        if (rawValue / 100L != 0L) {
            output[1] = rawValue / 100L;
            rawValue -= 100L * output[1];
        }
        if (rawValue > 0L) {
            output[0] = rawValue;
        }
        return output;
    }

    public static long combineValues(long[] values) {
        if (values.length != 3) {
            throw new IllegalArgumentException("Input array has to have 3 elements");
        }
        return Currency.BRONZE.getRawValue(values[0]) + Currency.SILVER.getRawValue(values[1]) + Currency.GOLD.getRawValue(values[2]);
    }

    public static long combineValues(long bronze, long silver, long gold) {
        return Currency.BRONZE.getRawValue(bronze) + Currency.SILVER.getRawValue(silver) + Currency.GOLD.getRawValue(gold);
    }

    public static boolean canBeCompacted(long[] values) {
        return values[0] < 100L && values[1] < 100L && values[2] < 100L;
    }
}

