/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.numismaticoverhaul.currency;

import com.glisco.numismaticoverhaul.currency.CurrencyConverter;
import com.glisco.numismaticoverhaul.currency.CurrencyResolver;
import com.glisco.numismaticoverhaul.item.CurrencyItem;
import com.glisco.numismaticoverhaul.item.MoneyBagComponent;
import com.glisco.numismaticoverhaul.item.MoneyBagItem;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.KeyedEndec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_9288;
import net.minecraft.class_9306;

public class CurrencyHelper {
    public static final KeyedEndec<Long> VALUE = new KeyedEndec("Value", Endec.LONG, (Object)0L);

    public static long getMoneyInInventory(class_1657 player, boolean remove) {
        long value = 0L;
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof CurrencyItem)) continue;
            CurrencyItem currencyItem = (CurrencyItem)class_17922;
            value += currencyItem.getValue(stack);
            if (!remove) continue;
            player.method_31548().method_7378(stack);
        }
        return value;
    }

    public static List<Long> getFromContainer(class_9288 component) {
        List<class_1799> items = component.method_57489().toList();
        int value = CurrencyHelper.getValue(items);
        MoneyBagComponent moneyBagComponent = MoneyBagComponent.of(value);
        return List.of(Long.valueOf(moneyBagComponent.bronze()), Long.valueOf(moneyBagComponent.silver()), Long.valueOf(moneyBagComponent.gold()));
    }

    public static int getValue(List<class_1799> stacks) {
        return stacks.stream().mapToInt(stack -> {
            if (stack == null) {
                return 0;
            }
            class_1792 patt0$temp = stack.method_7909();
            if (!(patt0$temp instanceof CurrencyItem)) {
                return 0;
            }
            CurrencyItem currencyItem = (CurrencyItem)patt0$temp;
            return (int)currencyItem.getValue((class_1799)stack);
        }).sum();
    }

    public static void offerAsCoins(class_1657 player, long value) {
        for (class_1799 itemStack : CurrencyConverter.getAsValidStacks(value)) {
            player.method_31548().method_7398(itemStack);
        }
    }

    public static boolean deductFromInventory(class_1657 player, long value) {
        long presentInInventory = CurrencyHelper.getMoneyInInventory(player, false);
        if (presentInInventory < value) {
            return false;
        }
        CurrencyHelper.getMoneyInInventory(player, true);
        CurrencyHelper.offerAsCoins(player, presentInInventory - value);
        return true;
    }

    public static List<class_1799> getAsStacks(long value, int maxStacks) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        List<class_1799> rawStacks = CurrencyConverter.getAsValidStacks(value);
        if (rawStacks.size() <= maxStacks) {
            stacks.addAll(rawStacks);
        } else {
            stacks.add(MoneyBagItem.fromRawValue(value));
        }
        return stacks;
    }

    public static class_1799 getClosest(long value) {
        long[] values = CurrencyResolver.splitValues(value);
        for (int i = 0; i < 2 && values[i + 1] != 0L; ++i) {
            int n = i + 1;
            values[n] = values[n] + (long)Math.round((float)values[i] / 100.0f);
            values[i] = 0L;
        }
        return CurrencyConverter.getAsItemStackList(CurrencyResolver.combineValues(values)).get(0);
    }

    public static class_9306 getClosestTradeItem(long price) {
        class_1799 closestPriceStack = CurrencyHelper.getClosest(price);
        return new class_9306((class_1935)closestPriceStack.method_7909(), closestPriceStack.method_7947());
    }
}

