/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.numismaticoverhaul.client.gui;

import com.glisco.numismaticoverhaul.NumismaticOverhaul;
import com.glisco.numismaticoverhaul.block.ShopOffer;
import com.glisco.numismaticoverhaul.block.ShopScreenHandler;
import com.glisco.numismaticoverhaul.currency.CurrencyResolver;
import com.glisco.numismaticoverhaul.network.UpdateShopScreenS2CPacket;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.container.StackLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.util.UISounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

public class ShopScreen
extends BaseOwoHandledScreen<FlowLayout, ShopScreenHandler> {
    public static final class_2960 TEXTURE_PNG = NumismaticOverhaul.id("textures/gui/shop_gui.png");
    public static final class_2960 TRADES_TEXTURE = NumismaticOverhaul.id("textures/gui/shop_gui_trades.png");
    private final List<class_4185> tabButtons = new ArrayList<class_4185>();
    private final List<ShopOffer> offers = new ArrayList<ShopOffer>();
    private Runnable afterDataUpdate = () -> {};
    private Consumer<String> priceDisplay = s -> {};
    private int tab = 0;

    public ShopScreen(ShopScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        ++this.field_25270;
        this.field_25268 = 5;
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, (sizing, sizing2) -> {
            FlowLayout root = Containers.verticalFlow((Sizing)sizing, (Sizing)sizing2);
            root.alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
            root.surface(Surface.VANILLA_TRANSLUCENT);
            return root;
        });
    }

    protected void build(FlowLayout rootComponent) {
        this.tabButtons.clear();
        rootComponent.child((Component)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).children(List.of(Containers.verticalFlow((Sizing)Sizing.fixed((int)120), (Sizing)Sizing.content()).children(List.of(this.makeTabButton(class_1802.field_8106, false, b -> this.selectTab(0)), this.makeTabButton(class_1802.field_8687, true, b -> this.selectTab(1)))).horizontalAlignment(HorizontalAlignment.RIGHT).padding(Insets.top((int)5)).allowOverflow(true).id("left-column"), Containers.stack((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(this.createBackgroundTexture(TEXTURE_PNG).id("background-texture")).id("background"), Containers.verticalFlow((Sizing)Sizing.fixed((int)120), (Sizing)Sizing.content()).child((Component)this.makeCurrencyWidget(button -> ((ShopScreenHandler)this.field_2797).extractCurrency())).child((Component)Containers.stack((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((Component)Components.item((class_1799)class_1802.field_8239.method_7854()).margins(Insets.of((int)6))).child(Components.label((class_2561)class_2561.method_43473()).shadow(true).positioning(Positioning.absolute((int)15, (int)15)).zIndex(150).id("transfer-label")).child(Containers.verticalFlow((Sizing)Sizing.fixed((int)28), (Sizing)Sizing.fixed((int)28)).cursorStyle(CursorStyle.HAND).positioning(Positioning.absolute((int)0, (int)0)).id("transfer-button")).margins(Insets.top((int)3)).surface(Surface.PANEL)).horizontalAlignment(HorizontalAlignment.LEFT).padding(Insets.left((int)2)).id("right-column"))));
        ((FlowLayout)rootComponent.childById(FlowLayout.class, "transfer-button")).mouseDown().subscribe((x, y, button) -> {
            if (button != 0) {
                return false;
            }
            ((ShopScreenHandler)this.field_2797).toggleTransfer();
            UISounds.playInteractionSound();
            return true;
        });
    }

    protected boolean method_2381(double mouseX, double mouseY, int left, int top, int button) {
        ItemComponent buffer = (ItemComponent)this.component(ItemComponent.class, "trade-buffer");
        if (buffer != null && buffer.isInBoundingBox(mouseX, mouseY)) {
            return false;
        }
        return super.method_2381(mouseX, mouseY, left, top, button);
    }

    public void update(UpdateShopScreenS2CPacket data) {
        if (this.uiAdapter == null) {
            return;
        }
        long[] storedCurrency = CurrencyResolver.splitValues(data.storedCurrency());
        ((LabelComponent)this.component(LabelComponent.class, "bronze-count")).text((class_2561)class_2561.method_43470((String)String.valueOf(storedCurrency[0])));
        ((LabelComponent)this.component(LabelComponent.class, "silver-count")).text((class_2561)class_2561.method_43470((String)String.valueOf(storedCurrency[1])));
        ((LabelComponent)this.component(LabelComponent.class, "gold-count")).text((class_2561)class_2561.method_43470((String)String.valueOf(storedCurrency[2])));
        int prevOffers = this.offers.size();
        this.offers.clear();
        this.offers.addAll(data.offers());
        if (this.tab == 1) {
            this.populateTrades(this.tab);
        }
        if (this.tab == 1 && this.offers.size() > prevOffers) {
            ScrollContainer offersScroll = (ScrollContainer)this.component(ScrollContainer.class, "offer-container");
            FlowLayout leftColumn = (FlowLayout)offersScroll.childById(FlowLayout.class, "first-trades-column");
            offersScroll.scrollTo((Component)leftColumn.children().getLast());
        }
        ((FlowLayout)this.component(FlowLayout.class, "transfer-button")).tooltip((class_2561)(data.transferEnabled() ? class_2561.method_43471((String)"gui.numismatic-overhaul.shop.transfer_tooltip.enabled") : class_2561.method_43471((String)"gui.numismatic-overhaul.shop.transfer_tooltip.disabled")));
        ((LabelComponent)this.component(LabelComponent.class, "transfer-label")).text((class_2561)(data.transferEnabled() ? TextOps.withColor((String)"\u2714", (int)2686911) : TextOps.withColor((String)"\u2718", (int)15408438)));
        this.afterDataUpdate();
    }

    private class_2561 computeTransferTooltip(boolean isTransferEnabled) {
        return isTransferEnabled ? class_2561.method_43471((String)"gui.numismatic-overhaul.shop.transfer_tooltip.enabled") : class_2561.method_43471((String)"gui.numismatic-overhaul.shop.transfer_tooltip.disabled");
    }

    public void afterDataUpdate() {
        this.afterDataUpdate.run();
    }

    private void selectTab(int index) {
        if (this.tab == index) {
            return;
        }
        if (index == 0) {
            this.swapBackgroundTexture(TEXTURE_PNG);
            this.field_25268 = 5;
            ((FlowLayout)this.component(FlowLayout.class, "right-column")).removeChild(this.component(FlowLayout.class, "trade-edit-widget"));
            this.afterDataUpdate = () -> {};
            this.priceDisplay = s -> {};
        } else {
            this.swapBackgroundTexture(TRADES_TEXTURE);
            this.field_25268 = 69420;
            ((StackLayout)((FlowLayout)this.uiAdapter.rootComponent).childById(StackLayout.class, "background")).child(Containers.verticalScroll((Sizing)Sizing.fixed((int)160), (Sizing)Sizing.fixed((int)60), (Component)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).children(List.of()).id("first-trades-column")).child(Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).children(List.of()).id("second-trades-column").margins(Insets.left((int)4)))).positioning(Positioning.absolute((int)8, (int)10)).id("offer-container"));
            FlowLayout editWidget = this.makeTradeEditWidget(((ShopScreenHandler)this.field_2797).getBufferStack());
            ButtonComponent submitButton = (ButtonComponent)editWidget.childById(ButtonComponent.class, "submit-button");
            ButtonComponent deleteButton = (ButtonComponent)editWidget.childById(ButtonComponent.class, "delete-button");
            ItemComponent tradeBuffer = (ItemComponent)editWidget.childById(ItemComponent.class, "trade-buffer");
            tradeBuffer.showOverlay(true);
            tradeBuffer.mouseDown().subscribe((mouseX, mouseY, button) -> {
                ((ShopScreenHandler)this.field_2797).handleBufferClick();
                return true;
            });
            class_342 priceField = (class_342)editWidget.childById(class_342.class, "price-field");
            priceField.method_1880(7);
            priceField.method_1890(s -> s.matches("\\d*"));
            priceField.method_1863(s -> {
                this.afterDataUpdate();
                long[] price = CurrencyResolver.splitValues(s.isBlank() ? 0L : (long)Integer.parseInt(s));
                ((LabelComponent)this.component(LabelComponent.class, "offer-bronze-count")).text((class_2561)class_2561.method_43470((String)String.valueOf(price[0])));
                ((LabelComponent)this.component(LabelComponent.class, "offer-silver-count")).text((class_2561)class_2561.method_43470((String)String.valueOf(price[1])));
                ((LabelComponent)this.component(LabelComponent.class, "offer-gold-count")).text((class_2561)class_2561.method_43470((String)String.valueOf(price[2])));
            });
            submitButton.onPress(button -> ((ShopScreenHandler)this.field_2797).createOffer(Integer.parseInt(priceField.method_1882())));
            deleteButton.onPress(button -> ((ShopScreenHandler)this.field_2797).deleteOffer());
            this.priceDisplay = arg_0 -> ((class_342)priceField).method_1852(arg_0);
            this.afterDataUpdate = () -> {
                String priceText = priceField.method_1882();
                class_1799 bufferStack = ((ShopScreenHandler)this.field_2797).getBufferStack();
                boolean hasOffer = this.hasOfferFor(bufferStack);
                submitButton.field_22763 = !priceText.isBlank() && Integer.parseInt(priceText) > 0 && !bufferStack.method_7960() && (this.offers.size() < 24 || hasOffer);
                deleteButton.field_22763 = hasOffer;
                tradeBuffer.stack(bufferStack);
                if (!bufferStack.method_7960()) {
                    ArrayList tooltip = new ArrayList();
                    class_310 client = class_310.method_1551();
                    bufferStack.method_7950(class_1792.class_9635.method_59528((class_1937)client.field_1687), (class_1657)client.field_1724, (class_1836)(client.field_1690.field_1827 ? class_1836.field_41071 : class_1836.field_41070)).stream().map(class_2561::method_30937).map(class_5684::method_32662).forEach(tooltip::add);
                    bufferStack.method_32347().ifPresent(data -> {
                        class_5684 fabricComponent = ((TooltipComponentCallback)TooltipComponentCallback.EVENT.invoker()).getComponent(data);
                        tooltip.add(1, Objects.requireNonNullElseGet(fabricComponent, () -> class_5684.method_32663((class_5632)data)));
                    });
                    tradeBuffer.tooltip(tooltip);
                } else {
                    tradeBuffer.tooltip((List)null);
                }
            };
            ((FlowLayout)this.component(FlowLayout.class, "right-column")).child(0, (Component)editWidget);
        }
        this.populateTrades(index);
        for (int i = 0; i < this.tabButtons.size(); ++i) {
            this.tabButtons.get((int)i).field_22763 = i != index;
        }
        this.tab = index;
    }

    private boolean hasOfferFor(class_1799 stack) {
        return this.offers.stream().anyMatch(offer -> class_1799.method_7984((class_1799)stack, (class_1799)offer.getSellStack()));
    }

    private void populateTrades(int tab) {
        FlowLayout firstColumn = (FlowLayout)this.component(FlowLayout.class, "first-trades-column");
        FlowLayout secondColumn = (FlowLayout)this.component(FlowLayout.class, "second-trades-column");
        firstColumn.clearChildren();
        secondColumn.clearChildren();
        if (tab == 0) {
            return;
        }
        for (int i = 0; i < this.offers.size(); ++i) {
            ShopOffer offer = this.offers.get(i);
            FlowLayout tradeComponent = this.makeTradeButton(offer.getSellStack(), offer.getPrice(), i);
            (i % 2 == 0 ? firstColumn : secondColumn).child((Component)tradeComponent);
        }
    }

    private void swapBackgroundTexture(class_2960 newTexture) {
        ((TextureComponent)((FlowLayout)this.uiAdapter.rootComponent).childById(TextureComponent.class, "background-texture")).remove();
        ((StackLayout)((FlowLayout)this.uiAdapter.rootComponent).childById(StackLayout.class, "background")).child((Component)this.createBackgroundTexture(newTexture));
    }

    private TextureComponent createBackgroundTexture(class_2960 id) {
        TextureComponent bg = Components.texture((class_2960)id, (int)0, (int)0, (int)176, (int)168);
        bg.id("background-texture");
        return bg;
    }

    private StackLayout makeTabButton(class_1792 icon, boolean active, Consumer<ButtonComponent> onPress) {
        StackLayout buttonLayout = Containers.stack((Sizing)Sizing.content(), (Sizing)Sizing.content());
        buttonLayout.child((Component)Components.item((class_1799)icon.method_7854()).positioning(Positioning.absolute((int)9, (int)6))).child(Components.button((class_2561)class_2561.method_43473(), onPress).active(active).renderer(ButtonComponent.Renderer.texture((class_2960)TEXTURE_PNG, (int)113, (int)168, (int)256, (int)256)).sizing(Sizing.fixed((int)32), Sizing.fixed((int)28)).margins(Insets.right((int)-3)).id("tab-button")).margins(Insets.bottom((int)4)).allowOverflow(true);
        ButtonComponent button = (ButtonComponent)buttonLayout.childById(ButtonComponent.class, "tab-button");
        this.tabButtons.add((class_4185)button);
        return buttonLayout;
    }

    private StackLayout makeCurrencyWidget(Consumer<ButtonComponent> onPress) {
        StackLayout currencyComponent = Containers.stack((Sizing)Sizing.content(), (Sizing)Sizing.content());
        currencyComponent.child((Component)Components.texture((class_2960)TEXTURE_PNG, (int)146, (int)169, (int)34, (int)54)).child(Components.label((class_2561)class_2561.method_43470((String)"0")).positioning(Positioning.absolute((int)5, (int)7)).id("gold-count")).child(Components.label((class_2561)class_2561.method_43470((String)"0")).positioning(Positioning.absolute((int)5, (int)19)).id("silver-count")).child(Components.label((class_2561)class_2561.method_43470((String)"0")).positioning(Positioning.absolute((int)5, (int)31)).id("bronze-count")).child(Components.button((class_2561)class_2561.method_43473(), onPress).renderer(ButtonComponent.Renderer.texture((class_2960)TEXTURE_PNG, (int)146, (int)224, (int)256, (int)256)).sizing(Sizing.fixed((int)26), Sizing.fixed((int)8)).positioning(Positioning.absolute((int)4, (int)41)));
        return currencyComponent;
    }

    private FlowLayout makeTradeButton(class_1799 tradeItem, long price, int offerIndex) {
        FlowLayout tradeButton = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        tradeButton.child(Components.button((class_2561)class_2561.method_43473(), button -> {
            ((ShopScreenHandler)this.field_2797).loadOffer(offerIndex);
            this.priceDisplay.accept(String.valueOf(price));
        }).sizing(Sizing.fixed((int)78), Sizing.content()).id("trade-button")).child(Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.fixed((int)20)).children(List.of(Components.item((class_1799)tradeItem).showOverlay(true).cursorStyle(CursorStyle.HAND).id("item-display"), Components.texture((class_2960)TEXTURE_PNG, (int)1, (int)172, (int)5, (int)7).margins(Insets.left((int)3)), Components.label((class_2561)class_2561.method_43470((String)String.valueOf(price))).shadow(true).cursorStyle(CursorStyle.HAND).margins(Insets.left((int)2)).id("price-label"))).verticalAlignment(VerticalAlignment.CENTER).padding(Insets.left((int)4)).positioning(Positioning.absolute((int)0, (int)0)));
        return tradeButton;
    }

    private FlowLayout makeTradeEditWidget(class_1799 tradeStack) {
        FlowLayout editorWidget = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        TextBoxComponent priceFieldComponent = Components.textBox((Sizing)Sizing.fixed((int)47));
        priceFieldComponent.verticalSizing(Sizing.fixed((int)11)).positioning(Positioning.absolute((int)35, (int)18)).id("price-field");
        priceFieldComponent.method_1858(false);
        editorWidget.children(List.of(Components.texture((class_2960)TEXTURE_PNG, (int)15, (int)169, (int)98, (int)54), new FakeSlotComponent(tradeStack).showOverlay(true).positioning(Positioning.absolute((int)8, (int)15)).id("trade-buffer"), Components.button((class_2561)class_2561.method_43473(), buttonComponent -> {}).active(false).renderer(ButtonComponent.Renderer.texture((class_2960)TEXTURE_PNG, (int)15, (int)223, (int)256, (int)256)).sizing(Sizing.fixed((int)41), Sizing.fixed((int)11)).positioning(Positioning.absolute((int)7, (int)36)).id("submit-button"), Components.button((class_2561)class_2561.method_43473(), buttonComponent -> {}).renderer(ButtonComponent.Renderer.texture((class_2960)TEXTURE_PNG, (int)56, (int)223, (int)256, (int)256)).active(false).sizing(Sizing.fixed((int)41), Sizing.fixed((int)11)).positioning(Positioning.absolute((int)50, (int)36)).id("delete-button"), priceFieldComponent, Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).children(List.of(Components.label((class_2561)class_2561.method_43470((String)"0")).color(Color.ofRgb((int)0x898989)).horizontalSizing(Sizing.fixed((int)12)).id("offer-bronze-count"), Components.label((class_2561)class_2561.method_43470((String)"0")).color(Color.ofRgb((int)0x898989)).margins(Insets.left((int)8)).horizontalSizing(Sizing.fixed((int)12)).id("offer-silver-count"), Components.label((class_2561)class_2561.method_43470((String)"0")).color(Color.ofRgb((int)0x898989)).margins(Insets.left((int)8)).horizontalSizing(Sizing.fixed((int)18)).id("offer-gold-count"))).positioning(Positioning.absolute((int)36, (int)5))));
        editorWidget.margins(Insets.bottom((int)3));
        editorWidget.id("trade-edit-widget");
        return editorWidget;
    }

    public int tab() {
        return this.tab;
    }

    static {
        UIParsing.registerFactory((class_2960)NumismaticOverhaul.id("fake-slot"), element -> new FakeSlotComponent(class_1799.field_8037));
    }

    public static class FakeSlotComponent
    extends ItemComponent {
        protected FakeSlotComponent(class_1799 stack) {
            super(stack);
        }

        public boolean shouldDrawTooltip(double mouseX, double mouseY) {
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return false;
            }
            return (player.field_7512 == null || player.field_7512.method_34255().method_7960()) && super.shouldDrawTooltip(mouseX, mouseY);
        }
    }
}

