/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.numismaticoverhaul.block;

import com.glisco.numismaticoverhaul.ModComponents;
import com.glisco.numismaticoverhaul.NumismaticOverhaul;
import com.glisco.numismaticoverhaul.block.ShopBlockEntity;
import com.glisco.numismaticoverhaul.block.ShopOffer;
import com.glisco.numismaticoverhaul.client.gui.ShopScreen;
import com.glisco.numismaticoverhaul.currency.CurrencyComponent;
import com.glisco.numismaticoverhaul.network.ShopScreenHandlerRequestC2SPacket;
import com.glisco.numismaticoverhaul.network.UpdateShopScreenS2CPacket;
import io.wispforest.owo.client.screens.ScreenUtils;
import io.wispforest.owo.client.screens.SlotGenerator;
import io.wispforest.owo.client.screens.SyncedProperty;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class ShopScreenHandler
extends class_1703 {
    private final class_1657 owner;
    private final class_1263 shopInventory;
    private final SyncedProperty<class_1799> tradeEditBuffer;
    private final List<ShopOffer> offers;
    private ShopBlockEntity shop = null;

    public ShopScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, (class_1263)new class_1277(27));
    }

    public ShopScreenHandler(int syncId, class_1661 playerInventory, class_1263 shopInventory) {
        super(NumismaticOverhaul.SHOP_SCREEN_HANDLER_TYPE, syncId);
        this.shopInventory = shopInventory;
        this.owner = playerInventory.field_7546;
        if (!this.owner.method_37908().method_8608()) {
            this.shop = (ShopBlockEntity)shopInventory;
            this.offers = this.shop.getOffers();
        } else {
            this.offers = new ArrayList<ShopOffer>();
        }
        SlotGenerator.begin(x$0 -> this.method_7621((class_1735)x$0), (int)8, (int)17).slotFactory((inv, index, x, y) -> new AutoHidingSlot(inv, index, x, y, 0, false)).grid(this.shopInventory, 0, 9, 3).slotFactory(class_1735::new).moveTo(8, 85).playerInventory(playerInventory);
        this.tradeEditBuffer = this.createProperty(class_1799.class, class_1799.field_8037);
        this.tradeEditBuffer.observe(stack -> {
            class_437 patt0$temp;
            if (this.owner.method_37908().field_9236 && (patt0$temp = class_310.method_1551().field_1755) instanceof ShopScreen) {
                ShopScreen screen = (ShopScreen)patt0$temp;
                screen.afterDataUpdate();
            }
        });
    }

    public boolean method_7597(class_1657 player) {
        return this.shopInventory.method_5443(player);
    }

    public void loadOffer(long index) {
        if (!this.owner.method_37908().field_9236) {
            if (index > (long)(this.offers.size() - 1)) {
                NumismaticOverhaul.LOGGER.error("Player {} attempted to load invalid trade at index {}", (Object)this.owner.method_5477(), (Object)index);
                return;
            }
            this.tradeEditBuffer.set((Object)this.offers.get((int)index).getSellStack());
        } else {
            NumismaticOverhaul.CHANNEL.clientHandle().send((Record)new ShopScreenHandlerRequestC2SPacket(ShopScreenHandlerRequestC2SPacket.Action.LOAD_OFFER, index));
        }
    }

    public void createOffer(long price) {
        if (!this.owner.method_37908().field_9236) {
            class_1799 stack = (class_1799)this.tradeEditBuffer.get();
            if (stack.method_7960()) {
                return;
            }
            this.shop.addOrReplaceOffer(new ShopOffer(stack, price));
            this.updateClient();
        } else {
            NumismaticOverhaul.CHANNEL.clientHandle().send((Record)new ShopScreenHandlerRequestC2SPacket(ShopScreenHandlerRequestC2SPacket.Action.CREATE_OFFER, price));
        }
    }

    public void extractCurrency() {
        if (!this.owner.method_37908().field_9236) {
            ((CurrencyComponent)ModComponents.CURRENCY.get((Object)this.owner)).modify(this.shop.getStoredCurrency());
            this.shop.setStoredCurrency(0L);
            this.updateClient();
        } else {
            NumismaticOverhaul.CHANNEL.clientHandle().send((Record)new ShopScreenHandlerRequestC2SPacket(ShopScreenHandlerRequestC2SPacket.Action.EXTRACT_CURRENCY));
        }
    }

    public void deleteOffer() {
        if (!this.owner.method_37908().field_9236) {
            this.shop.deleteOffer((class_1799)this.tradeEditBuffer.get());
            this.updateClient();
        } else {
            NumismaticOverhaul.CHANNEL.clientHandle().send((Record)new ShopScreenHandlerRequestC2SPacket(ShopScreenHandlerRequestC2SPacket.Action.DELETE_OFFER));
        }
    }

    public void toggleTransfer() {
        if (!this.owner.method_37908().field_9236) {
            this.shop.toggleTransfer();
            this.updateClient();
        } else {
            NumismaticOverhaul.CHANNEL.clientHandle().send((Record)new ShopScreenHandlerRequestC2SPacket(ShopScreenHandlerRequestC2SPacket.Action.TOGGLE_TRANSFER));
        }
    }

    public void handleBufferClick() {
        if (!this.owner.method_37908().field_9236) {
            this.tradeEditBuffer.set((Object)this.method_34255().method_7972());
        } else {
            NumismaticOverhaul.CHANNEL.clientHandle().send((Record)new ShopScreenHandlerRequestC2SPacket(ShopScreenHandlerRequestC2SPacket.Action.CLICK_BUFFER));
        }
    }

    private void updateClient() {
        NumismaticOverhaul.CHANNEL.serverHandle(this.owner).send((Record)new UpdateShopScreenS2CPacket(this.shop));
    }

    public class_1799 getBufferStack() {
        return (class_1799)this.tradeEditBuffer.get();
    }

    public class_1799 method_7601(class_1657 player, int invSlot) {
        return ScreenUtils.handleSlotTransfer((class_1703)this, (int)invSlot, (int)this.shopInventory.method_5439());
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (this.shop != null) {
            this.shop.busy = false;
        }
    }

    private static class AutoHidingSlot
    extends class_1735 {
        private final int targetTab;
        private final boolean hide;

        public AutoHidingSlot(class_1263 inventory, int index, int x, int y, int targetTab, boolean hide) {
            super(inventory, index, x, y);
            this.targetTab = targetTab;
            this.hide = hide;
        }

        @Environment(value=EnvType.CLIENT)
        public boolean method_7682() {
            class_437 class_4372 = class_310.method_1551().field_1755;
            if (!(class_4372 instanceof ShopScreen)) {
                return true;
            }
            ShopScreen screen = (ShopScreen)class_4372;
            return this.hide ? screen.tab() != this.targetTab : screen.tab() == this.targetTab;
        }
    }
}

