/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.numismaticoverhaul.block;

import com.glisco.numismaticoverhaul.NumismaticOverhaul;
import com.glisco.numismaticoverhaul.block.ShopBlockEntity;
import com.glisco.numismaticoverhaul.currency.CurrencyConverter;
import com.glisco.numismaticoverhaul.item.MoneyBagComponent;
import com.glisco.numismaticoverhaul.item.MoneyBagItem;
import com.mojang.serialization.Codec;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.CodecUtils;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_7923;
import net.minecraft.class_9306;
import net.minecraft.class_9323;
import net.minecraft.class_9329;

public record ShopOffer(class_1799 sell, long price) {
    public static final Endec<ShopOffer> ENDEC = StructEndecBuilder.of((StructField)CodecUtils.toEndec((Codec)class_1799.field_51397).fieldOf("sell", ShopOffer::getSellStack), (StructField)Endec.LONG.fieldOf("price", ShopOffer::getPrice), ShopOffer::new);

    public ShopOffer {
        if (sell.method_7960()) {
            throw new IllegalArgumentException("Sell Stack must not be empty");
        }
        if (price == 0L) {
            throw new IllegalArgumentException("Price must not be null");
        }
    }

    public class_1914 toTradeOffer(ShopBlockEntity shop, boolean inexhaustible) {
        boolean isPocketChange = CurrencyConverter.getRequiredCurrencyTypes(this.price) == 1;
        class_1799 buyStack = isPocketChange ? CurrencyConverter.getAsItemStackList(this.price).getFirst() : MoneyBagItem.fromRawValue(this.price);
        int maxUses = inexhaustible ? Integer.MAX_VALUE : ShopOffer.count(shop.getItems(), this.sell) / this.sell.method_7947();
        class_9306 tradedItem = isPocketChange ? new class_9306((class_1935)buyStack.method_7909(), buyStack.method_7947()) : new class_9306(class_7923.field_41178.method_47983((Object)buyStack.method_7909()), 1, class_9329.method_57865((class_9323)class_9323.method_59771((class_9323)class_9323.field_49584, (class_9323)class_9323.method_57827().method_57840(NumismaticOverhaul.MONEY_BAG_COMPONENT, (Object)MoneyBagComponent.of(this.price)).method_57838())), buyStack);
        return new class_1914(tradedItem, this.sell, maxUses, 0, 0.0f);
    }

    public long getPrice() {
        return this.price;
    }

    public class_1799 getSellStack() {
        return this.sell.method_7972();
    }

    public static int count(class_2371<class_1799> stacks, class_1799 testStack) {
        int count = 0;
        for (class_1799 stack : stacks) {
            if (!class_1799.method_31577((class_1799)stack, (class_1799)testStack)) continue;
            count += stack.method_7947();
        }
        return count;
    }

    public static int remove(class_2371<class_1799> stacks, class_1799 removeStack) {
        int toRemove = removeStack.method_7947();
        for (class_1799 stack : stacks) {
            if (!class_1799.method_31577((class_1799)stack, (class_1799)removeStack)) continue;
            int removed = stack.method_7947();
            stack.method_7934(toRemove);
            if ((toRemove -= removed) >= 1) continue;
            break;
        }
        return removeStack.method_7947() - toRemove;
    }

    @Override
    public String toString() {
        return String.valueOf(this.sell) + "@" + this.price + "coins";
    }
}

