/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.numismaticoverhaul.block;

import com.glisco.numismaticoverhaul.NumismaticOverhaul;
import com.glisco.numismaticoverhaul.block.NumismaticOverhaulBlocks;
import com.glisco.numismaticoverhaul.block.ShopBlock;
import com.glisco.numismaticoverhaul.block.ShopMerchant;
import com.glisco.numismaticoverhaul.block.ShopOffer;
import com.glisco.numismaticoverhaul.block.ShopScreenHandler;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.impl.KeyedEndec;
import io.wispforest.owo.ops.WorldOps;
import io.wispforest.owo.serialization.RegistriesAttribute;
import io.wispforest.owo.util.ImplementedInventory;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1915;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShopBlockEntity
extends class_2624
implements ImplementedInventory,
class_1278,
class_3908 {
    private static final int[] SLOTS = IntStream.range(0, 27).toArray();
    private static final int[] NO_SLOTS = new int[0];
    public static KeyedEndec<List<ShopOffer>> OFFERS_LIST = ShopOffer.ENDEC.listOf().keyed("offers", ArrayList::new);
    private class_2371<class_1799> inventory = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
    public boolean busy = false;
    private final class_1915 merchant;
    private List<ShopOffer> offers;
    private long storedCurrency;
    private UUID owner;
    private boolean allowsTransfer = false;
    private int tradeIndex;

    public ShopBlockEntity(class_2338 pos, class_2680 state) {
        super(NumismaticOverhaulBlocks.Entities.SHOP, pos, state);
        ShopBlock shop;
        class_2248 class_22482 = state.method_26204();
        boolean inexhaustible = class_22482 instanceof ShopBlock && (shop = (ShopBlock)class_22482).inexhaustible();
        this.merchant = new ShopMerchant(this, inexhaustible);
        this.offers = new ArrayList<ShopOffer>();
        this.storedCurrency = 0L;
    }

    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public int[] method_5494(class_2350 side) {
        return this.allowsTransfer ? SLOTS : NO_SLOTS;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return this.allowsTransfer;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return false;
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"gui.numismatic-overhaul.shop.inventory_title");
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> inventory) {
        this.inventory = inventory;
    }

    @NotNull
    public ShopMerchant getMerchant() {
        return (ShopMerchant)this.merchant;
    }

    public List<ShopOffer> getOffers() {
        return this.offers;
    }

    public long getStoredCurrency() {
        return this.storedCurrency;
    }

    public boolean isTransferEnabled() {
        return this.allowsTransfer;
    }

    public void toggleTransfer() {
        this.allowsTransfer = !this.allowsTransfer;
    }

    public void setStoredCurrency(long storedCurrency) {
        this.storedCurrency = storedCurrency;
        this.method_5431();
    }

    public void addCurrency(long value) {
        this.storedCurrency += value;
        this.method_5431();
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 registryLookup) {
        super.method_11007(tag, registryLookup);
        class_1262.method_5426((class_2487)tag, this.inventory, (class_7225.class_7874)registryLookup);
        tag.put(SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of((class_5455)this.method_10997().method_30349())}), OFFERS_LIST, this.offers);
        tag.method_10556("AllowsTransfer", this.allowsTransfer);
        tag.method_10544("StoredCurrency", this.storedCurrency);
        if (this.owner != null) {
            tag.method_25927("Owner", this.owner);
        }
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 registryLookup) {
        super.method_11014(tag, registryLookup);
        class_1262.method_5429((class_2487)tag, this.inventory, (class_7225.class_7874)registryLookup);
        this.offers = (List)tag.get(OFFERS_LIST);
        if (tag.method_10545("Owner")) {
            this.owner = tag.method_25926("Owner");
        }
        this.allowsTransfer = tag.method_10577("AllowsTransfer");
        this.storedCurrency = tag.method_10537("StoredCurrency");
    }

    public void addOrReplaceOffer(ShopOffer offer) {
        int indexToReplace = -1;
        for (int i = 0; i < this.offers.size(); ++i) {
            if (!class_1799.method_7973((class_1799)offer.getSellStack(), (class_1799)this.offers.get(i).getSellStack())) continue;
            indexToReplace = i;
            break;
        }
        if (indexToReplace == -1) {
            if (this.offers.size() >= 24) {
                NumismaticOverhaul.LOGGER.error("Tried adding more than 24 trades to shop at {}", (Object)this.field_11867);
                return;
            }
            this.offers.add(offer);
        } else {
            this.offers.set(indexToReplace, offer);
        }
        this.method_5431();
    }

    public void deleteOffer(class_1799 stack) {
        if (!this.offers.removeIf(offer -> class_1799.method_7973((class_1799)stack, (class_1799)offer.getSellStack()))) {
            NumismaticOverhaul.LOGGER.error("Tried to delete invalid trade for {} from shop at {}", (Object)stack, (Object)this.field_11867);
            return;
        }
        this.method_5431();
    }

    public static void tick(class_1937 world, class_2338 ignoredPos, class_2680 ignoredState, ShopBlockEntity blockEntity) {
        blockEntity.tick(world);
    }

    public void tick(class_1937 world) {
        if (world.method_8510() % 60L == 0L) {
            ++this.tradeIndex;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class_1799 getItemToRender() {
        if (this.tradeIndex > this.offers.size() - 1) {
            this.tradeIndex = 0;
        }
        return this.offers.get(this.tradeIndex).getSellStack();
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new ShopScreenHandler(syncId, playerInventory, (class_1263)this);
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_11863 == null) {
            return false;
        }
        return player.method_5667().equals(this.owner) && this.field_11863.method_8321(this.field_11867) == this && player.method_56093(this.field_11867, 10.0);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 tag = new class_2487();
        this.method_11007(tag, registryLookup);
        tag.method_10551("Items");
        tag.method_10551("StoredCurrency");
        return tag;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.method_5431();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void method_5431() {
        super.method_5431();
        WorldOps.updateIfOnServer((class_1937)this.field_11863, (class_2338)this.field_11867);
    }
}

