/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.numismaticoverhaul;

import com.glisco.numismaticoverhaul.NumismaticCommand;
import com.glisco.numismaticoverhaul.NumismaticOverhaulConfig;
import com.glisco.numismaticoverhaul.block.NumismaticOverhaulBlocks;
import com.glisco.numismaticoverhaul.block.PiggyBankScreenHandler;
import com.glisco.numismaticoverhaul.block.ShopScreenHandler;
import com.glisco.numismaticoverhaul.currency.MoneyBagLootEntry;
import com.glisco.numismaticoverhaul.item.MoneyBagComponent;
import com.glisco.numismaticoverhaul.item.MoneyBagItem;
import com.glisco.numismaticoverhaul.item.NumismaticOverhaulItems;
import com.glisco.numismaticoverhaul.network.RequestPurseActionC2SPacket;
import com.glisco.numismaticoverhaul.network.ShopScreenHandlerRequestC2SPacket;
import com.glisco.numismaticoverhaul.network.UpdateShopScreenS2CPacket;
import com.glisco.numismaticoverhaul.villagers.data.VillagerTradesResourceListener;
import com.glisco.numismaticoverhaul.villagers.json.VillagerTradesHandler;
import io.wispforest.owo.itemgroup.Icon;
import io.wispforest.owo.itemgroup.OwoItemGroup;
import io.wispforest.owo.itemgroup.gui.ItemGroupButton;
import io.wispforest.owo.network.OwoNetChannel;
import io.wispforest.owo.ops.LootOps;
import io.wispforest.owo.particles.ClientParticles;
import io.wispforest.owo.particles.systems.ParticleSystem;
import io.wispforest.owo.particles.systems.ParticleSystemController;
import io.wispforest.owo.registration.reflect.FieldRegistrationHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleFactory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1299;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_219;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3414;
import net.minecraft.class_39;
import net.minecraft.class_3917;
import net.minecraft.class_5321;
import net.minecraft.class_5338;
import net.minecraft.class_55;
import net.minecraft.class_6862;
import net.minecraft.class_7701;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9331;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NumismaticOverhaul
implements ModInitializer {
    public static final String MOD_ID = "numismatic-overhaul";
    public static final Logger LOGGER = LogManager.getLogger((String)"numismatic-overhaul");
    public static final OwoNetChannel CHANNEL = OwoNetChannel.create((class_2960)NumismaticOverhaul.id("main"));
    private static final ParticleSystemController PARTICLE_SYSTEMS = new ParticleSystemController(NumismaticOverhaul.id("particles"));
    public static final ParticleSystem<Integer> PIGGY_BANK_BROKEN = PARTICLE_SYSTEMS.register(Integer.class, (world, pos, data) -> {
        ClientParticles.setParticleCount((int)(6 * data));
        ClientParticles.randomizeVelocity((double)2.0);
        ClientParticles.spawnCenteredOnBlock((class_2394)new class_2388(class_2398.field_11217, NumismaticOverhaulBlocks.PIGGY_BANK.method_9564()), (class_1937)world, (class_2338)new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350), (double)0.75);
    });
    public static final class_3917<ShopScreenHandler> SHOP_SCREEN_HANDLER_TYPE = new class_3917(ShopScreenHandler::new, class_7701.field_40183);
    public static final class_3917<PiggyBankScreenHandler> PIGGY_BANK_SCREEN_HANDLER_TYPE = new class_3917(PiggyBankScreenHandler::new, class_7701.field_40183);
    public static final class_3414 PIGGY_BANK_BREAK = class_3414.method_47908((class_2960)NumismaticOverhaul.id("piggy_bank_break"));
    public static final class_5338 MONEY_BAG_ENTRY = new class_5338(MoneyBagLootEntry.CODEC);
    public static final class_6862<class_1299<?>> THE_BOURGEOISIE = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)NumismaticOverhaul.id("the_bourgeoisie"));
    public static final class_6862<class_2248> VERY_HEAVY_BLOCKS = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)NumismaticOverhaul.id("very_heavy_blocks"));
    public static final class_1928.class_4313<class_1928.class_4312> MONEY_DROP_PERCENTAGE = GameRuleRegistry.register((String)"moneyDropPercentage", (class_1928.class_5198)class_1928.class_5198.field_24094, (class_1928.class_4314)GameRuleFactory.createIntRule((int)10, (int)0, (int)100));
    public static final class_1928.class_4313<class_1928.class_4312> MONEY_MOB_DROP_VARIANCE = GameRuleRegistry.register((String)"moneyMobDropVariancePercentage", (class_1928.class_5198)class_1928.class_5198.field_24095, (class_1928.class_4314)GameRuleFactory.createIntRule((int)50, (int)0, (int)100));
    public static final class_9331<MoneyBagComponent> MONEY_BAG_COMPONENT = MoneyBagComponent.register();
    public static final OwoItemGroup NUMISMATIC_GROUP = OwoItemGroup.builder((class_2960)NumismaticOverhaul.id("main"), () -> Icon.of((class_1799)MoneyBagItem.fromRawValue(100L))).initializer(group -> {
        group.addButton(ItemGroupButton.modrinth((class_1761)group, (String)"https://modrinth.com/mod/numismatic-overhaul"));
        group.addButton(ItemGroupButton.curseforge((class_1761)group, (String)"https://www.curseforge.com/minecraft/mc-mods/numismatic-overhaul"));
        group.addButton(ItemGroupButton.github((class_1761)group, (String)"https://github.com/wisp-forest/numismatic-overhaul"));
        group.addButton(ItemGroupButton.discord((class_1761)group, (String)"https://discord.gg/xrwHKktV2d"));
    }).build();
    public static final Map<class_1299<?>, Integer> MOBS_IN_BOURGEOISIE = new HashMap();
    public static final NumismaticOverhaulConfig CONFIG = NumismaticOverhaulConfig.createAndLoad();

    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(NumismaticOverhaul::loadMobDropConfig);
        FieldRegistrationHandler.register(NumismaticOverhaulItems.class, (String)MOD_ID, (boolean)false);
        FieldRegistrationHandler.register(NumismaticOverhaulBlocks.class, (String)MOD_ID, (boolean)false);
        FieldRegistrationHandler.register(NumismaticOverhaulBlocks.Entities.class, (String)MOD_ID, (boolean)false);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)PIGGY_BANK_BREAK.method_14833(), (Object)PIGGY_BANK_BREAK);
        class_2378.method_10230((class_2378)class_7923.field_41133, (class_2960)NumismaticOverhaul.id("money_bag"), (Object)MONEY_BAG_ENTRY);
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)NumismaticOverhaul.id("shop"), SHOP_SCREEN_HANDLER_TYPE);
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)NumismaticOverhaul.id("piggy_bank"), PIGGY_BANK_SCREEN_HANDLER_TYPE);
        CHANNEL.registerServerbound(RequestPurseActionC2SPacket.class, RequestPurseActionC2SPacket::handle);
        CHANNEL.registerServerbound(ShopScreenHandlerRequestC2SPacket.class, ShopScreenHandlerRequestC2SPacket::handle);
        UpdateShopScreenS2CPacket.initialize();
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new VillagerTradesResourceListener());
        VillagerTradesHandler.registerDefaultAdapters();
        CommandRegistrationCallback.EVENT.register(NumismaticCommand::register);
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, serverResourceManager, success) -> {
            VillagerTradesHandler.broadcastErrors(server);
            CONFIG.subscribeToMobsToBaseValues(NumismaticOverhaul::reloadMobDropConfig);
        });
        NUMISMATIC_GROUP.initialize();
        if (CONFIG.generateCurrencyInChests()) {
            LootOps.injectItem((class_1935)NumismaticOverhaulItems.GOLD_COIN, (float)0.01f, (class_2960[])new class_2960[]{class_39.field_683.method_29177(), class_39.field_24046.method_29177(), class_39.field_842.method_29177(), class_39.field_16593.method_29177(), class_39.field_251.method_29177(), class_39.field_356.method_29177(), class_39.field_472.method_29177()});
            LootTableEvents.MODIFY.register((key, tableBuilder, source, registries) -> {
                if (NumismaticOverhaul.anyMatch(key.method_29177(), class_39.field_885.method_29177())) {
                    tableBuilder.method_336(class_55.method_347().method_351(MoneyBagLootEntry.builder(NumismaticOverhaul.CONFIG.lootOptions.desertMinLoot(), NumismaticOverhaul.CONFIG.lootOptions.desertMaxLoot())).method_356(class_219.method_932((float)0.45f)));
                } else if (NumismaticOverhaul.anyMatch(key.method_29177(), class_39.field_356.method_29177(), class_39.field_472.method_29177())) {
                    tableBuilder.method_336(class_55.method_347().method_351(MoneyBagLootEntry.builder(NumismaticOverhaul.CONFIG.lootOptions.dungeonMinLoot(), NumismaticOverhaul.CONFIG.lootOptions.dungeonMaxLoot())).method_356(class_219.method_932((float)0.75f)));
                } else if (NumismaticOverhaul.anyMatch(key.method_29177(), class_39.field_24046.method_29177(), class_39.field_842.method_29177(), class_39.field_16593.method_29177(), class_39.field_251.method_29177())) {
                    tableBuilder.method_336(class_55.method_347().method_351(MoneyBagLootEntry.builder(NumismaticOverhaul.CONFIG.lootOptions.structureMinLoot(), NumismaticOverhaul.CONFIG.lootOptions.structureMaxLoot())).method_356(class_219.method_932((float)0.75f)));
                } else if (NumismaticOverhaul.anyMatch(key.method_29177(), class_39.field_683.method_29177())) {
                    tableBuilder.method_336(class_55.method_347().method_351(MoneyBagLootEntry.builder(NumismaticOverhaul.CONFIG.lootOptions.strongholdLibraryMinLoot(), NumismaticOverhaul.CONFIG.lootOptions.strongholdLibraryMaxLoot())).method_356(class_219.method_932((float)0.85f)));
                }
            });
        }
    }

    private static boolean anyMatch(class_2960 target, class_2960 ... comparisons) {
        for (class_2960 comparison : comparisons) {
            if (!target.equals((Object)comparison)) continue;
            return true;
        }
        return false;
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    private static void loadMobDropConfig(MinecraftServer ignored) {
        CONFIG.mobsToBaseValues().forEach((s, baseValue) -> {
            if (s.startsWith("#")) {
                class_7923.field_41177.method_40266(class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)class_2960.method_60654((String)s.split("#")[1]))).ifPresentOrElse(registryEntries -> registryEntries.forEach(entityTypeRegistryEntry -> MOBS_IN_BOURGEOISIE.put((class_1299<?>)((class_1299)entityTypeRegistryEntry.comp_349()), (Integer)baseValue)), () -> LOGGER.error("[Numismatic Overhaul] Could not find entity type for tag '{}' when applying mob drops", s));
            } else {
                Optional entityOpt = class_7923.field_41177.method_17966(class_2960.method_60654((String)s));
                entityOpt.ifPresentOrElse(entityType -> MOBS_IN_BOURGEOISIE.put((class_1299<?>)entityType, (Integer)baseValue), () -> LOGGER.error("[Numismatic Overhaul] Could not find entity type '{}' when applying mob drops", s));
            }
        });
    }

    private static void reloadMobDropConfig(Map<String, Integer> ignored) {
        MOBS_IN_BOURGEOISIE.clear();
        CONFIG.load();
        NumismaticOverhaul.loadMobDropConfig(null);
    }
}

