/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.vanity.common.util;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public final class XorMapCodec<F, S>
extends MapCodec<Either<F, S>> {
    private final MapCodec<F> first;
    private final MapCodec<S> second;

    public XorMapCodec(MapCodec<F> codec, MapCodec<S> codec2) {
        this.first = codec;
        this.second = codec2;
    }

    public static <F, S> MapCodec<Either<F, S>> create(MapCodec<F> first, MapCodec<S> second) {
        return new XorMapCodec<F, S>(first, second);
    }

    public <T> DataResult<Either<F, S>> decode(DynamicOps<T> ops, MapLike<T> input) {
        DataResult left = this.first.decode(ops, input).map(Either::left);
        DataResult right = this.second.decode(ops, input).map(Either::right);
        Optional leftResult = left.result();
        Optional rightResult = right.result();
        if (leftResult.isPresent() && rightResult.isPresent()) {
            return DataResult.error(() -> "Both alternatives read successfully, can not pick the correct one; first: " + String.valueOf(leftResult.get()) + " second: " + String.valueOf(rightResult.get()), (Object)((Either)leftResult.get()));
        }
        return leftResult.isPresent() ? left : right;
    }

    public <T> RecordBuilder<T> encode(Either<F, S> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        return (RecordBuilder)input.map(object2 -> this.first.encode(object2, ops, prefix), object2 -> this.second.encode(object2, ops, prefix));
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Stream.concat(this.first.keys(ops), this.second.keys(ops));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && ((Object)((Object)this)).getClass() == object.getClass()) {
            XorMapCodec xorCodec = (XorMapCodec)((Object)object);
            return Objects.equals(this.first, xorCodec.first) && Objects.equals(this.second, xorCodec.second);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public String toString() {
        return "XorMapCodec[" + String.valueOf(this.first) + ", " + String.valueOf(this.second) + "]";
    }
}

