/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.vanity.common.registries;

import com.mojang.datafixers.util.Pair;
import com.teamresourceful.resourcefullib.common.collections.WeightedCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_5819;
import net.minecraft.class_9306;
import tech.thatgravyboat.vanity.api.design.Design;
import tech.thatgravyboat.vanity.common.handler.design.ServerDesignManager;
import tech.thatgravyboat.vanity.common.handler.trades.VillagerTrade;
import tech.thatgravyboat.vanity.common.handler.trades.VillagerTradeManager;
import tech.thatgravyboat.vanity.common.handler.trades.WeightedTrade;
import tech.thatgravyboat.vanity.common.item.DesignHelper;
import tech.thatgravyboat.vanity.common.registries.ModProfessions;

public class ModTrades {
    public static void registerTrades(class_3852 profession, int maxTier, int minTier, BiConsumer<Integer, class_3853.class_1652> adder) {
        int i;
        if (profession != ModProfessions.STYLIST.get()) {
            return;
        }
        ArrayList<Pair<class_2960, Design>> designs = new ArrayList<Pair<class_2960, Design>>();
        for (Map.Entry<class_2960, Design> entry : ServerDesignManager.INSTANCE.getAllDesigns().entrySet()) {
            if (!entry.getValue().canBeSold()) continue;
            designs.add(Pair.of((Object)entry.getKey(), (Object)entry.getValue()));
        }
        int basicTrades = Math.min(maxTier, designs.size() + 1);
        int index = 0;
        for (i = minTier; i < basicTrades && !designs.isEmpty(); ++i) {
            adder.accept(i, new DesignListing(designs, index++));
            if (i <= 3) continue;
            adder.accept(i, new DesignListing(designs, index++));
        }
        for (i = minTier; i <= maxTier; ++i) {
            HashMap<String, WeightedCollection> weightedTrades = new HashMap<String, WeightedCollection>();
            for (VillagerTrade trade : VillagerTradeManager.getTrades(i)) {
                if (trade.isDefaultGroup()) {
                    adder.accept(i, trade);
                    continue;
                }
                weightedTrades.computeIfAbsent(trade.group(), s -> new WeightedCollection()).add((double)trade.chance(), (Object)trade);
            }
            for (WeightedCollection value : weightedTrades.values()) {
                adder.accept(i, new WeightedTrade((WeightedCollection<VillagerTrade>)value));
            }
        }
    }

    private record DesignListing(List<Pair<class_2960, Design>> designs, int offset) implements class_3853.class_1652
    {
        private static final int USES = 4;
        private static final int EMERALD_COST = 15;
        private static final int XP_GAIN = 24;
        private static final float PRICE_MULTIPLIER = 0.05f;

        public class_1914 method_7246(class_1297 entity, class_5819 random) {
            class_9306 emeralds = new class_9306((class_1935)class_1802.field_8687, 15 + random.method_43048(16));
            int index = class_3532.method_15382((int)(entity.method_5667().hashCode() + this.offset)) % this.designs.size();
            Pair<class_2960, Design> design = this.designs.get(class_3532.method_15340((int)index, (int)0, (int)(this.designs.size() - 1)));
            return new class_1914(emeralds, DesignHelper.createDesignItem((class_2960)design.getFirst(), (Design)design.getSecond()), 4, 24, 0.05f);
        }
    }
}

