/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.vanity.common.handler.unlockables;

import com.mojang.logging.LogUtils;
import com.teamresourceful.resourcefullib.common.utils.SaveHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.slf4j.Logger;

public class UnlockableSaveHandler
extends SaveHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final UnlockableSaveHandler CLIENT = new UnlockableSaveHandler();
    private static final SaveHandler.HandlerType<UnlockableSaveHandler> TYPE = SaveHandler.HandlerType.create((SaveHandler)CLIENT, UnlockableSaveHandler::new);
    private static final String FILE_NAME = "vanity_unlockables";
    private final Map<UUID, List<class_2960>> unlockables = new HashMap<UUID, List<class_2960>>();

    public static UnlockableSaveHandler get(class_1937 level) {
        return (UnlockableSaveHandler)SaveHandler.read((class_1937)level, TYPE, (String)FILE_NAME);
    }

    public static boolean addUnlockable(class_1937 level, UUID uuid, class_2960 id) {
        UnlockableSaveHandler handler = UnlockableSaveHandler.get(level);
        List<class_2960> unlockables = handler.getUnlockables(uuid);
        if (unlockables.contains(id)) {
            return false;
        }
        unlockables.add(id);
        handler.method_80();
        return true;
    }

    public static void setUnlockables(class_1937 level, UUID uuid, Collection<class_2960> ids) {
        SaveHandler.handle((class_1937)level, UnlockableSaveHandler::get, handler -> {
            List<class_2960> unlockables = handler.getUnlockables(uuid);
            unlockables.clear();
            unlockables.addAll(ids);
        });
    }

    public static List<class_2960> getUnlockables(class_1937 level, UUID uuid) {
        return UnlockableSaveHandler.get(level).getUnlockables(uuid);
    }

    public List<class_2960> getUnlockables(UUID uuid) {
        if (!this.unlockables.containsKey(uuid)) {
            this.unlockables.put(uuid, new ArrayList());
        }
        return this.unlockables.get(uuid);
    }

    public void loadData(class_2487 tag) {
        for (String key : tag.method_10541()) {
            UUID uuid = UUID.fromString(key);
            List<class_2960> unlockables = this.getUnlockables(uuid);
            for (class_2520 listEntry : tag.method_10554(key, 8)) {
                class_2960 id = class_2960.method_12829((String)listEntry.method_10714());
                if (id != null) {
                    unlockables.add(id);
                    continue;
                }
                LOGGER.error("Failed to parse unlockable id: {}", (Object)listEntry.method_10714());
            }
        }
    }

    public void saveData(class_2487 tag) {
        for (Map.Entry<UUID, List<class_2960>> entry : this.unlockables.entrySet()) {
            class_2499 list = new class_2499();
            for (class_2960 id : entry.getValue()) {
                list.add((Object)class_2519.method_23256((String)id.toString()));
            }
            tag.method_10566(entry.getKey().toString(), (class_2520)list);
        }
    }
}

