/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.vanity.common.handler.trades;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import tech.thatgravyboat.vanity.common.handler.trades.VillagerTrade;

public class VillagerTradeManager
extends class_4309 {
    private static final Gson GSON = new Gson();
    private static final String FOLDER = "vanity/trades";
    public static final VillagerTradeManager INSTANCE = new VillagerTradeManager();
    private static final Int2ObjectMap<List<VillagerTrade>> TRADES = new Int2ObjectOpenHashMap();
    private static final Logger LOGGER = LogUtils.getLogger();

    public VillagerTradeManager() {
        super(GSON, FOLDER);
    }

    protected void apply(Map<class_2960, JsonElement> objects, @NotNull class_3300 manager, @NotNull class_3695 profiler) {
        TRADES.clear();
        for (Map.Entry<class_2960, JsonElement> entry : objects.entrySet()) {
            try {
                VillagerTrade trade = (VillagerTrade)VillagerTrade.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).getOrThrow();
                ((List)TRADES.computeIfAbsent(trade.tier(), integer -> new ArrayList())).add(trade);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load trade: " + String.valueOf(entry.getKey()), (Throwable)e);
            }
        }
    }

    public static List<VillagerTrade> getTrades(int tier) {
        return (List)TRADES.getOrDefault(tier, List.of());
    }
}

