/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.vanity.common.handler.design;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamresourceful.resourcefullib.common.network.Packet;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import tech.thatgravyboat.vanity.api.condtional.Conditions;
import tech.thatgravyboat.vanity.api.condtional.conditions.Condition;
import tech.thatgravyboat.vanity.api.design.Design;
import tech.thatgravyboat.vanity.common.Vanity;
import tech.thatgravyboat.vanity.common.handler.design.DesignManagerImpl;
import tech.thatgravyboat.vanity.common.network.NetworkHandler;
import tech.thatgravyboat.vanity.common.network.packets.client.ClientboundSyncDesignsPacket;

public class ServerDesignManager
extends DesignManagerImpl
implements class_3302 {
    public static final ServerDesignManager INSTANCE = new ServerDesignManager();
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ResourceLoader resourceLoader = new ResourceLoader();

    public ClientboundSyncDesignsPacket createPacket() {
        return new ClientboundSyncDesignsPacket(this);
    }

    @NotNull
    public CompletableFuture<Void> method_25931(@NotNull class_3302.class_4045 barrier, @NotNull class_3300 manager, @NotNull class_3695 preparationsProfiler, @NotNull class_3695 reloadProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
        return this.resourceLoader.method_25931(barrier, manager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor).thenRun(() -> {
            if (Vanity.server != null) {
                NetworkHandler.CHANNEL.sendToAllPlayers((Packet)this.createPacket(), Vanity.server);
            }
        });
    }

    private class ResourceLoader
    extends class_4309 {
        private ResourceLoader() {
            super(new Gson(), "vanity/designs");
        }

        protected void apply(Map<class_2960, JsonElement> elements, @NotNull class_3300 resourceManager, @NotNull class_3695 profiler) {
            ServerDesignManager.this.clear();
            for (Map.Entry<class_2960, JsonElement> entry : elements.entrySet()) {
                try {
                    Condition condition;
                    if (ServerDesignManager.this.designs.containsKey(entry.getKey())) {
                        throw new IllegalStateException("Duplicate design: " + String.valueOf(entry.getKey()));
                    }
                    boolean hasConditions = entry.getValue().getAsJsonObject().has("condition");
                    if (hasConditions && !(condition = (Condition)Conditions.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue().getAsJsonObject().get("condition")).getOrThrow()).test()) continue;
                    DataResult result = Design.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue());
                    if (result.error().isPresent() || result.result().isEmpty()) {
                        throw new IOException(((DataResult.Error)result.error().get()).message() + " " + String.valueOf(entry.getValue()));
                    }
                    ServerDesignManager.this.designs.put(entry.getKey(), (Design)result.result().get());
                }
                catch (IOException e) {
                    LOGGER.error("Failed to load design: " + String.valueOf(entry.getKey()), (Throwable)e);
                }
            }
            ServerDesignManager.this.setupDefaults();
        }
    }
}

