/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.vanity.common.handler.design;

import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.vanity.api.design.Design;
import tech.thatgravyboat.vanity.api.design.DesignManager;
import tech.thatgravyboat.vanity.api.style.Style;
import tech.thatgravyboat.vanity.common.item.DesignHelper;

public abstract class DesignManagerImpl
implements DesignManager {
    protected final Map<class_2960, Design> designs = new HashMap<class_2960, Design>();
    protected final Map<class_2960, Design> defaultDesigns = new HashMap<class_2960, Design>();

    public void clear() {
        this.designs.clear();
        this.defaultDesigns.clear();
    }

    public void setupDefaults() {
        this.designs.forEach((id, design) -> {
            if (!design.type().isDefault()) {
                return;
            }
            this.defaultDesigns.put((class_2960)id, (Design)design);
        });
    }

    @Override
    public Optional<Design> getDesign(class_2960 location) {
        return Optional.ofNullable(this.designs.get(location));
    }

    @Override
    public Map<class_2960, Design> getAllDesigns() {
        return Collections.unmodifiableMap(this.designs);
    }

    @Override
    public Map<class_2960, Design> getDefaultDesigns() {
        return Collections.unmodifiableMap(this.defaultDesigns);
    }

    @Override
    @Nullable
    public Design getDesignFromItem(class_1799 stack) {
        return Optional.ofNullable(DesignHelper.getDesign(stack)).flatMap(this::getDesign).orElse(null);
    }

    @Override
    @Nullable
    public Style getStyleFromItem(class_1799 stack) {
        Pair<class_2960, String> style = DesignHelper.getStyle(stack);
        if (style == null) {
            return null;
        }
        return this.getDesign((class_2960)style.getFirst()).map(design -> design.getStyleForItem((String)style.getSecond(), stack)).orElse(null);
    }

    public boolean hasStyle(class_1799 stack) {
        return this.getStyleFromItem(stack) != null;
    }
}

