/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.vanity.common.compat.jei.categories;

import com.google.common.collect.Streams;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.vanity.common.Vanity;
import tech.thatgravyboat.vanity.common.compat.jei.categories.DesignCategoryRecipe;
import tech.thatgravyboat.vanity.common.item.DesignHelper;
import tech.thatgravyboat.vanity.common.registries.ModItems;
import tech.thatgravyboat.vanity.common.util.ComponentConstants;

public class DesignCategory
implements IRecipeCategory<DesignCategoryRecipe> {
    public static final class_2960 ID = Vanity.id("design");
    public static final RecipeType<DesignCategoryRecipe> TYPE = new RecipeType(ID, DesignCategoryRecipe.class);
    private static final class_2960 TEXTURE = Vanity.id("textures/gui/container/jei.png");
    private static final class_2960 EMPTY_SLOT = Vanity.id("textures/gui/container/empty_slot.png");
    private final IGuiHelper helper;
    private final IDrawable background;
    private final IDrawable emptySlot;

    public DesignCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.drawableBuilder(TEXTURE, 0, 0, 120, 18).addPadding(5, 5, 5, 5).setTextureSize(120, 18).build();
        this.emptySlot = helper.drawableBuilder(EMPTY_SLOT, 0, 0, 16, 16).setTextureSize(16, 16).build();
    }

    @NotNull
    public RecipeType<DesignCategoryRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public class_2561 getTitle() {
        return ComponentConstants.JEI_TITLE;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.helper.createDrawableItemStack(ModItems.DESIGN.get().method_7854());
    }

    public void draw(DesignCategoryRecipe recipe, @NotNull IRecipeSlotsView view, @NotNull class_332 graphics, double mouseX, double mouseY) {
        if (!recipe.alwaysAvailable()) {
            return;
        }
        this.emptySlot.draw(graphics, 6, 6);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull DesignCategoryRecipe recipe, @NotNull IFocusGroup focuses) {
        if (class_310.method_1551().method_1562() == null) {
            return;
        }
        class_5455.class_6890 access = class_310.method_1551().method_1562().method_29091();
        class_2378 registry = access.method_33310(class_7924.field_41197).orElse(null);
        if (registry == null) {
            return;
        }
        class_1799 designItem = DesignHelper.createDesignItem(recipe.id(), recipe.design());
        builder.addSlot(RecipeIngredientRole.INPUT, 6, 6).setSlotName("design").addItemStack(recipe.alwaysAvailable() ? class_1799.field_8037 : designItem);
        List items = (List)recipe.style().item().map(tag -> Streams.stream((Iterable)registry.method_40286(tag)).filter(class_6880::method_40227).map(class_6880::comp_349).map(class_1799::new).toList(), item -> item.stream().map(class_1799::new).toList());
        builder.addSlot(RecipeIngredientRole.INPUT, 54, 6).addItemStacks(items);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 6).addItemStacks(items.stream().map(class_1799::method_7972).peek(stack -> DesignHelper.setDesignAndStyle(stack, recipe.id(), recipe.styleId())).toList());
    }
}

