/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.vanity.client.components.list;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4068;
import net.minecraft.class_7845;
import net.minecraft.class_8021;
import net.minecraft.class_8144;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.vanity.client.components.base.BaseParentWidget;
import tech.thatgravyboat.vanity.client.components.list.StyleButton;
import tech.thatgravyboat.vanity.common.Vanity;
import tech.thatgravyboat.vanity.common.item.DesignHelper;

public class StylesListWidget
extends BaseParentWidget {
    private static final int OFFSET = 2;
    private static final class_2960 THUMB = Vanity.id("textures/gui/sprites/scrollbar/thumb.png");
    private static final Comparator<Pair<class_2960, String>> SORTER = Comparator.comparing(o -> (class_2960)o.getFirst()).thenComparing(Pair::getSecond);
    private int oldHash = -1;
    private class_1799 oldStack = class_1799.field_8037;
    private double scroll = 0.0;
    private int lastHeight = 0;
    private boolean scrolling = false;
    private class_7845 layout;

    public StylesListWidget() {
        super(64, 73);
    }

    public void addAll(Map<class_2960, List<String>> designs, class_1799 input) {
        if (designs.hashCode() == this.oldHash && class_1799.method_31577((class_1799)input, (class_1799)this.oldStack)) {
            return;
        }
        this.oldStack = input;
        this.scroll = 0.0;
        this.oldHash = designs.hashCode();
        this.clear();
        ArrayList<Pair<class_2960, String>> pairs = new ArrayList<Pair<class_2960, String>>();
        designs.forEach((design, styles) -> styles.forEach(style -> pairs.add(Pair.of((Object)design, (Object)style))));
        pairs.sort(SORTER);
        pairs.forEach(pair -> this.addRenderableWidget(new StyleButton((class_2960)pair.getFirst(), (String)pair.getSecond(), input)));
        this.setupButtons();
    }

    public void select(class_1799 stack) {
        Pair<class_2960, String> style = DesignHelper.getStyle(stack);
        for (class_339 child : this.children) {
            if (!(child instanceof StyleButton)) continue;
            StyleButton styleButton = (StyleButton)child;
            class_2960 design = (class_2960)class_8144.method_49077(style, Pair::getFirst);
            String styleName = (String)class_8144.method_49077(style, Pair::getSecond);
            styleButton.select(design, styleName, stack.method_7960());
        }
    }

    @Override
    protected void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_44379(this.method_46426() + 2, this.method_46427() + 2, this.method_46426() + 56, this.method_46427() + 71);
        if (this.layout != null) {
            this.layout.method_48229(this.method_46426() + 2, this.method_46427() + 2 - (int)this.scroll);
        }
        mouseX = this.method_49606() ? mouseX : -1;
        mouseY = this.method_49606() ? mouseY : -1;
        for (class_4068 renderable : this.children) {
            renderable.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
        graphics.method_44380();
        if (this.lastHeight > this.field_22759) {
            int scrollbarHeight = Math.round((float)this.field_22759 / (float)this.lastHeight * (float)this.field_22759);
            int middleHeight = scrollbarHeight - 2;
            int splits = middleHeight / 12;
            int remainder = middleHeight % 12;
            int y = this.method_46427() + Math.round((float)this.scroll / (float)this.lastHeight * (float)this.field_22759);
            graphics.method_25302(THUMB, this.method_46426() + 59, y, 0, 0, 5, 1);
            for (int i = 0; i <= splits; ++i) {
                int height;
                int n = height = i == splits ? remainder : 12;
                if (height == 0) continue;
                graphics.method_25302(THUMB, this.method_46426() + 59, y + i * 12 + 1, 0, 1, 5, height);
            }
            graphics.method_25302(THUMB, this.method_46426() + 59, y + scrollbarHeight - 1, 0, 13, 5, 1);
        }
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling) {
            this.scroll = class_3532.method_15350((double)(this.scroll + dragY / (double)(this.field_22759 - 15) * (double)this.lastHeight), (double)0.0, (double)Math.max(0, this.lastHeight - this.field_22759));
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.scroll = class_3532.method_15350((double)(this.scroll - scrollY * 9.0), (double)0.0, (double)Math.max(0, this.lastHeight - this.field_22759));
        return true;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY)) {
            if (this.isOverScrollBar(mouseX) && button == 0) {
                this.scrolling = true;
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.scrolling = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean isOverScrollBar(double mouseX) {
        return mouseX > (double)(this.method_46426() + 59) && this.lastHeight > this.field_22759;
    }

    private void setupButtons() {
        this.lastHeight = 0;
        class_7845.class_7939 layout = new class_7845().method_47610(3);
        for (class_339 child : this.children) {
            layout.method_47612((class_8021)child);
        }
        this.layout = layout.method_48638();
        this.layout.method_48222();
        this.lastHeight = this.layout.method_25364() + 4;
        this.layout.method_48229(this.method_46426() + 2, this.method_46427() + 2 - (int)this.scroll);
    }
}

