/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.vanity.client.compat.geckolib;

import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5602;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_918;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.texture.AnimatableTexture;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.util.RenderUtil;
import tech.thatgravyboat.vanity.client.compat.geckolib.StyledArmorGeoAnimatable;
import tech.thatgravyboat.vanity.mixins.client.armor.AgeableListModelAccessor;
import tech.thatgravyboat.vanity.mixins.client.armor.LevelRenderAccessor;

public class StyledGeoArmorRenderer
extends class_572<class_1309>
implements GeoRenderer<StyledArmorGeoAnimatable> {
    protected final GeoModel<StyledArmorGeoAnimatable> model;
    protected StyledArmorGeoAnimatable animatable;
    protected class_572<?> baseModel;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();
    protected BakedGeoModel lastModel = null;
    protected GeoBone head = null;
    protected GeoBone body = null;
    protected GeoBone rightArm = null;
    protected GeoBone leftArm = null;
    protected GeoBone rightLeg = null;
    protected GeoBone leftLeg = null;
    protected GeoBone rightBoot = null;
    protected GeoBone leftBoot = null;
    protected class_1297 currentEntity = null;
    protected class_1799 currentStack = null;
    protected class_1304 currentSlot = null;

    public StyledGeoArmorRenderer(GeoModel<StyledArmorGeoAnimatable> model) {
        super(class_310.method_1551().method_31974().method_32072(class_5602.field_27579));
        this.model = model;
        this.field_3448 = false;
    }

    public GeoModel<StyledArmorGeoAnimatable> getGeoModel() {
        return this.model;
    }

    public StyledArmorGeoAnimatable getAnimatable() {
        return this.animatable;
    }

    public long getInstanceId(StyledArmorGeoAnimatable animatable) {
        return this.currentEntity.method_5628();
    }

    @NotNull
    public class_1921 getRenderType(StyledArmorGeoAnimatable style, class_2960 texture, @Nullable class_4597 source, float partialTick) {
        return class_1921.method_25448((class_2960)texture);
    }

    public void preRender(class_4587 stack, StyledArmorGeoAnimatable style, BakedGeoModel model, @Nullable class_4597 source, @Nullable class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        this.entityRenderTranslations = new Matrix4f((Matrix4fc)stack.method_23760().method_23761());
        this.applyBaseModel(this.baseModel);
        this.grabRelevantBones(this.getGeoModel().getBakedModel(this.getGeoModel().getModelResource((GeoAnimatable)this.animatable)));
        this.applyBaseTransformations(this.baseModel);
        this.scaleModelForBaby(stack, isReRender);
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, stack, (GeoAnimatable)style, model, isReRender, partialTick, packedLight, packedOverlay);
        if (!(this.currentEntity instanceof GeoAnimatable)) {
            this.method_2805(true);
        }
    }

    public void method_2828(class_4587 stack, @Nullable class_4588 consumer, int packedLight, int packedOverlay, int colour) {
        class_310 mc = class_310.method_1551();
        class_4597.class_4598 bufferSource = mc.method_22940().method_23000();
        LevelRenderAccessor accessor = (LevelRenderAccessor)mc.field_1769;
        if (accessor.getShouldShowEntityOutlines() && mc.method_27022(this.currentEntity)) {
            bufferSource = mc.method_22940().method_23003();
        }
        float partialTick = mc.method_60646().method_60637(true);
        class_1921 renderType = this.getRenderType(this.animatable, this.getTextureLocation((GeoAnimatable)this.animatable), (class_4597)bufferSource, partialTick);
        consumer = class_918.method_27952((class_4597)bufferSource, (class_1921)renderType, (boolean)this.currentStack.method_7958());
        this.defaultRender(stack, (GeoAnimatable)this.animatable, (class_4597)bufferSource, null, consumer, 0.0f, partialTick, packedLight);
        this.animatable = null;
    }

    public void actuallyRender(class_4587 stack, StyledArmorGeoAnimatable style, BakedGeoModel model, @Nullable class_1921 type, class_4597 source, @Nullable class_4588 consumer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        stack.method_22903();
        stack.method_46416(0.0f, 1.5f, 0.0f);
        stack.method_22905(-1.0f, -1.0f, 1.0f);
        if (!isReRender) {
            AnimationState animationState = new AnimationState((GeoAnimatable)style, 0.0f, 0.0f, partialTick, false);
            long instanceId = this.getInstanceId(style);
            animationState.setData(DataTickets.TICK, (Object)style.getTick(this.currentEntity));
            animationState.setData(DataTickets.ITEMSTACK, (Object)this.currentStack);
            animationState.setData(DataTickets.ENTITY, (Object)this.currentEntity);
            animationState.setData(DataTickets.EQUIPMENT_SLOT, (Object)this.currentSlot);
            this.model.addAdditionalStateData((GeoAnimatable)style, instanceId, (arg_0, arg_1) -> ((AnimationState)animationState).setData(arg_0, arg_1));
            this.model.handleAnimations((GeoAnimatable)style, instanceId, animationState, partialTick);
        }
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)stack.method_23760().method_23761());
        if (consumer != null) {
            super.actuallyRender(stack, (GeoAnimatable)style, model, type, source, consumer, isReRender, partialTick, packedLight, packedOverlay, colour);
        }
        stack.method_22909();
    }

    public void renderRecursively(class_4587 stack, StyledArmorGeoAnimatable animatable, GeoBone bone, class_1921 type, class_4597 source, class_4588 consumer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)stack.method_23760().method_23761());
            bone.setModelSpaceMatrix(RenderUtil.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtil.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.entityRenderTranslations));
        }
        super.renderRecursively(stack, (GeoAnimatable)animatable, bone, type, source, consumer, isReRender, partialTick, packedLight, packedOverlay, colour);
    }

    protected void grabRelevantBones(BakedGeoModel model) {
        if (this.lastModel == model) {
            return;
        }
        this.lastModel = model;
        this.head = this.model.getBone("armorHead").orElse(null);
        this.body = this.model.getBone("armorBody").orElse(null);
        this.rightArm = this.model.getBone("armorRightArm").orElse(null);
        this.leftArm = this.model.getBone("armorLeftArm").orElse(null);
        this.rightLeg = this.model.getBone("armorRightLeg").orElse(null);
        this.leftLeg = this.model.getBone("armorLeftLeg").orElse(null);
        this.rightBoot = this.model.getBone("armorRightBoot").orElse(null);
        this.leftBoot = this.model.getBone("armorLeftBoot").orElse(null);
    }

    public void prepForRender(@Nullable class_1297 entity, class_1799 stack, @Nullable class_1304 slot, @Nullable class_572<?> baseModel) {
        if (entity == null || slot == null || baseModel == null) {
            return;
        }
        this.baseModel = baseModel;
        this.currentEntity = entity;
        this.currentStack = stack;
        this.animatable = StyledArmorGeoAnimatable.get(stack);
        this.currentSlot = slot;
    }

    protected void applyBaseModel(class_572<?> baseModel) {
        this.field_3448 = baseModel.field_3448;
        this.field_3400 = baseModel.field_3400;
        this.field_3449 = baseModel.field_3449;
        this.field_3395 = baseModel.field_3395;
        this.field_3399 = baseModel.field_3399;
    }

    protected void applyBaseTransformations(class_572<?> baseModel) {
        if (this.head != null) {
            class_630 headPart = baseModel.field_3398;
            RenderUtil.matchModelPartRot((class_630)headPart, (GeoBone)this.head);
            this.head.updatePosition(headPart.field_3657, -headPart.field_3656, headPart.field_3655);
        }
        if (this.body != null) {
            class_630 bodyPart = baseModel.field_3391;
            RenderUtil.matchModelPartRot((class_630)bodyPart, (GeoBone)this.body);
            this.body.updatePosition(bodyPart.field_3657, -bodyPart.field_3656, bodyPart.field_3655);
        }
        if (this.rightArm != null) {
            class_630 rightArmPart = baseModel.field_3401;
            RenderUtil.matchModelPartRot((class_630)rightArmPart, (GeoBone)this.rightArm);
            this.rightArm.updatePosition(rightArmPart.field_3657 + 5.0f, 2.0f - rightArmPart.field_3656, rightArmPart.field_3655);
        }
        if (this.leftArm != null) {
            class_630 leftArmPart = baseModel.field_27433;
            RenderUtil.matchModelPartRot((class_630)leftArmPart, (GeoBone)this.leftArm);
            this.leftArm.updatePosition(leftArmPart.field_3657 - 5.0f, 2.0f - leftArmPart.field_3656, leftArmPart.field_3655);
        }
        if (this.rightLeg != null) {
            class_630 rightLegPart = baseModel.field_3392;
            RenderUtil.matchModelPartRot((class_630)rightLegPart, (GeoBone)this.rightLeg);
            this.rightLeg.updatePosition(rightLegPart.field_3657 + 2.0f, 12.0f - rightLegPart.field_3656, rightLegPart.field_3655);
            if (this.rightBoot != null) {
                RenderUtil.matchModelPartRot((class_630)rightLegPart, (GeoBone)this.rightBoot);
                this.rightBoot.updatePosition(rightLegPart.field_3657 + 2.0f, 12.0f - rightLegPart.field_3656, rightLegPart.field_3655);
            }
        }
        if (this.leftLeg != null) {
            class_630 leftLegPart = baseModel.field_3397;
            RenderUtil.matchModelPartRot((class_630)leftLegPart, (GeoBone)this.leftLeg);
            this.leftLeg.updatePosition(leftLegPart.field_3657 - 2.0f, 12.0f - leftLegPart.field_3656, leftLegPart.field_3655);
            if (this.leftBoot != null) {
                RenderUtil.matchModelPartRot((class_630)leftLegPart, (GeoBone)this.leftBoot);
                this.leftBoot.updatePosition(leftLegPart.field_3657 - 2.0f, 12.0f - leftLegPart.field_3656, leftLegPart.field_3655);
            }
        }
    }

    public void method_2805(boolean pVisible) {
        super.method_2805(pVisible);
        this.setBoneVisible(this.head, pVisible);
        this.setBoneVisible(this.body, pVisible);
        this.setBoneVisible(this.rightArm, pVisible);
        this.setBoneVisible(this.leftArm, pVisible);
        this.setBoneVisible(this.rightLeg, pVisible);
        this.setBoneVisible(this.leftLeg, pVisible);
        this.setBoneVisible(this.rightBoot, pVisible);
        this.setBoneVisible(this.leftBoot, pVisible);
    }

    public void scaleModelForBaby(class_4587 poseStack, boolean isReRender) {
        if (!this.field_3448 || isReRender) {
            return;
        }
        AgeableListModelAccessor accessor = (AgeableListModelAccessor)this.baseModel;
        if (this.currentSlot == class_1304.field_6169) {
            if (accessor.getScaleHead()) {
                float headScale = 1.5f / accessor.getBabyHeadScale();
                poseStack.method_22905(headScale, headScale, headScale);
            }
            poseStack.method_46416(0.0f, accessor.getBabyYHeadOffset() / 16.0f, accessor.getBabyZHeadOffset() / 16.0f);
        } else {
            float bodyScale = 1.0f / accessor.getBabyBodyScale();
            poseStack.method_22905(bodyScale, bodyScale, bodyScale);
            poseStack.method_46416(0.0f, accessor.getBodyYOffset() / 16.0f, 0.0f);
        }
    }

    protected void setBoneVisible(@Nullable GeoBone bone, boolean visible) {
        if (bone == null) {
            return;
        }
        bone.setHidden(!visible);
    }

    public void updateAnimatedTextureFrame(StyledArmorGeoAnimatable animatable) {
        if (this.currentEntity != null) {
            AnimatableTexture.setAndUpdate((class_2960)this.getTextureLocation((GeoAnimatable)animatable), (int)(this.currentEntity.method_5628() + this.currentEntity.field_6012));
        }
    }

    public void fireCompileRenderLayersEvent() {
    }

    public boolean firePreRenderEvent(class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource, float partialTick, int packedLight) {
        return true;
    }

    public void firePostRenderEvent(class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource, float partialTick, int packedLight) {
    }
}

