/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.ConfigUtils;
import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.io.ConfigIO;
import dev.toma.configuration.config.value.AbstractArrayValue;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.IConfigValueReadable;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Field;
import java.util.regex.Pattern;
import net.minecraft.class_2540;

public class StringArrayValue
extends AbstractArrayValue<String> {
    private Pattern pattern;
    private String defaultElementValue = "";

    public StringArrayValue(ValueData<String[]> valueData) {
        super((ValueData<T[]>)valueData);
    }

    @Override
    public String createElementInstance() {
        return this.defaultElementValue != null ? this.defaultElementValue : "";
    }

    @Override
    protected void readFieldData(Field field) {
        super.readFieldData(field);
        Configurable.StringPattern stringPattern = field.getAnnotation(Configurable.StringPattern.class);
        if (stringPattern != null) {
            String value = stringPattern.value();
            this.defaultElementValue = stringPattern.defaultValue();
            try {
                this.pattern = Pattern.compile(value, stringPattern.flags());
            }
            catch (IllegalArgumentException e) {
                Configuration.LOGGER.error(ConfigIO.MARKER, "Invalid @StringPattern value for {} field - {}", (Object)this.getId(), (Object)e);
            }
            if (this.pattern != null && !this.pattern.matcher(this.defaultElementValue).matches()) {
                throw new IllegalArgumentException(String.format("Invalid config default value '%s' for field '%s' - does not match required pattern \\%s\\", this.defaultElementValue, this.getId(), this.pattern.toString()));
            }
        }
    }

    @Override
    protected String[] validateValue(String[] in) {
        String[] array = super.validateValue((T[])in);
        if (this.pattern != null) {
            for (int i = 0; i < in.length; ++i) {
                String string = in[i];
                if (this.pattern.matcher(string).matches()) continue;
                ConfigUtils.logCorrectedMessage(this.getId() + "[" + i + "]", string, this.defaultElementValue);
                in[i] = this.defaultElementValue;
            }
        }
        return array;
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.writeStringArray(this.getId(), (String[])this.get(IConfigValueReadable.Mode.SAVED));
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.setValue(format.readStringArray(this.getId()));
    }

    public static final class Adapter
    extends TypeAdapter<String[]> {
        @Override
        public void encodeToBuffer(ConfigValue<String[]> value, class_2540 buffer) {
            AbstractArrayValue.saveToBuffer((String[])value.get(), buffer, class_2540::method_10814);
        }

        @Override
        public String[] decodeFromBuffer(ConfigValue<String[]> value, class_2540 buffer) {
            return AbstractArrayValue.readFromBuffer(buffer, String[]::new, class_2540::method_19772);
        }

        @Override
        public ConfigValue<String[]> serialize(TypeAdapter.TypeAttributes<String[]> attributes, Object instance, TypeAdapter.TypeSerializer serializer) throws IllegalAccessException {
            return new StringArrayValue(ValueData.of(attributes));
        }
    }
}

