/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.validate.NumberRange;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.IConfigValueReadable;
import dev.toma.configuration.config.value.NumericValue;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Field;
import net.minecraft.class_2540;

public class FloatValue
extends NumericValue<Float> {
    public FloatValue(ValueData<Float> valueData) {
        super(valueData, Float.valueOf(-3.4028235E38f), Float.valueOf(Float.MAX_VALUE));
    }

    @Override
    protected NumberRange<Float> getValueRange(Field field, Float min, Float max) {
        Configurable.DecimalRange range = field.getAnnotation(Configurable.DecimalRange.class);
        return range != null ? NumberRange.interval(this, Float.valueOf((float)Math.max((double)min.floatValue(), range.min())), Float.valueOf((float)Math.min(range.max(), (double)max.floatValue()))) : NumberRange.all(this);
    }

    @Override
    public Float getValueFromSlider(double sliderValue) {
        NumberRange range = this.getRange();
        float delta = ((Float)range.max()).floatValue() - ((Float)range.min()).floatValue();
        return Float.valueOf(((Float)range.min()).floatValue() + (float)((double)delta * sliderValue));
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.writeFloat(this.getId(), ((Float)this.get(IConfigValueReadable.Mode.SAVED)).floatValue());
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.setValue(Float.valueOf(format.readFloat(this.getId())));
    }

    public static final class Adapter
    extends TypeAdapter<Float> {
        @Override
        public ConfigValue<Float> serialize(TypeAdapter.TypeAttributes<Float> attributes, Object instance, TypeAdapter.TypeSerializer serializer) throws IllegalAccessException {
            return new FloatValue(ValueData.of(attributes));
        }

        @Override
        public void encodeToBuffer(ConfigValue<Float> value, class_2540 buffer) {
            buffer.method_52941(((Float)value.get()).floatValue());
        }

        @Override
        public Float decodeFromBuffer(ConfigValue<Float> value, class_2540 buffer) {
            return Float.valueOf(buffer.readFloat());
        }

        @Override
        public void setFieldValue(Field field, Object instance, Object value) throws IllegalAccessException {
            field.setFloat(instance, ((Float)value).floatValue());
        }
    }
}

