/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.ConfigHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public final class ConfigSaveCommand {
    private static final SuggestionProvider<class_2168> SUGGESTION_PROVIDER = new ConfigSuggestionProvider();
    private static final SimpleCommandExceptionType NOT_ENOUGH_ARGUMENTS = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"text.configuration.command.not_enough_arguments"));
    private static final DynamicCommandExceptionType UNKNOWN_CONFIG = new DynamicCommandExceptionType(t -> class_2561.method_43469((String)"text.configuration.command.unknown_config", (Object[])new Object[]{t}));
    private static final class_2561 TEXT_CONFIGS_SAVED = class_2561.method_43471((String)"text.configuration.command.configs_saved").method_27692(class_124.field_1060);

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"configuration").requires(stack -> stack.method_9259(2))).executes(stack -> {
            throw NOT_ENOUGH_ARGUMENTS.create();
        })).then(class_2170.method_9247((String)"saveAll").executes(context -> ConfigSaveCommand.saveConfig((CommandContext<class_2168>)context, true)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"save").executes(stack -> {
            throw NOT_ENOUGH_ARGUMENTS.create();
        })).then(class_2170.method_9244((String)"configId", (ArgumentType)StringArgumentType.greedyString()).suggests(SUGGESTION_PROVIDER).executes(context -> ConfigSaveCommand.saveConfig((CommandContext<class_2168>)context, false)))));
    }

    private static int saveConfig(CommandContext<class_2168> ctx, boolean isSaveAll) throws CommandSyntaxException {
        ArrayList<String> configsForUpdate = isSaveAll ? new ArrayList<String>(ConfigHolder.getRegisteredConfigs()) : Collections.singletonList((String)ctx.getArgument("configId", String.class));
        for (String configId : configsForUpdate) {
            ConfigHolder holder = Configuration.getConfig(configId).orElseThrow(() -> UNKNOWN_CONFIG.create((Object)configId));
            holder.save();
        }
        ((class_2168)ctx.getSource()).method_9226(() -> TEXT_CONFIGS_SAVED, true);
        return 0;
    }

    private static class ConfigSuggestionProvider
    implements SuggestionProvider<class_2168> {
        private ConfigSuggestionProvider() {
        }

        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
            Collection<String> configs = ConfigHolder.getRegisteredConfigs();
            configs.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }
    }
}

