/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.widget;

import dev.toma.configuration.client.WidgetAdder;
import dev.toma.configuration.client.screen.WidgetPlacerHelper;
import dev.toma.configuration.client.theme.ConfigTheme;
import dev.toma.configuration.client.widget.ContainerWidget;
import dev.toma.configuration.config.validate.AggregatedValidationResult;
import dev.toma.configuration.config.validate.IValidationResult;
import dev.toma.configuration.config.value.ConfigValue;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6382;

public class ConfigEntryWidget
extends ContainerWidget
implements WidgetAdder {
    public static final class_2561 OPEN = class_2561.method_43471((String)"text.configuration.value.open");
    public static final class_2561 APPLY = class_2561.method_43471((String)"text.configuration.value.apply");
    public static final class_2561 REVERT_DEFAULTS = class_2561.method_43471((String)"text.configuration.value.revert.default");
    public static final class_2561 REVERT_DEFAULTS_DIALOG_TEXT = class_2561.method_43471((String)"text.configuration.value.revert.default.dialog");
    public static final class_2561 REVERT_CHANGES = class_2561.method_43471((String)"text.configuration.value.revert.changes");
    public static final class_2561 REVERT_CHANGES_DIALOG_TEXT = class_2561.method_43471((String)"text.configuration.value.revert.changes.dialog");
    private final String configId;
    private final ConfigValue<?> configValue;
    private final List<class_2561> description;
    private final ConfigTheme theme;
    private IValidationResult result = IValidationResult.success();
    private IValidationRenderer renderer;
    private boolean lastHoverState;
    private long hoverTimeStart;

    public ConfigEntryWidget(int x, int y, int w, int h, ConfigValue<?> value, String configId, ConfigTheme theme) {
        this(x, y, w, h, value.getValueData().getTitle(), value, configId, theme);
    }

    public ConfigEntryWidget(int x, int y, int w, int h, class_2561 label, ConfigValue<?> value, String configId, ConfigTheme theme) {
        super(x, y, w, h, label);
        this.configValue = value;
        this.configId = configId;
        this.description = value.getDescription();
        this.theme = theme;
    }

    public void setDescriptionRenderer(IValidationRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public class_2561 getComponentName() {
        return this.method_25369();
    }

    public void method_47399(class_6382 p_169152_) {
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        class_327 font = class_310.method_1551().field_1772;
        ConfigTheme.ConfigEntry configEntry = this.theme.getConfigEntry();
        if (this.field_22762) {
            if (!this.lastHoverState) {
                this.hoverTimeStart = System.currentTimeMillis();
            }
            if (configEntry.hoveredColorBackground() != null) {
                graphics.method_25294(this.method_46426() - 30, this.method_46427() - 2, this.method_55442() + 30, this.method_55443() + 2, configEntry.hoveredColorBackground().intValue());
            }
        }
        IValidationResult validationResult = this.getValidationResult();
        boolean isError = this.hasGuiError();
        class_5250 label = class_2561.method_43470((String)this.method_25369().getString()).method_27696(this.method_25369().method_10866());
        UnaryOperator<class_2583> modifiedStyle = configEntry.modifiedValueStyle();
        if (this.configValue.isChanged() && modifiedStyle != null) {
            label.method_27696((class_2583)modifiedStyle.apply(label.method_10866()));
        }
        int entryLeft = WidgetPlacerHelper.getLeft(this.method_46426(), this.field_22758);
        int n = this.method_46426();
        int n2 = this.method_46427();
        Objects.requireNonNull(font);
        ConfigEntryWidget.drawScrollingString(graphics, font, (class_2561)label, n, entryLeft - 5, n2 + (this.field_22759 - 9) / 2, configEntry.color());
        super.method_48579(graphics, mouseX, mouseY, partialTicks);
        IValidationResult.Severity severity = validationResult.severity();
        boolean validationRendering = false;
        if (severity.isWarningOrError()) {
            validationRendering = true;
            this.renderer.drawIcon(graphics, this, severity);
        }
        if ((isError || this.field_22762) && this.renderer != null) {
            long totalHoverTime = System.currentTimeMillis() - this.hoverTimeStart;
            if (isError || totalHoverTime >= 750L) {
                boolean hasDescription;
                List<class_2561> messages = validationRendering ? validationResult.messages() : this.description;
                List<class_5481> lines = messages.stream().flatMap(text -> font.method_1728((class_5348)text, this.field_22758 / 2).stream()).toList();
                boolean bl = hasDescription = lines.size() > 1 || lines.size() == 1 && !((class_5481)lines.getFirst()).equals((Object)class_5244.field_39003);
                if (hasDescription) {
                    this.renderer.drawDescription(graphics, this, lines, severity, severity.textColor);
                }
            }
        }
        this.lastHoverState = this.field_22762;
    }

    @Override
    public void setValidationResult(IValidationResult result) {
        this.result = result;
    }

    @Override
    public <W extends class_339> W addConfigWidget(boolean editableCheck, WidgetAdder.ToWidgetFunction<W> function) {
        W widget = function.asWidget(this.method_46426(), this.method_46427(), this.field_22758, this.field_22759, this.configId);
        if (editableCheck) {
            ((class_339)widget).field_22763 = this.configValue.isEditable();
        }
        return this.addRenderableWidget(widget);
    }

    public static void drawScrollingString(class_332 graphics, class_327 font, class_2561 text, int x1, int x2, int y, int color) {
        int maxWidth = x2 - x1;
        int width = font.method_27525((class_5348)text);
        if (width <= maxWidth) {
            graphics.method_27535(font, text, x1, y, color);
        } else {
            Objects.requireNonNull(font);
            class_339.method_52718((class_332)graphics, (class_327)font, (class_2561)text, (int)x1, (int)y, (int)x2, (int)(y + 9), (int)color);
        }
    }

    private IValidationResult getValidationResult() {
        IValidationResult valueResult = this.configValue.getValidationResult() != null ? this.configValue.getValidationResult() : IValidationResult.success();
        return valueResult.severity().isHigherSeverityThan(this.result.severity()) ? valueResult : this.result;
    }

    private boolean hasGuiError() {
        IValidationResult result = this.getValidationResult();
        return !result.severity().isValid() && !(result instanceof AggregatedValidationResult);
    }

    public static interface IValidationRenderer {
        public void drawIcon(class_332 var1, class_339 var2, IValidationResult.Severity var3);

        public void drawDescription(class_332 var1, class_339 var2, List<class_5481> var3, IValidationResult.Severity var4, int var5);
    }
}

