/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.theme.adapter;

import dev.toma.configuration.client.ClientErrors;
import dev.toma.configuration.client.WidgetAdder;
import dev.toma.configuration.client.screen.WidgetPlacerHelper;
import dev.toma.configuration.client.theme.ConfigTheme;
import dev.toma.configuration.client.theme.adapter.AbstractDisplayAdapter;
import dev.toma.configuration.client.widget.ColorWidget;
import dev.toma.configuration.client.widget.EditBoxWidget;
import dev.toma.configuration.client.widget.ThemedButtonWidget;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.ConfigUtils;
import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.validate.IValidationResult;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.StringValue;
import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class StringDisplayAdapter
extends AbstractDisplayAdapter {
    @Override
    public void placeWidgets(ConfigHolder<?> holder, ConfigValue<?> value, Field field, ConfigTheme theme, WidgetAdder container) {
        Configurable.Gui.ColorValue colorValue = field.getAnnotation(Configurable.Gui.ColorValue.class);
        StringValue stringValue = (StringValue)value;
        class_327 font = class_310.method_1551().field_1772;
        EditBoxWidget editBox = container.addConfigWidget((x, y, width, height, configId) -> {
            int left = WidgetPlacerHelper.getLeft(x, width);
            int widgetWidth = WidgetPlacerHelper.getWidth(width);
            if (colorValue != null) {
                left += 21;
                widgetWidth -= 21;
            }
            return new EditBoxWidget(left, y, widgetWidth, height, theme, font);
        });
        editBox.setValue((String)stringValue.get());
        editBox.setResponder(text -> this.onTextChanged((String)text, stringValue, container, editBox));
        editBox.setBackgroundRenderer(theme.getEditBoxBackground(editBox));
        ConfigUtils.adjustCharacterLimit(field, editBox);
        AbstractDisplayAdapter.ValueReverter reverter = useDefault -> editBox.setValue(useDefault ? (String)stringValue.getValueData().getDefaultValue() : (String)stringValue.getActiveValue());
        ThemedButtonWidget revert = this.createRevertButton(editBox, value, theme, container, reverter);
        ThemedButtonWidget revertDefault = this.createRevertToDefaultButton(editBox, value, theme, container, reverter);
        this.attachDefaultChangeListeners(stringValue, editBox, revert, revertDefault);
        if (colorValue != null) {
            ColorWidget colorWidget = this.createColorSelectorWidget(colorValue, container, editBox);
            this.attachDefaultChangeListeners(stringValue, colorWidget, revert, revertDefault);
        }
    }

    protected ColorWidget createColorSelectorWidget(Configurable.Gui.ColorValue colorValue, WidgetAdder container, EditBoxWidget editBox) {
        ConfigTheme theme = editBox.getTheme();
        ColorWidget widget = container.addConfigWidget((x, y, width, height, configId) -> {
            int left = WidgetPlacerHelper.getLeft(x, width);
            int widgetWidth = 20;
            ColorWidget.GetSet<String> getSet = ColorWidget.GetSet.of(editBox::getValue, editBox::setValue);
            class_437 currentScreen = class_310.method_1551().field_1755;
            return new ColorWidget(left, y, widgetWidth, height, theme, colorValue, getSet, currentScreen);
        });
        widget.setBackgroundRenderer(theme.getColorBackground(widget));
        return widget;
    }

    private void onTextChanged(String text, StringValue value, WidgetAdder container, EditBoxWidget editBox) {
        Matcher matcher;
        Pattern pattern = value.getPattern();
        if (pattern != null && !(matcher = pattern.matcher(text)).matches()) {
            String errorMessage = value.getErrorDescriptor();
            class_5250 errorLabel = errorMessage != null ? class_2561.method_43469((String)errorMessage, (Object[])new Object[]{text, pattern.toString()}) : ClientErrors.invalidText(text, pattern);
            container.setValidationResult(IValidationResult.error((class_2561)errorLabel));
            return;
        }
        container.setOkStatus();
        value.setValue(text);
        editBox.setChanged();
    }
}

