/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.theme.adapter;

import dev.toma.configuration.client.ClientErrors;
import dev.toma.configuration.client.WidgetAdder;
import dev.toma.configuration.client.screen.WidgetPlacerHelper;
import dev.toma.configuration.client.theme.ConfigTheme;
import dev.toma.configuration.client.theme.adapter.AbstractDisplayAdapter;
import dev.toma.configuration.client.widget.EditBoxWidget;
import dev.toma.configuration.client.widget.SliderWidget;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.ConfigUtils;
import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.validate.IValidationResult;
import dev.toma.configuration.config.validate.NumberRange;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.NumericValue;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;

public abstract class AbstractNumericDisplayAdapter
extends AbstractDisplayAdapter {
    public static final Pattern INTEGER_CHARS_PATTERN = Pattern.compile("^[-0-9]+$");
    public static final Pattern DECIMAL_CHARS_PATTERN = Pattern.compile("^[-0-9.Ee]+$");

    @Override
    public final void placeWidgets(ConfigHolder<?> holder, ConfigValue<?> value, Field field, ConfigTheme theme, WidgetAdder container) {
        boolean isSlider = field.isAnnotationPresent(Configurable.Gui.Slider.class);
        if (isSlider) {
            this.placeSlider(holder, value, field, theme, container);
        } else {
            this.placeTextField(holder, value, field, theme, container);
        }
    }

    protected abstract void placeTextField(ConfigHolder<?> var1, ConfigValue<?> var2, Field var3, ConfigTheme var4, WidgetAdder var5);

    protected abstract void placeSlider(ConfigHolder<?> var1, ConfigValue<?> var2, Field var3, ConfigTheme var4, WidgetAdder var5);

    protected <T extends Number> void placeEditBoxControls(NumericValue<T> value, ConfigTheme theme, EditBoxWidget widget, WidgetAdder container) {
        AbstractDisplayAdapter.ValueReverter reverter = useDefault -> widget.setValue(String.valueOf(useDefault ? value.getValueData().getDefaultValue() : value.getActiveValue()));
        this.createControls(widget, value, theme, container, reverter);
    }

    protected <T extends Number> void placeSliderControls(NumericValue<T> value, ConfigTheme theme, SliderWidget<T> widget, WidgetAdder container) {
        AbstractDisplayAdapter.ValueReverter reverter = useDefault -> widget.setValue(value.getSliderValue(useDefault ? (Number)((Number)value.getValueData().getDefaultValue()) : (Number)((Number)value.getActiveValue())));
        this.createControls(widget, value, theme, container, reverter);
    }

    public <T extends Number> EditBoxWidget initEditBox(WidgetAdder container, ConfigTheme theme, NumericValue<T> value, Field field) {
        class_327 font = class_310.method_1551().field_1772;
        EditBoxWidget editBoxWidget = container.addConfigWidget((x, y, width, height, configId) -> {
            int left = WidgetPlacerHelper.getLeft(x, width);
            int widgetWidth = WidgetPlacerHelper.getWidth(width);
            return new EditBoxWidget(left, y, widgetWidth, height, theme, font);
        });
        editBoxWidget.setValue(((Number)value.get()).toString());
        editBoxWidget.setBackgroundRenderer(theme.getEditBoxBackground(editBoxWidget));
        ConfigUtils.adjustCharacterLimit(field, editBoxWidget);
        DecimalFormat decimalFormat = ConfigUtils.getDecimalFormat(field);
        editBoxWidget.setFormatter(decimalFormat, value::get);
        return editBoxWidget;
    }

    public <T extends Number> SliderWidget<T> initSlider(WidgetAdder container, ConfigTheme theme, NumericValue<T> value, Field field) {
        class_327 font = class_310.method_1551().field_1772;
        SliderWidget slider = container.addConfigWidget((x, y, width, height, configId) -> {
            int left = WidgetPlacerHelper.getLeft(x, width);
            int widgetWidth = WidgetPlacerHelper.getWidth(width);
            return new SliderWidget(left, y, widgetWidth, height, theme, value, font);
        });
        slider.setBackgroundRenderer(theme.getSliderBackground(slider));
        slider.setHandleRenderer(theme.getSliderHandle(slider));
        DecimalFormat decimalFormat = ConfigUtils.getDecimalFormat(field);
        slider.setFormatter(decimalFormat);
        return slider;
    }

    public <T extends Number> void handleValueChanged(EditBoxWidget editBox, NumericValue<T> value, Function<String, T> parser, WidgetAdder container) {
        editBox.setResponder(text -> {
            Number parsed;
            try {
                parsed = (Number)parser.apply((String)text);
            }
            catch (NumberFormatException e) {
                container.setValidationResult(IValidationResult.error((class_2561)ClientErrors.notANumber(text)));
                return;
            }
            NumberRange<Number> range = value.getRange();
            if (!range.isWithinRange(parsed)) {
                container.setValidationResult(IValidationResult.error((class_2561)ClientErrors.outOfBounds(parsed, range)));
                return;
            }
            container.setOkStatus();
            value.setValue(parsed);
            editBox.setChanged();
        });
    }

    public static boolean allowIntegerCharacters(String text) {
        Matcher matcher = INTEGER_CHARS_PATTERN.matcher(text);
        return text.isEmpty() || matcher.matches();
    }

    public static boolean allowDecimalCharacters(String text) {
        Matcher matcher = DECIMAL_CHARS_PATTERN.matcher(text);
        return text.isEmpty() || matcher.matches();
    }
}

