/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.screen;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.ConfigurationSettings;
import dev.toma.configuration.client.ConfigurationClient;
import dev.toma.configuration.client.screen.ConfigSettingsScreen;
import dev.toma.configuration.client.screen.DialogScreen;
import dev.toma.configuration.client.theme.ConfigTheme;
import dev.toma.configuration.client.widget.ConfigEntryWidget;
import dev.toma.configuration.client.widget.ThemedButtonWidget;
import dev.toma.configuration.client.widget.render.TextureRenderer;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.io.ConfigIO;
import dev.toma.configuration.config.validate.IValidationResult;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.ObjectValue;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5481;
import net.minecraft.class_7919;
import net.minecraft.class_8666;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public abstract class AbstractConfigScreen
extends class_437
implements ConfigEntryWidget.IValidationRenderer {
    public static final int HEADER_HEIGHT = 35;
    public static final int FOOTER_HEIGHT = 30;
    public static final class_8666 BUTTON_SPRITES = new class_8666(class_2960.method_60656((String)"widget/button"), class_2960.method_60656((String)"widget/button_disabled"), class_2960.method_60656((String)"widget/button_highlighted"));
    public static final Marker MARKER = MarkerManager.getMarker((String)"Screen");
    public static final class_2561 LABEL_BACK = class_2561.method_43471((String)"text.configuration.value.back");
    public static final class_2561 LABEL_SAVE_AND_CLOSE = class_2561.method_43471((String)"text.configuration.value.save_and_close");
    public static final class_2960 ICON_REVERT = class_2960.method_60655((String)"configuration", (String)"textures/icons/revert.png");
    public static final class_2960 ICON_REVERT_DEFAULT = class_2960.method_60655((String)"configuration", (String)"textures/icons/revert_default.png");
    public static final class_2960 ICON_APPLY = class_2960.method_60655((String)"configuration", (String)"textures/icons/apply.png");
    protected final ConfigHolder<?> holder;
    protected final ConfigTheme theme;
    protected final class_437 last;
    protected int index;
    protected int pageSize;
    private ThemedButtonWidget applyButton;
    private ThemedButtonWidget revertButton;
    private ThemedButtonWidget revertDefaultButton;

    public AbstractConfigScreen(class_2561 title, class_437 previous, ConfigHolder<?> configHolder) {
        super(title);
        this.holder = configHolder;
        this.theme = ConfigurationClient.getConfigTheme(configHolder);
        this.last = previous;
        ConfigurationSettings.loadSettings();
    }

    public String getConfigId() {
        return this.holder.getConfigId();
    }

    public void method_25419() {
        super.method_25419();
        this.saveConfig(true);
    }

    public static void renderScrollbar(class_332 graphics, int x, int y, int width, int height, int index, int valueCount, int paging, int bgColor) {
        if (valueCount <= paging) {
            return;
        }
        double step = (double)height / (double)valueCount;
        int min = class_3532.method_15357((double)((double)index * step));
        int max = class_3532.method_15384((double)((double)(index + paging) * step));
        int y1 = y + min;
        int y2 = y + max;
        graphics.method_25294(x, y, x + width, y + height, bgColor);
        graphics.method_25294(x, y1, x + width, y2, -7829368);
        graphics.method_25294(x, y1, x + width - 1, y2 - 1, -1118482);
        graphics.method_25294(x + 1, y1 + 1, x + width - 1, y2 - 1, -3355444);
    }

    protected void addSettingsButton() {
        ThemedButtonWidget settings = (ThemedButtonWidget)this.method_37063((class_364)new ThemedButtonWidget(this.field_22789 - 25, 5, 20, 20, (class_2561)class_2561.method_43470((String)"..."), this.theme));
        settings.setBackgroundRenderer(this.theme.getButtonBackground(settings));
        settings.setClickListener((widget, mouseX, mouseY) -> {
            ConfigSettingsScreen settingsScreen = new ConfigSettingsScreen(this);
            this.field_22787.method_1507((class_437)settingsScreen);
        });
        settings.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.title")));
        settings.method_47402(Duration.ofMillis(300L));
    }

    protected void addFooter() {
        int centerY = this.field_22790 - 30 + 5;
        class_2561 backLabel = this.isRoot() ? LABEL_SAVE_AND_CLOSE : LABEL_BACK;
        ThemedButtonWidget backButton = (ThemedButtonWidget)this.method_37063((class_364)new ThemedButtonWidget(5, centerY, 120, 20, backLabel, this.theme));
        backButton.setBackgroundRenderer(this.theme.getButtonBackground(backButton));
        backButton.setClickListener((widget, mouseX, mouseY) -> this.buttonBackClicked());
        this.applyButton = (ThemedButtonWidget)this.method_37063((class_364)new ThemedButtonWidget(this.field_22789 - 25, centerY, 20, 20, class_5244.field_39003, this.theme));
        this.applyButton.setBackgroundRenderer(this.theme.getButtonBackground(this.applyButton));
        this.applyButton.setForegroundRenderer(new TextureRenderer(ICON_APPLY, 2, 2, 16, 16));
        this.applyButton.setClickListener((widget, mouseX, mouseY) -> {
            if (this.holder.isChanged()) {
                this.holder.save();
                this.method_25423(this.field_22787, this.field_22789, this.field_22790);
            }
        });
        this.applyButton.method_47400(class_7919.method_47407((class_2561)ConfigEntryWidget.APPLY));
        this.applyButton.method_47402(Duration.ofMillis(300L));
        this.applyButton.field_22763 = this.holder.isChanged();
        this.revertDefaultButton = (ThemedButtonWidget)this.method_37063((class_364)new ThemedButtonWidget(this.field_22789 - 50, centerY, 20, 20, class_5244.field_39003, this.theme));
        this.revertDefaultButton.setBackgroundRenderer(this.theme.getButtonBackground(this.revertDefaultButton));
        this.revertDefaultButton.setForegroundRenderer(new TextureRenderer(ICON_REVERT_DEFAULT, 2, 2, 16, 16));
        this.revertDefaultButton.setClickListener((widget, mouseX, mouseY) -> this.buttonRevertToDefaultClicked());
        this.revertDefaultButton.method_47400(class_7919.method_47407((class_2561)ConfigEntryWidget.REVERT_DEFAULTS));
        this.revertDefaultButton.method_47402(Duration.ofMillis(300L));
        this.revertDefaultButton.field_22763 = this.holder.isChangedFromDefault();
        this.revertButton = (ThemedButtonWidget)this.method_37063((class_364)new ThemedButtonWidget(this.field_22789 - 75, centerY, 20, 20, class_5244.field_39003, this.theme));
        this.revertButton.setBackgroundRenderer(this.theme.getButtonBackground(this.revertButton));
        this.revertButton.setForegroundRenderer(new TextureRenderer(ICON_REVERT, 2, 2, 16, 16));
        this.revertButton.setClickListener((widget, mouseX, mouseY) -> this.buttonRevertChangesClicked());
        this.revertButton.method_47400(class_7919.method_47407((class_2561)ConfigEntryWidget.REVERT_CHANGES));
        this.revertButton.method_47402(Duration.ofMillis(300L));
        this.revertButton.field_22763 = this.holder.isChanged();
    }

    public void method_25393() {
        if (this.applyButton != null) {
            this.applyButton.field_22763 = this.holder.isChanged();
        }
        if (this.revertDefaultButton != null) {
            this.revertDefaultButton.field_22763 = this.holder.isChangedFromDefault();
        }
        if (this.revertButton != null) {
            this.revertButton.field_22763 = this.holder.isChanged();
        }
    }

    protected void correctScrollingIndex(int count) {
        if (this.index + this.pageSize > count) {
            this.index = Math.max(count - this.pageSize, 0);
        }
    }

    protected boolean isRoot() {
        return !(this.last instanceof AbstractConfigScreen);
    }

    private void buttonBackClicked() {
        this.field_22787.method_1507(this.last);
        this.saveConfig();
    }

    private void buttonRevertToDefaultClicked() {
        DialogScreen dialog = new DialogScreen(ConfigEntryWidget.REVERT_DEFAULTS, new class_2561[]{ConfigEntryWidget.REVERT_DEFAULTS_DIALOG_TEXT}, this);
        dialog.onConfirmed(screen -> {
            Configuration.LOGGER.info(MARKER, "Reverting config {} to default values", (Object)this.getConfigId());
            this.revertToDefault(this.holder.values());
            ConfigIO.saveClientValues(this.holder);
            dialog.displayPreviousScreen();
        });
        this.field_22787.method_1507((class_437)dialog);
    }

    private void buttonRevertChangesClicked() {
        DialogScreen dialog = new DialogScreen(ConfigEntryWidget.REVERT_CHANGES, new class_2561[]{ConfigEntryWidget.REVERT_CHANGES_DIALOG_TEXT}, this);
        dialog.onConfirmed(screen -> {
            ConfigIO.reloadClientValues(this.holder);
            dialog.displayPreviousScreen();
        });
        this.field_22787.method_1507((class_437)dialog);
    }

    private void revertToDefault(Collection<ConfigValue<?>> configValues) {
        configValues.forEach(val -> {
            if (val instanceof ObjectValue) {
                ObjectValue objVal = (ObjectValue)val;
                this.revertToDefault(((Map)objVal.get()).values());
            } else if (val.isChangedFromDefault()) {
                val.forceSetDefaultValue();
            }
        });
    }

    private void saveConfig() {
        this.saveConfig(false);
    }

    private void saveConfig(boolean force) {
        if (force || this.isRoot()) {
            ConfigIO.saveClientValues(this.holder);
        }
    }

    @Override
    public void drawDescription(class_332 graphics, class_339 widget, List<class_5481> text, IValidationResult.Severity severity, int textColor) {
        this.renderValidationText(severity, graphics, text, widget.method_46426() + 5, widget.method_46427() + widget.method_25364() + 10, textColor);
    }

    @Override
    public void drawIcon(class_332 graphics, class_339 widget, IValidationResult.Severity severity) {
        this.renderValidationIcon(severity, graphics, widget, widget.method_46426() - 22, widget.method_46427() + 1);
    }

    public void renderValidationIcon(IValidationResult.Severity severity, class_332 graphics, class_339 widget, int x, int y) {
        class_2960 icon = severity.iconPath;
        graphics.method_25291(icon, x, y, 0, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    public void renderValidationText(IValidationResult.Severity severity, class_332 graphics, List<class_5481> texts, int mouseX, int mouseY, int textColor) {
        if (!texts.isEmpty()) {
            int maxTextWidth = 0;
            for (class_5481 textComponent : texts) {
                int textWidth = this.field_22793.method_30880(textComponent);
                if (textWidth <= maxTextWidth) continue;
                maxTextWidth = textWidth;
            }
            int startX = mouseX + 12;
            int startY = mouseY - 12;
            int heightOffset = 8;
            if (texts.size() > 1) {
                heightOffset += 2 + (texts.size() - 1) * 10;
            }
            if (startX + maxTextWidth > this.field_22789) {
                startX -= 28 + maxTextWidth;
            }
            if (startY + heightOffset + 6 > this.field_22790) {
                startY = this.field_22790 - heightOffset - 6;
            }
            class_4587 stack = graphics.method_51448();
            stack.method_22903();
            int background = severity.backgroundColor;
            int fadeMin = severity.backgroundFadeMinColor;
            int fadeMax = severity.backgroundFadeMaxColor;
            int zIndex = 400;
            graphics.method_33284(startX - 3, startY - 4, startX + maxTextWidth + 3, startY - 3, zIndex, background, background);
            graphics.method_33284(startX - 3, startY + heightOffset + 3, startX + maxTextWidth + 3, startY + heightOffset + 4, zIndex, background, background);
            graphics.method_33284(startX - 3, startY - 3, startX + maxTextWidth + 3, startY + heightOffset + 3, zIndex, background, background);
            graphics.method_33284(startX - 4, startY - 3, startX - 3, startY + heightOffset + 3, zIndex, background, background);
            graphics.method_33284(startX + maxTextWidth + 3, startY - 3, startX + maxTextWidth + 4, startY + heightOffset + 3, zIndex, background, background);
            graphics.method_33284(startX - 3, startY - 3 + 1, startX - 3 + 1, startY + heightOffset + 3 - 1, zIndex, fadeMin, fadeMax);
            graphics.method_33284(startX + maxTextWidth + 2, startY - 3 + 1, startX + maxTextWidth + 3, startY + heightOffset + 3 - 1, zIndex, fadeMin, fadeMax);
            graphics.method_33284(startX - 3, startY - 3, startX + maxTextWidth + 3, startY - 3 + 1, zIndex, fadeMin, fadeMin);
            graphics.method_33284(startX - 3, startY + heightOffset + 2, startX + maxTextWidth + 3, startY + heightOffset + 3, zIndex, fadeMax, fadeMax);
            stack.method_22904(0.0, 0.0, (double)zIndex);
            for (int i = 0; i < texts.size(); ++i) {
                class_5481 textComponent = texts.get(i);
                graphics.method_51430(this.field_22793, textComponent, startX, startY, textColor, false);
                if (i == 0) {
                    startY += 2;
                }
                startY += 10;
            }
            stack.method_22909();
        }
    }
}

