/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.crafting;

import java.util.Collection;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.craftingtweaks.crafting.IngredientCacheHint;
import net.blay09.mods.craftingtweaks.crafting.IngredientProvider;
import net.blay09.mods.craftingtweaks.crafting.IngredientToken;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;

public class ContainerIngredientProvider
implements IngredientProvider {
    private final class_1263 container;

    public ContainerIngredientProvider(class_1263 container) {
        this.container = container;
    }

    @Override
    public IngredientToken findIngredient(class_1856 ingredient, Collection<IngredientToken> ingredientTokens, IngredientCacheHint cacheHint) {
        class_1799 slotStack;
        if (cacheHint instanceof ContainerIngredientToken) {
            ContainerIngredientToken containerIngredientToken = (ContainerIngredientToken)cacheHint;
            slotStack = this.container.method_5438(containerIngredientToken.slot);
            if (ingredient.method_8093(slotStack) && this.hasUsesLeft(containerIngredientToken.slot, slotStack, ingredientTokens)) {
                return containerIngredientToken;
            }
        }
        for (int i = 0; i < this.container.method_5439(); ++i) {
            slotStack = this.container.method_5438(i);
            if (!ingredient.method_8093(slotStack) || !this.hasUsesLeft(i, slotStack, ingredientTokens)) continue;
            return new ContainerIngredientToken(i);
        }
        return null;
    }

    @Override
    public IngredientToken findIngredient(class_1799 itemStack, Collection<IngredientToken> ingredientTokens, IngredientCacheHint cacheHint) {
        class_1799 slotStack;
        if (cacheHint instanceof ContainerIngredientToken) {
            ContainerIngredientToken containerIngredientToken = (ContainerIngredientToken)cacheHint;
            slotStack = this.container.method_5438(containerIngredientToken.slot);
            if (class_1799.method_31577((class_1799)slotStack, (class_1799)itemStack) && this.hasUsesLeft(containerIngredientToken.slot, slotStack, ingredientTokens)) {
                return containerIngredientToken;
            }
        }
        for (int i = 0; i < this.container.method_5439(); ++i) {
            slotStack = this.container.method_5438(i);
            if (!class_1799.method_31577((class_1799)slotStack, (class_1799)itemStack) || !this.hasUsesLeft(i, slotStack, ingredientTokens)) continue;
            return new ContainerIngredientToken(i);
        }
        return null;
    }

    protected int getUsesLeft(int slot, class_1799 slotStack, Collection<IngredientToken> ingredientTokens) {
        int usesLeft = slotStack.method_7947();
        for (IngredientToken ingredientToken : ingredientTokens) {
            if (!(ingredientToken instanceof ContainerIngredientToken)) continue;
            ContainerIngredientToken containerIngredientToken = (ContainerIngredientToken)ingredientToken;
            if (containerIngredientToken.slot != slot) continue;
            --usesLeft;
        }
        return usesLeft;
    }

    @Override
    public IngredientCacheHint getCacheHint(IngredientToken ingredientToken) {
        IngredientCacheHint ingredientCacheHint;
        if (ingredientToken instanceof ContainerIngredientToken) {
            ContainerIngredientToken containerIngredientToken = (ContainerIngredientToken)ingredientToken;
            ingredientCacheHint = containerIngredientToken;
        } else {
            ingredientCacheHint = IngredientCacheHint.NONE;
        }
        return ingredientCacheHint;
    }

    private boolean hasUsesLeft(int slot, class_1799 slotStack, Collection<IngredientToken> ingredientTokens) {
        return this.getUsesLeft(slot, slotStack, ingredientTokens) > 0;
    }

    public class ContainerIngredientToken
    implements IngredientToken,
    IngredientCacheHint {
        private final int slot;
        private boolean returnRemainder;

        public ContainerIngredientToken(int slot) {
            this.slot = slot;
        }

        @Override
        public class_1799 peek() {
            return ContainerIngredientProvider.this.container.method_5438(this.slot);
        }

        @Override
        public class_1799 consume() {
            class_1799 consumed = ContainerUtils.extractItem((class_1263)ContainerIngredientProvider.this.container, (int)this.slot, (int)1, (boolean)false);
            if (this.returnRemainder) {
                class_1799 remainingItem = Balm.getHooks().getCraftingRemainingItem(consumed);
                ContainerUtils.insertItem((class_1263)ContainerIngredientProvider.this.container, (int)this.slot, (class_1799)remainingItem, (boolean)false);
            }
            return consumed;
        }

        @Override
        public class_1799 restore(class_1799 itemStack) {
            class_1799 restItem = ContainerUtils.insertItem((class_1263)ContainerIngredientProvider.this.container, (int)this.slot, (class_1799)itemStack, (boolean)false);
            if (!restItem.method_7960()) {
                return ContainerUtils.insertItemStacked((class_1263)ContainerIngredientProvider.this.container, (class_1799)restItem, (boolean)false);
            }
            return class_1799.field_8037;
        }
    }
}

