/*
 * Decompiled with CFR 0.152.
 */
package io.github.stainlessstasis.mixin;

import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.entity.SpawnEvent;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.spawning.CobblemonWorldSpawnerManager;
import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.WorldSlice;
import com.cobblemon.mod.common.api.spawning.context.AreaSpawningContext;
import com.cobblemon.mod.common.api.spawning.context.SpawningContext;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.cobblemon.mod.common.command.SpawnPokemon;
import com.cobblemon.mod.common.command.argument.PokemonPropertiesArgumentType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Unit;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpawnPokemon.class})
public abstract class PokemonSpawnCommandMixin {
    @Unique
    private SimpleCommandExceptionType NO_SPECIES_EXCEPTION = new SimpleCommandExceptionType((Message)LocalizationUtilsKt.commandLang((String)"${NAME}.nospecies", (Object[])new Object[0]).method_27692(class_124.field_1061));
    @Unique
    private SimpleCommandExceptionType INVALID_POS_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Invalid position").method_27692(class_124.field_1061));
    @Unique
    private SimpleCommandExceptionType FAILED_SPAWN_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Unable to spawn at the given position").method_27692(class_124.field_1061));

    @Inject(method={"execute"}, at={@At(value="HEAD")}, cancellable=true)
    private void execute(CommandContext<class_2168> context, class_243 pos, CallbackInfoReturnable<Integer> cir) throws CommandSyntaxException {
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        class_2338 blockPos = class_2338.method_49638((class_2374)pos);
        if (!class_1937.method_25953((class_2338)blockPos)) {
            throw this.INVALID_POS_EXCEPTION.create();
        }
        PokemonProperties properties = PokemonPropertiesArgumentType.Companion.getPokemonProperties(context, "properties");
        if (properties.getSpecies() == null) {
            throw this.NO_SPECIES_EXCEPTION.create();
        }
        PokemonEntity pokemonEntity = properties.createEntity((class_1937)world);
        pokemonEntity.method_5808(pos.field_1352, pos.field_1351, pos.field_1350, pokemonEntity.method_36454(), pokemonEntity.method_36455());
        pokemonEntity.method_5841().method_12778(PokemonEntity.getSPAWN_DIRECTION(), (Object)Float.valueOf(pokemonEntity.method_59922().method_43057() * 360.0f));
        pokemonEntity.method_5943((class_5425)world, world.method_8404(blockPos), class_3730.field_16462, null);
        PlayerSpawner spawner = (PlayerSpawner)CobblemonWorldSpawnerManager.INSTANCE.getSpawnersForPlayers().get(((class_2168)context.getSource()).method_44023().method_5667());
        SpawnCause cause = new SpawnCause((Spawner)spawner, spawner.chooseBucket(), (class_1297)pokemonEntity);
        WorldSlice slice = spawner.getProspector().prospect((Spawner)spawner, spawner.getArea(cause));
        AreaSpawningContext spawningContext = new AreaSpawningContext(cause, world, blockPos, 15, 15, true, new ArrayList(), 0, slice.nearbyBlocks(blockPos, 1, 1), slice);
        AtomicBoolean idkWhatToCallThisButTheCommandDidntError = new AtomicBoolean(false);
        CobblemonEvents.ENTITY_SPAWN.postThen((Cancelable)new SpawnEvent((class_1297)pokemonEntity, (SpawningContext)spawningContext), cancelled -> {
            idkWhatToCallThisButTheCommandDidntError.set(true);
            return Unit.INSTANCE;
        }, succeeded -> {
            idkWhatToCallThisButTheCommandDidntError.set(true);
            spawningContext.getWorld().method_8649((class_1297)pokemonEntity);
            return Unit.INSTANCE;
        });
        if (idkWhatToCallThisButTheCommandDidntError.get()) {
            cir.setReturnValue((Object)1);
            cir.cancel();
            return;
        }
        cir.cancel();
        throw this.FAILED_SPAWN_EXCEPTION.create();
    }
}

