/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.impl.loading;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_9824;

public class AthenaResourceLoader
extends class_4309 {
    public static final AthenaResourceLoader INSTANCE = new AthenaResourceLoader();
    private Function<class_2960, List<class_9824.class_7777>> getter = id -> null;
    private final Map<class_2960, JsonElement> data = new HashMap<class_2960, JsonElement>();

    public AthenaResourceLoader() {
        super(new Gson(), "athena");
    }

    public void setGetter(Function<class_2960, List<class_9824.class_7777>> getter) {
        this.getter = Objects.requireNonNullElse(getter, id -> null);
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profilerFiller) {
        this.data.clear();
        this.data.putAll(object);
    }

    public static JsonObject getData(class_2960 modelType, class_2960 modelId) {
        JsonElement modelData = AthenaResourceLoader.INSTANCE.data.get(modelId);
        if (modelData != null) {
            return AthenaResourceLoader.checkObject(modelType, modelData);
        }
        List<class_9824.class_7777> jsons = AthenaResourceLoader.INSTANCE.getter.apply(AthenaResourceLoader.convertModelIdToBlockStatePath(modelId));
        if (jsons == null) {
            return null;
        }
        for (class_9824.class_7777 json : jsons) {
            JsonObject object = AthenaResourceLoader.checkObject(modelType, json.comp_1057());
            if (object == null) continue;
            return object;
        }
        return null;
    }

    private static JsonObject checkObject(class_2960 modelType, JsonElement data) {
        if (data instanceof JsonObject) {
            JsonObject object = (JsonObject)data;
            String type = class_3518.method_15253((JsonObject)object, (String)"athena:loader", (String)"");
            if (modelType.toString().equals(type)) {
                return object;
            }
        }
        return null;
    }

    private static class_2960 convertModelIdToBlockStatePath(class_2960 modelId) {
        return class_2960.method_60655((String)modelId.method_12836(), (String)("blockstates/" + modelId.method_12832() + ".json"));
    }
}

