/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.impl.client.models;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import earth.terrarium.athena.api.client.models.AthenaBlockModel;
import earth.terrarium.athena.api.client.models.AthenaModelFactory;
import earth.terrarium.athena.api.client.models.AthenaQuad;
import earth.terrarium.athena.api.client.utils.AppearanceAndTintGetter;
import earth.terrarium.athena.api.client.utils.AthenaUtils;
import earth.terrarium.athena.api.client.utils.CtmUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1058;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3518;
import net.minecraft.class_4730;

public class PillarBlockModel
implements AthenaBlockModel {
    public static final AthenaModelFactory FACTORY = new Factory();
    private static final List<AthenaQuad> CAP = List.of(AthenaQuad.withSprite(0));
    private final Int2ObjectMap<class_4730> materials;

    public PillarBlockModel(Int2ObjectMap<class_4730> materials) {
        this.materials = materials;
    }

    @Override
    public List<AthenaQuad> getQuads(AppearanceAndTintGetter level, class_2680 state, class_2338 pos, class_2350 direction) {
        boolean max;
        class_2338 occludingPos = pos.method_10093(direction);
        class_2680 occludingState = level.method_8320(occludingPos);
        class_2680 appearance = level.getAppearance(state, pos, direction, occludingState, occludingPos);
        if (!appearance.method_28498((class_2769)class_2741.field_12496)) {
            return List.of(AthenaQuad.withRotation(4, class_2470.field_11467));
        }
        class_2350.class_2351 axis = (class_2350.class_2351)appearance.method_11654((class_2769)class_2741.field_12496);
        if (axis == direction.method_10166()) {
            return CAP;
        }
        class_2470 rotate = CtmUtils.getPillarRotation(axis, direction);
        Pair<class_2350, class_2350> minMax = AthenaUtils.getMinMax(axis);
        class_2338 posOne = pos.method_10093((class_2350)minMax.getFirst());
        class_2338 posTwo = pos.method_10093((class_2350)minMax.getSecond());
        class_2680 appearanceOne = level.getAppearance(state, pos, direction, level.method_8320(posOne), posOne);
        class_2680 appearanceTwo = level.getAppearance(state, pos, direction, level.method_8320(posTwo), posTwo);
        boolean min = !appearanceOne.method_26215() && level.getAppearance(posOne, direction, state, pos) == appearanceOne;
        boolean bl = max = !appearanceTwo.method_26215() && level.getAppearance(posTwo, direction, state, pos) == appearanceTwo;
        if (min && max) {
            return List.of(AthenaQuad.withRotation(2, rotate));
        }
        if (min) {
            return List.of(AthenaQuad.withRotation(3, rotate));
        }
        if (max) {
            return List.of(AthenaQuad.withRotation(1, rotate));
        }
        return List.of(AthenaQuad.withRotation(4, rotate));
    }

    @Override
    public Map<class_2350, List<AthenaQuad>> getDefaultQuads(class_2350 direction) {
        HashMap<class_2350, List<AthenaQuad>> quads = new HashMap<class_2350, List<AthenaQuad>>(class_2350.values().length);
        for (class_2350 dir : class_2350.values()) {
            quads.put(dir, List.of(AthenaQuad.withRotation(4, class_2470.field_11467)));
        }
        return quads;
    }

    @Override
    public Int2ObjectMap<class_1058> getTextures(Function<class_4730, class_1058> getter) {
        Int2ObjectArrayMap textures = new Int2ObjectArrayMap();
        for (Int2ObjectMap.Entry entry : this.materials.int2ObjectEntrySet()) {
            textures.put(entry.getIntKey(), (Object)getter.apply((class_4730)entry.getValue()));
        }
        return textures;
    }

    private static class Factory
    implements AthenaModelFactory {
        private Factory() {
        }

        @Override
        public Supplier<AthenaBlockModel> create(JsonObject json) {
            Int2ObjectMap<class_4730> materials = Factory.parseMaterials(class_3518.method_15296((JsonObject)json, (String)"ctm_textures"));
            return () -> new PillarBlockModel(materials);
        }

        private static Int2ObjectMap<class_4730> parseMaterials(JsonObject json) {
            Int2ObjectArrayMap materials = new Int2ObjectArrayMap();
            materials.put(0, (Object)CtmUtils.blockMat(class_3518.method_15265((JsonObject)json, (String)"particle")));
            materials.put(4, (Object)CtmUtils.blockMat(class_3518.method_15265((JsonObject)json, (String)"self")));
            materials.put(1, (Object)CtmUtils.blockMat(class_3518.method_15265((JsonObject)json, (String)"top")));
            materials.put(2, (Object)CtmUtils.blockMat(class_3518.method_15265((JsonObject)json, (String)"center")));
            materials.put(3, (Object)CtmUtils.blockMat(class_3518.method_15265((JsonObject)json, (String)"bottom")));
            return materials;
        }
    }
}

