/*
 * Decompiled with CFR 0.152.
 */
package com.ddmc.display;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class Config {
    private static final String CONFIG_FILE_PATH = "config/display-common.toml";
    private static final String INGOT = "# Set whether the ingot can be placed";
    private static final String ITEM_FRAME = "# Set whether the item frame can be adjusted";
    private static final String ARMOR_STAND = "# Set whether the armor stand can be adjusted";
    private boolean placeTheIngot;
    private boolean adjustTheItemFrame;
    private boolean adjustTheArmorStand;

    public Config() {
        this.loadConfig();
    }

    private void loadConfig() {
        File configFile = new File(CONFIG_FILE_PATH);
        if (configFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(configFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("placeTheIngot")) {
                        this.placeTheIngot = this.parseBoolean(line);
                        continue;
                    }
                    if (line.startsWith("adjustTheItemFrame")) {
                        this.adjustTheItemFrame = this.parseBoolean(line);
                        continue;
                    }
                    if (!line.startsWith("adjustTheArmorStand")) continue;
                    this.adjustTheArmorStand = this.parseBoolean(line);
                }
            }
            catch (IOException e) {
                System.err.println("Failed to load config file: " + e.getMessage());
                this.setDefaults();
            }
        } else {
            this.setDefaults();
            this.saveConfig();
        }
    }

    private boolean parseBoolean(String line) {
        String[] parts = line.split("=");
        return parts.length > 1 && Boolean.parseBoolean(parts[1].trim());
    }

    private void setDefaults() {
        this.placeTheIngot = true;
        this.adjustTheItemFrame = true;
        this.adjustTheArmorStand = true;
    }

    private void saveConfig() {
        File configDir = new File("config");
        if (!configDir.exists() && !configDir.mkdirs()) {
            System.err.println("Failed to create config directory.");
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(CONFIG_FILE_PATH));){
            writer.write(INGOT);
            writer.newLine();
            writer.write("placeTheIngot = " + this.placeTheIngot);
            writer.newLine();
            writer.write(ITEM_FRAME);
            writer.newLine();
            writer.write("adjustTheItemFrame = " + this.adjustTheItemFrame);
            writer.newLine();
            writer.write(ARMOR_STAND);
            writer.newLine();
            writer.write("adjustTheArmorStand = " + this.adjustTheArmorStand);
        }
        catch (IOException e) {
            System.err.println("Failed to save config file: " + e.getMessage());
        }
    }

    public boolean isPlaceTheIngot() {
        return this.placeTheIngot;
    }

    public boolean isAdjustTheItemFrame() {
        return this.adjustTheItemFrame;
    }

    public boolean isAdjustTheArmorStand() {
        return this.adjustTheArmorStand;
    }
}

