/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.client.render.entity.texture;

import com.github.legoatoom.connectiblechains.client.ClientInitializer;
import com.github.legoatoom.connectiblechains.client.render.entity.UVRect;
import com.github.legoatoom.connectiblechains.client.render.entity.catenary.CatenaryModel;
import com.github.legoatoom.connectiblechains.client.render.entity.catenary.CatenaryRenderer;
import com.github.legoatoom.connectiblechains.util.Helper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3545;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.NotNull;

public class ChainTextureManager
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final String MODEL_FILE_LOCATION = "models/entity/connectiblechains";
    private static final Gson GSON = new GsonBuilder().create();
    private static final int EXPECTED_UNIQUE_CHAIN_COUNT = 64;
    public static final class_2960 DEFAULT_CATENARY = Helper.identifier("cross");
    public static final class_3545<UVRect, UVRect> DEFAULT_UV = new class_3545((Object)UVRect.DEFAULT_SIDE_A, (Object)UVRect.DEFAULT_SIDE_B);
    private Map<class_2960, CatenaryModel> models = new Object2ObjectOpenHashMap(64);

    public class_2960 getFabricId() {
        return Helper.identifier("chain_models");
    }

    public ChainTextureManager() {
        super(GSON, MODEL_FILE_LOCATION);
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        this.clearCache();
        this.models = prepared.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, o -> (CatenaryModel)CatenaryModel.CODEC.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)o.getValue())).getOrThrow()));
    }

    public void clearCache() {
        ClientInitializer.getInstance().getChainKnotEntityRenderer().ifPresent(it -> it.getChainRenderer().purge());
    }

    @NotNull
    private static class_2960 defaultChainTextureId(class_2960 itemId) {
        return class_2960.method_60655((String)itemId.method_12836(), (String)"block/%s".formatted(itemId.method_12832()));
    }

    @NotNull
    private static class_2960 defaultKnotTextureId(class_2960 itemId) {
        return class_2960.method_60655((String)itemId.method_12836(), (String)"item/%s".formatted(itemId.method_12832()));
    }

    public CatenaryRenderer getCatenaryRenderer(class_2960 sourceItemId) {
        Optional<CatenaryModel> catenaryModel = Optional.ofNullable(this.models.get(sourceItemId));
        class_2960 catenaryId = catenaryModel.flatMap(CatenaryModel::catenaryRendererId).orElse(DEFAULT_CATENARY);
        class_3545<UVRect, UVRect> uvMappings = catenaryModel.flatMap(CatenaryModel::uvRects).orElse(DEFAULT_UV);
        return CatenaryRenderer.getRenderer(catenaryId, uvMappings);
    }

    public class_2960 getChainTexture(class_2960 sourceItemId) {
        return Optional.ofNullable(this.models.get(sourceItemId)).flatMap(CatenaryModel::textures).flatMap(CatenaryModel.CatenaryTextures::chainTexture).orElse(ChainTextureManager.defaultChainTextureId(sourceItemId)).method_45134(arg_0 -> ChainTextureManager.lambda$getChainTexture$2("textures/%s.png", arg_0));
    }

    public class_2960 getKnotTexture(class_2960 sourceItemId) {
        return Optional.ofNullable(this.models.get(sourceItemId)).flatMap(CatenaryModel::textures).flatMap(CatenaryModel.CatenaryTextures::knotTexture).orElse(ChainTextureManager.defaultKnotTextureId(sourceItemId)).method_45134(arg_0 -> ChainTextureManager.lambda$getKnotTexture$3("textures/%s.png", arg_0));
    }

    private static /* synthetic */ String lambda$getKnotTexture$3(String rec$, Object xva$0) {
        return "textures/%s.png".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$getChainTexture$2(String rec$, Object xva$0) {
        return "textures/%s.png".formatted(xva$0);
    }
}

