/*
 * Decompiled with CFR 0.152.
 */
package com.necro.fireworkcapsules.common.particles.custom;

import com.necro.fireworkcapsules.common.stickers.StickerExplosion;
import com.necro.fireworkcapsules.common.util.CustomParticleFunction;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3998;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_708;

@Environment(value=EnvType.CLIENT)
public class StickerParticle
extends class_708 {
    protected float rotateSpeed;
    protected boolean isStatic;
    protected boolean trail;
    protected boolean twinkle;
    protected final class_702 engine;
    protected float fadeR;
    protected float fadeG;
    protected float fadeB;
    protected boolean hasFade;

    StickerParticle(class_638 clientLevel, double x, double y, double z, double xd, double yd, double zd, class_702 particleEngine, class_4002 spriteSet) {
        super(clientLevel, x, y, z, spriteSet, 0.0f);
        this.method_3080(0.02f, 0.02f);
        this.field_3847 = 10 + this.field_3840.method_43048(30);
        this.rotateSpeed = 0.0f;
        this.field_3852 = xd;
        this.field_3869 = yd;
        this.field_3850 = zd;
        this.engine = particleEngine;
        this.field_17867 *= 0.75f;
        this.isStatic = false;
        this.method_18142(spriteSet);
    }

    public void method_3070() {
        if (this.rotateSpeed != 0.0f) {
            this.field_3857 = this.field_3839;
            this.field_3839 += (float)Math.PI * this.rotateSpeed;
        }
        super.method_3070();
        if (this.trail && this.field_3866 < this.field_3847 / 2 && (this.field_3866 + this.field_3847) % 2 == 0) {
            StickerParticle stickerParticle = (StickerParticle)this.createTrail();
            stickerParticle.method_3083(0.99f);
            stickerParticle.method_3084(this.field_3861, this.field_3842, this.field_3859);
            stickerParticle.field_3866 = stickerParticle.field_3847 / 2;
            stickerParticle.field_3844 = this.field_3844;
            if (this.hasFade) {
                stickerParticle.hasFade = true;
                stickerParticle.fadeR = this.fadeR;
                stickerParticle.fadeG = this.fadeG;
                stickerParticle.fadeB = this.fadeB;
            }
            stickerParticle.twinkle = this.twinkle;
            this.engine.method_3058((class_703)stickerParticle);
        }
    }

    protected class_703 createTrail() {
        double xd = (this.field_3840.method_43058() - 0.5) * 0.1;
        double yd = (this.field_3840.method_43058() - 0.5) * 0.1;
        double zd = (this.field_3840.method_43058() - 0.5) * 0.1;
        return new StickerParticle(this.field_3851, this.field_3874, this.field_3854, this.field_3871, xd, yd, zd, this.engine, this.field_17866);
    }

    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float f) {
        if (!this.twinkle || this.field_3866 < this.field_3847 / 3 || (this.field_3866 + this.field_3847) / 3 % 2 == 0) {
            super.method_3074(vertexConsumer, camera, f);
        }
    }

    public void method_18142(class_4002 spriteSet) {
        if (!this.isStatic) {
            super.method_18142(spriteSet);
        }
    }

    public void setRotateSpeed(double rotateSpeedMulti) {
        this.rotateSpeed = (this.field_3840.method_43057() - 0.5f) * 0.05f * (float)rotateSpeedMulti;
        this.rotateSpeed = this.rotateSpeed < 0.0f ? Math.min(this.rotateSpeed, -0.01f * (float)rotateSpeedMulti) : Math.max(this.rotateSpeed, 0.01f * (float)rotateSpeedMulti);
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
        if (isStatic) {
            this.method_18140(this.field_17866);
        }
    }

    public void setTrail(boolean trail) {
        this.trail = trail;
    }

    public void setTwinkle(boolean twinkle) {
        this.twinkle = twinkle;
    }

    public static CustomParticleFunction getConsumer(class_2394 particle) {
        return StickerParticle.getConsumer(particle, 0.0);
    }

    public static CustomParticleFunction getConsumer(class_2394 particle, double rotateSpeedMulti) {
        return StickerParticle.getConsumer(particle, rotateSpeedMulti, 0.0f);
    }

    public static CustomParticleFunction getConsumer(class_2394 particle, float gravity) {
        return StickerParticle.getConsumer(particle, 0.0, gravity);
    }

    public static CustomParticleFunction getConsumer(class_2394 particle, double rotateSpeedMulti, float gravity) {
        return (clientLevel, x, y, z, rot, particleEngine, explosion, scale, scaleFactor) -> particleEngine.method_3058((class_703)new Starter(particle, clientLevel, x, y, z, 0.0, 0.0, 0.0, gravity, particleEngine, explosion, scale, scaleFactor, rotateSpeedMulti));
    }

    @Environment(value=EnvType.CLIENT)
    public static class Starter
    extends class_3998 {
        protected final class_2394 particle;
        protected final class_702 engine;
        protected final StickerExplosion explosion;
        protected final float gravity;
        protected final float scale;
        protected final double scaleFactor;
        protected final double rotateSpeedMulti;
        protected int life;

        public Starter(class_2394 particle, class_638 clientLevel, double x, double y, double z, double xd, double yd, double zd, float gravity, class_702 particleEngine, StickerExplosion explosion, float scale, double scaleFactor, double rotateSpeedMulti) {
            super(clientLevel, x, y, z, xd, yd, zd);
            this.particle = particle;
            this.engine = particleEngine;
            this.explosion = explosion;
            this.gravity = gravity;
            this.scale = scale;
            this.scaleFactor = Math.max(scaleFactor, 1.0);
            this.rotateSpeedMulti = rotateSpeedMulti;
            this.life = 0;
        }

        public void method_3070() {
            int i = 0;
            while ((double)i < 4.0 / this.scaleFactor) {
                double xn = (this.field_3840.method_43058() - 0.5) * 1.5 * (double)this.scale;
                double yn = (this.field_3840.method_43058() - 0.5) * 1.5 * (double)this.scale;
                double zn = (this.field_3840.method_43058() - 0.5) * 1.5 * (double)this.scale;
                class_243 nd = new class_243(xn, yn, zn).method_1029();
                class_243 n2 = nd.method_1021((double)(this.scale / 3.0f));
                double x2 = this.field_3874 + xn + n2.method_10216();
                double y2 = this.field_3854 + yn + n2.method_10214();
                double z2 = this.field_3871 + zn + n2.method_10215();
                double xd = nd.method_10216() * 0.01;
                double yd = nd.method_10214() * 0.01;
                double zd = nd.method_10215() * 0.01;
                this.createParticle(x2, y2, z2, xd, yd, zd);
                ++i;
            }
            if (this.life++ > 4) {
                this.method_3085();
            }
        }

        public void createParticle(double x, double y, double z, double xd, double yd, double zd) {
            StickerParticle stickerParticle = (StickerParticle)this.engine.method_3056(this.particle, x, y, z, xd, yd, zd);
            if (stickerParticle == null) {
                return;
            }
            stickerParticle.setTrail(this.explosion.hasTrail());
            stickerParticle.setTwinkle(this.explosion.hasTwinkle());
            stickerParticle.method_3083(0.99f);
            stickerParticle.method_3087((float)Math.sqrt(this.scale));
            stickerParticle.setRotateSpeed(this.rotateSpeedMulti);
            stickerParticle.field_3844 = this.gravity;
            if (!this.explosion.fadeColors().isEmpty()) {
                stickerParticle.method_3092((Integer)class_156.method_32309((List)this.explosion.fadeColors(), (class_5819)this.field_3840));
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class VariedColoredStickerProvider
    extends ColoredStickerProvider {
        private final class_5819 random = class_5819.method_43047();

        public VariedColoredStickerProvider(class_4002 spriteSet, int color) {
            super(spriteSet, color);
        }

        @Override
        public class_703 createParticle(class_2400 simpleParticleType, class_638 clientLevel, double d, double e, double f, double g, double h, double i) {
            StickerParticle stickerParticle = (StickerParticle)super.createParticle(simpleParticleType, clientLevel, d, e, f, g, h, i);
            stickerParticle.method_18141(stickerParticle.field_17866.method_18139(this.random));
            stickerParticle.setStatic(true);
            return stickerParticle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class VariedStickerProvider
    extends StickerProvider {
        private final class_5819 random = class_5819.method_43047();

        public VariedStickerProvider(class_4002 spriteSet) {
            super(spriteSet);
        }

        @Override
        public class_703 createParticle(class_2400 simpleParticleType, class_638 clientLevel, double d, double e, double f, double g, double h, double i) {
            StickerParticle stickerParticle = (StickerParticle)super.createParticle(simpleParticleType, clientLevel, d, e, f, g, h, i);
            stickerParticle.method_18141(stickerParticle.field_17866.method_18139(this.random));
            stickerParticle.setStatic(true);
            return stickerParticle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ColoredStickerProvider
    extends StickerProvider {
        private final int color;

        public ColoredStickerProvider(class_4002 spriteSet, int color) {
            super(spriteSet);
            this.color = color;
        }

        @Override
        public class_703 createParticle(class_2400 simpleParticleType, class_638 clientLevel, double d, double e, double f, double g, double h, double i) {
            StickerParticle stickerParticle = (StickerParticle)super.createParticle(simpleParticleType, clientLevel, d, e, f, g, h, i);
            stickerParticle.method_3093(this.color);
            return stickerParticle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class StickerProvider
    implements class_707<class_2400> {
        private final class_4002 sprites;

        public StickerProvider(class_4002 spriteSet) {
            this.sprites = spriteSet;
        }

        public class_703 createParticle(class_2400 simpleParticleType, class_638 clientLevel, double d, double e, double f, double g, double h, double i) {
            StickerParticle stickerParticle = new StickerParticle(clientLevel, d, e, f, g, h, i, class_310.method_1551().field_1713, this.sprites);
            stickerParticle.method_3083(0.99f);
            return stickerParticle;
        }
    }
}

