/*
 * Decompiled with CFR 0.152.
 */
package com.necro.fireworkcapsules.common.particles.custom;

import com.necro.fireworkcapsules.common.particles.custom.StickerParticle;
import com.necro.fireworkcapsules.common.stickers.StickerExplosion;
import com.necro.fireworkcapsules.common.util.CustomParticleFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_310;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_707;

@Environment(value=EnvType.CLIENT)
public class FlashParticle
extends StickerParticle {
    FlashParticle(class_638 clientLevel, double x, double y, double z, double xd, double yd, double zd, class_702 particleEngine, class_4002 spriteSet) {
        super(clientLevel, x, y, z, xd, yd, zd, particleEngine, spriteSet);
        this.field_3847 = 5 + this.field_3840.method_43051(0, 5);
    }

    @Override
    protected class_703 createTrail() {
        double xd = (this.field_3840.method_43058() - 0.5) * 0.1;
        double yd = (this.field_3840.method_43058() - 0.5) * 0.1;
        double zd = (this.field_3840.method_43058() - 0.5) * 0.1;
        return new FlashParticle(this.field_3851, this.field_3874, this.field_3854, this.field_3871, xd, yd, zd, this.engine, this.field_17866);
    }

    public static CustomParticleFunction getConsumer(class_2394 particle) {
        return FlashParticle.getConsumer(particle, 0.0);
    }

    public static CustomParticleFunction getConsumer(class_2394 particle, double rotateSpeedMulti) {
        return FlashParticle.getConsumer(particle, rotateSpeedMulti, 0.0f);
    }

    public static CustomParticleFunction getConsumer(class_2394 particle, float gravity) {
        return FlashParticle.getConsumer(particle, 0.0, gravity);
    }

    public static CustomParticleFunction getConsumer(class_2394 particle, double rotateSpeedMulti, float gravity) {
        return (clientLevel, x, y, z, rot, particleEngine, explosion, scale, scaleFactor) -> particleEngine.method_3058((class_703)new Starter(particle, clientLevel, x, y, z, 0.0, 0.0, 0.0, gravity, particleEngine, explosion, scale, scaleFactor, rotateSpeedMulti));
    }

    @Environment(value=EnvType.CLIENT)
    public static class Starter
    extends StickerParticle.Starter {
        public Starter(class_2394 particle, class_638 clientLevel, double x, double y, double z, double xd, double yd, double zd, float gravity, class_702 particleEngine, StickerExplosion explosion, float scale, double scaleFactor, double rotateSpeedMulti) {
            super(particle, clientLevel, x, y, z, xd, yd, zd, gravity, particleEngine, explosion, scale, scaleFactor, rotateSpeedMulti);
        }

        @Override
        public void createParticle(double x, double y, double z, double xd, double yd, double zd) {
            FlashParticle flashParticle = (FlashParticle)this.engine.method_3056(this.particle, x, y, z, xd, yd, zd);
            if (flashParticle == null) {
                return;
            }
            flashParticle.setTrail(this.explosion.hasTrail());
            flashParticle.setTwinkle(this.explosion.hasTwinkle());
            flashParticle.method_3083(0.99f);
            flashParticle.method_3087((float)Math.sqrt(this.scale));
            flashParticle.setRotateSpeed(this.rotateSpeedMulti);
            flashParticle.field_3844 = this.gravity;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class VariedFlashProvider
    extends FlashProvider {
        private final class_5819 random = class_5819.method_43047();

        public VariedFlashProvider(class_4002 spriteSet) {
            super(spriteSet);
        }

        @Override
        public class_703 createParticle(class_2400 simpleParticleType, class_638 clientLevel, double d, double e, double f, double g, double h, double i) {
            FlashParticle flashParticle = (FlashParticle)super.createParticle(simpleParticleType, clientLevel, d, e, f, g, h, i);
            flashParticle.method_18141(flashParticle.field_17866.method_18139(this.random));
            flashParticle.setStatic(true);
            return flashParticle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class FlashProvider
    implements class_707<class_2400> {
        private final class_4002 sprites;

        public FlashProvider(class_4002 spriteSet) {
            this.sprites = spriteSet;
        }

        public class_703 createParticle(class_2400 simpleParticleType, class_638 clientLevel, double d, double e, double f, double g, double h, double i) {
            FlashParticle flashParticle = new FlashParticle(clientLevel, d, e, f, g, h, i, class_310.method_1551().field_1713, this.sprites);
            flashParticle.method_3083(0.99f);
            return flashParticle;
        }
    }
}

