/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconAnimation;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.client.gui.CustomToast;
import dev.ftb.mods.ftbquests.client.gui.quests.ValidItemsScreen;
import dev.ftb.mods.ftbquests.integration.item_filtering.ItemMatchingSystem;
import dev.ftb.mods.ftbquests.item.MissingItem;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.registry.ModItems;
import dev.ftb.mods.ftbquests.util.PlayerInventorySummary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_368;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_9129;

public class ItemTask
extends Task
implements Predicate<class_1799> {
    private class_1799 itemStack = class_1799.field_8037;
    private long count = 1L;
    private Tristate consumeItems = Tristate.DEFAULT;
    private Tristate onlyFromCrafting = Tristate.DEFAULT;
    private ItemMatchingSystem.ComponentMatchType matchComponents = ItemMatchingSystem.ComponentMatchType.NONE;
    private boolean taskScreenOnly = false;

    public ItemTask(long id, Quest quest) {
        super(id, quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.ITEM;
    }

    @Override
    public long getMaxProgress() {
        return this.count;
    }

    public ItemTask setStackAndCount(class_1799 stack, int count) {
        this.itemStack = stack.method_7972();
        this.count = count;
        return this;
    }

    public class_1799 getItemStack() {
        return this.itemStack;
    }

    public void setConsumeItems(Tristate consumeItems) {
        this.consumeItems = consumeItems;
    }

    @Override
    public void writeData(class_2487 nbt, class_7225.class_7874 provider) {
        super.writeData(nbt, provider);
        nbt.method_10566("item", (class_2520)this.saveItemSingleLine(this.itemStack));
        if (this.count > 1L) {
            nbt.method_10544("count", this.count);
        }
        this.consumeItems.write(nbt, "consume_items");
        this.onlyFromCrafting.write(nbt, "only_from_crafting");
        if (this.matchComponents != ItemMatchingSystem.ComponentMatchType.NONE) {
            nbt.method_10582("match_components", ItemMatchingSystem.ComponentMatchType.NAME_MAP.getName((Object)this.matchComponents));
        }
        if (this.taskScreenOnly) {
            nbt.method_10556("task_screen_only", true);
        }
    }

    @Override
    public void readData(class_2487 nbt, class_7225.class_7874 provider) {
        super.readData(nbt, provider);
        this.itemStack = ItemTask.itemOrMissingFromNBT(nbt.method_10580("item"), provider);
        this.count = Math.max(nbt.method_10537("count"), 1L);
        this.consumeItems = Tristate.read((class_2487)nbt, (String)"consume_items");
        this.onlyFromCrafting = Tristate.read((class_2487)nbt, (String)"only_from_crafting");
        this.matchComponents = (ItemMatchingSystem.ComponentMatchType)((Object)ItemMatchingSystem.ComponentMatchType.NAME_MAP.get(nbt.method_10558("match_components")));
        this.taskScreenOnly = nbt.method_10577("task_screen_only");
    }

    @Override
    public void writeNetData(class_9129 buffer) {
        super.writeNetData(buffer);
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (this.count > 1L ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)2, (this.consumeItems != Tristate.DEFAULT ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)4, (this.consumeItems == Tristate.TRUE ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)8, (this.onlyFromCrafting != Tristate.DEFAULT ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)16, (this.onlyFromCrafting == Tristate.TRUE ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)32, (this.matchComponents != ItemMatchingSystem.ComponentMatchType.NONE ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)64, (this.matchComponents == ItemMatchingSystem.ComponentMatchType.STRICT ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)256, (boolean)this.taskScreenOnly);
        buffer.method_10804(flags);
        class_1799.field_49268.encode((Object)buffer, (Object)this.itemStack);
        if (this.count > 1L) {
            buffer.method_10791(this.count);
        }
    }

    @Override
    public void readNetData(class_9129 buffer) {
        super.readNetData(buffer);
        int flags = buffer.method_10816();
        this.itemStack = (class_1799)class_1799.field_49268.decode((Object)buffer);
        long l = this.count = Bits.getFlag((int)flags, (int)1) ? buffer.method_10792() : 1L;
        Tristate tristate = Bits.getFlag((int)flags, (int)2) ? (Bits.getFlag((int)flags, (int)4) ? Tristate.TRUE : Tristate.FALSE) : (this.consumeItems = Tristate.DEFAULT);
        Tristate tristate2 = Bits.getFlag((int)flags, (int)8) ? (Bits.getFlag((int)flags, (int)16) ? Tristate.TRUE : Tristate.FALSE) : (this.onlyFromCrafting = Tristate.DEFAULT);
        this.matchComponents = Bits.getFlag((int)flags, (int)32) ? (Bits.getFlag((int)flags, (int)64) ? ItemMatchingSystem.ComponentMatchType.STRICT : ItemMatchingSystem.ComponentMatchType.FUZZY) : ItemMatchingSystem.ComponentMatchType.NONE;
        this.taskScreenOnly = Bits.getFlag((int)flags, (int)256);
    }

    public List<class_1799> getValidDisplayItems() {
        return ItemMatchingSystem.INSTANCE.getAllMatchingStacks(this.itemStack);
    }

    @Environment(value=EnvType.CLIENT)
    public class_5250 getAltTitle() {
        if (this.count > 1L) {
            return class_2561.method_43470((String)(this.count + "x ")).method_10852(this.itemStack.method_7964());
        }
        return class_2561.method_43470((String)"").method_10852(this.itemStack.method_7964());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public Icon getAltIcon() {
        ArrayList<Icon> icons = new ArrayList<Icon>();
        for (class_1799 stack : this.getValidDisplayItems()) {
            class_1799 copy = stack.method_7972();
            copy.method_7939(1);
            Icon icon = ItemIcon.getItemIcon((class_1799)copy);
            if (icon.isEmpty()) continue;
            icons.add(icon);
        }
        if (icons.isEmpty()) {
            return ItemIcon.getItemIcon((class_1792)((class_1792)ModItems.MISSING_ITEM.get()));
        }
        return IconAnimation.fromList(icons, (boolean)false);
    }

    @Override
    public boolean test(class_1799 stack) {
        if (this.itemStack.method_7960()) {
            return true;
        }
        return ItemMatchingSystem.INSTANCE.doesItemMatch(this.itemStack, stack, this.matchComponents);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addItemStack("item", this.itemStack, v -> {
            this.itemStack = v;
        }, class_1799.field_8037, true, false).setNameKey("ftbquests.task.ftbquests.item");
        config.addLong("count", this.count, v -> {
            this.count = v;
        }, 1L, 1L, Long.MAX_VALUE);
        config.addEnum("consume_items", (Object)this.consumeItems, v -> {
            this.consumeItems = v;
        }, Tristate.NAME_MAP);
        config.addEnum("only_from_crafting", (Object)this.onlyFromCrafting, v -> {
            this.onlyFromCrafting = v;
        }, Tristate.NAME_MAP);
        config.addEnum("match_components", (Object)this.matchComponents, v -> {
            this.matchComponents = v;
        }, ItemMatchingSystem.ComponentMatchType.NAME_MAP);
        config.addBool("task_screen_only", this.taskScreenOnly, v -> {
            this.taskScreenOnly = v;
        }, false);
    }

    @Override
    public boolean consumesResources() {
        return this.consumeItems.get(this.getQuest().getChapter().consumeItems());
    }

    @Override
    public boolean canInsertItem() {
        return this.consumesResources();
    }

    @Override
    public boolean submitItemsOnInventoryChange() {
        return !this.consumesResources();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
        button.playClickSound();
        List<class_1799> validItems = this.getValidDisplayItems();
        if (!this.consumesResources() && validItems.size() == 1 && FTBQuests.getRecipeModHelper().isRecipeModAvailable()) {
            FTBQuests.getRecipeModHelper().showRecipes(validItems.get(0));
        } else if (validItems.isEmpty()) {
            class_310.method_1551().method_1566().method_1999((class_368)new CustomToast((class_2561)class_2561.method_43470((String)"No valid items!"), ItemIcon.getItemIcon((class_1792)((class_1792)ModItems.MISSING_ITEM.get())), (class_2561)class_2561.method_43470((String)"Report this bug to modpack author!")));
        } else {
            new ValidItemsScreen(this, validItems, canClick).openGui();
        }
    }

    @Override
    public void addMouseOverHeader(TooltipList list, TeamData teamData, boolean advanced) {
        if (!this.getRawTitle().isEmpty()) {
            list.add(this.getTitle());
        } else {
            class_1799 class_17992;
            Icon icon = this.getIcon();
            if (icon instanceof ItemIcon) {
                ItemIcon i = (ItemIcon)icon;
                class_17992 = i.getStack();
            } else {
                class_17992 = this.itemStack;
            }
            class_1799 stack = class_17992;
            List lines = stack.method_7950(class_1792.class_9635.method_59528((class_1937)FTBQuestsClient.getClientLevel()), FTBQuestsClient.getClientPlayer(), (class_1836)(advanced ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070));
            if (!lines.isEmpty()) {
                lines.set(0, this.getTitle());
            } else {
                lines.add(this.getTitle());
            }
            lines.forEach(arg_0 -> ((TooltipList)list).add(arg_0));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addMouseOverText(TooltipList list, TeamData teamData) {
        if (this.taskScreenOnly) {
            list.blankLine();
            list.add((class_2561)class_2561.method_43471((String)"ftbquests.task.task_screen_only").method_27695(new class_124[]{class_124.field_1054, class_124.field_1073}));
        } else if (this.consumesResources() && !teamData.isCompleted(this)) {
            list.blankLine();
            list.add((class_2561)class_2561.method_43471((String)"ftbquests.task.click_to_submit").method_27695(new class_124[]{class_124.field_1054, class_124.field_1073}));
        } else if (this.getValidDisplayItems().size() > 1) {
            list.blankLine();
            list.add((class_2561)class_2561.method_43471((String)"ftbquests.task.ftbquests.item.view_items").method_27695(new class_124[]{class_124.field_1054, class_124.field_1073}));
        } else if (FTBQuests.getRecipeModHelper().isRecipeModAvailable()) {
            list.blankLine();
            list.add((class_2561)class_2561.method_43471((String)"ftbquests.task.ftbquests.item.click_recipe").method_27695(new class_124[]{class_124.field_1054, class_124.field_1073}));
        }
    }

    public class_1799 insert(TeamData teamData, class_1799 stack, boolean simulate) {
        long add;
        if (!teamData.isCompleted(this) && this.consumesResources() && this.test(stack) && (add = Math.min((long)stack.method_7947(), this.count - teamData.getProgress(this))) > 0L) {
            if (!simulate && teamData.getFile().isServerSide()) {
                teamData.addProgress(this, add);
            }
            class_1799 copy = stack.method_7972();
            copy.method_7939((int)((long)stack.method_7947() - add));
            return copy;
        }
        return stack;
    }

    private long countMatchingItems(Collection<class_1799> toCheck) {
        long total = 0L;
        for (class_1799 stack : toCheck) {
            if (this.test(stack) && (total += (long)stack.method_7947()) >= this.count) break;
        }
        return Math.min(total, this.count);
    }

    @Override
    public void submitTask(TeamData teamData, class_3222 player, class_1799 craftedItem) {
        if (this.taskScreenOnly || !this.checkTaskSequence(teamData) || teamData.isCompleted(this) || this.itemStack.method_7909() instanceof MissingItem || craftedItem.method_7909() instanceof MissingItem) {
            return;
        }
        if (!this.consumesResources()) {
            if (this.onlyFromCrafting.get(false)) {
                if (!craftedItem.method_7960() && this.test(craftedItem)) {
                    teamData.addProgress(this, craftedItem.method_7947());
                }
            } else {
                long matchCount = this.countMatchingItems(PlayerInventorySummary.getRelevantItems(this.itemStack));
                if (matchCount > teamData.getProgress(this)) {
                    teamData.setProgress(this, matchCount);
                }
            }
        } else if (craftedItem.method_7960()) {
            boolean changed = false;
            for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
                class_1799 stack1;
                class_1799 stack = (class_1799)player.method_31548().field_7547.get(i);
                if (stack == (stack1 = this.insert(teamData, stack, false))) continue;
                changed = true;
                player.method_31548().field_7547.set(i, (Object)(stack1.method_7960() ? class_1799.field_8037 : stack1));
            }
            if (changed) {
                player.method_31548().method_5431();
                player.field_7512.method_7623();
            }
        }
    }

    public boolean isTaskScreenOnly() {
        return this.taskScreenOnly;
    }

    public boolean isOnlyFromCrafting() {
        return this.onlyFromCrafting.get(false);
    }
}

