/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftbquests.client.EnergyTaskClientData;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.task.ISingleLongValueTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_9129;

public abstract class EnergyTask
extends Task
implements ISingleLongValueTask {
    private long value = 1000L;
    private long maxInput = 1000L;

    public EnergyTask(long id, Quest quest) {
        super(id, quest);
    }

    @Override
    public long getMaxProgress() {
        return this.value;
    }

    @Override
    public void writeData(class_2487 nbt, class_7225.class_7874 provider) {
        super.writeData(nbt, provider);
        nbt.method_10544("value", this.value);
        if (this.maxInput > 0L) {
            nbt.method_10544("max_input", this.maxInput);
        }
    }

    @Override
    public void readData(class_2487 nbt, class_7225.class_7874 provider) {
        super.readData(nbt, provider);
        this.value = nbt.method_10537("value");
        if (this.value < 1L) {
            this.value = 1L;
        }
        this.maxInput = nbt.method_10537("max_input");
    }

    @Override
    public void writeNetData(class_9129 buffer) {
        super.writeNetData(buffer);
        buffer.method_10791(this.value);
        buffer.method_10791(this.maxInput);
    }

    @Override
    public void readNetData(class_9129 buffer) {
        super.readNetData(buffer);
        this.value = buffer.method_10792();
        this.maxInput = buffer.method_10792();
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public void setValue(long v) {
        this.value = v;
    }

    @Environment(value=EnvType.CLIENT)
    public class_5250 getAltTitle() {
        return class_2561.method_43470((String)StringUtils.formatDouble((double)this.value, (boolean)true));
    }

    @Override
    public boolean consumesResources() {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addLong("value", this.value, v -> {
            this.value = v;
        }, 1000L, 1L, Long.MAX_VALUE);
        config.addLong("max_input", this.maxInput, v -> {
            this.maxInput = v;
        }, 1000L, 0L, Integer.MAX_VALUE).setNameKey("ftbquests.task.max_input");
    }

    public abstract EnergyTaskClientData getClientData();

    public long getMaxInput() {
        return this.maxInput;
    }
}

