/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.integration.stages.StageHelper;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_9129;

public class StageReward
extends Reward {
    private String stage = "";
    private boolean remove = false;

    public StageReward(long id, Quest quest, String stage) {
        super(id, quest);
        this.stage = stage;
        this.autoclaim = RewardAutoClaim.INVISIBLE;
    }

    public StageReward(long id, Quest quest) {
        this(id, quest, "");
    }

    @Override
    public RewardType getType() {
        return RewardTypes.STAGE;
    }

    @Override
    public void writeData(class_2487 nbt, class_7225.class_7874 provider) {
        super.writeData(nbt, provider);
        nbt.method_10582("stage", this.stage);
        if (this.remove) {
            nbt.method_10556("remove", true);
        }
    }

    @Override
    public void readData(class_2487 nbt, class_7225.class_7874 provider) {
        super.readData(nbt, provider);
        this.stage = nbt.method_10558("stage");
        this.remove = nbt.method_10577("remove");
    }

    @Override
    public void writeNetData(class_9129 buffer) {
        super.writeNetData(buffer);
        buffer.method_10788(this.stage, Short.MAX_VALUE);
        buffer.method_52964(this.remove);
    }

    @Override
    public void readNetData(class_9129 buffer) {
        super.readNetData(buffer);
        this.stage = buffer.method_10800(Short.MAX_VALUE);
        this.remove = buffer.readBoolean();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addString("stage", this.stage, v -> {
            this.stage = v;
        }, "").setNameKey("ftbquests.reward.ftbquests.gamestage");
        config.addBool("remove", this.remove, v -> {
            this.remove = v;
        }, false);
    }

    @Override
    public void claim(class_3222 player, boolean notify) {
        if (this.remove) {
            StageHelper.INSTANCE.getProvider().remove(player, this.stage);
        } else {
            StageHelper.INSTANCE.getProvider().add(player, this.stage);
        }
        if (notify) {
            if (this.remove) {
                player.method_43502((class_2561)class_2561.method_43469((String)"commands.gamestage.remove.target", (Object[])new Object[]{this.stage}), true);
            } else {
                player.method_43502((class_2561)class_2561.method_43469((String)"commands.gamestage.add.target", (Object[])new Object[]{this.stage}), true);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class_5250 getAltTitle() {
        return class_2561.method_43471((String)"ftbquests.reward.ftbquests.gamestage").method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)this.stage).method_27692(class_124.field_1054));
    }

    @Override
    public boolean ignoreRewardBlocking() {
        return true;
    }

    @Override
    protected boolean isIgnoreRewardBlockingHardcoded() {
        return true;
    }
}

