/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.net.NotifyRewardMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_9129;

public class CommandReward
extends Reward {
    private static final String DEFAULT_COMMAND = "/say Hi, @p!";
    private static final Icon REWARD_ICON = Icon.getIcon((String)"minecraft:block/command_block_back");
    public static final Pattern PATTERN = Pattern.compile("[{](\\w+)}");
    private String command = "/say Hi, @p!";
    private int permissionLevel = 0;
    private boolean silent;
    private String feedbackMessage = "";

    public CommandReward(long id, Quest quest) {
        super(id, quest);
    }

    @Override
    public RewardType getType() {
        return RewardTypes.COMMAND;
    }

    @Override
    public void writeData(class_2487 nbt, class_7225.class_7874 provider) {
        super.writeData(nbt, provider);
        nbt.method_10582("command", this.command);
        if (this.permissionLevel > 0) {
            nbt.method_10569("permission_level", this.permissionLevel);
        }
        if (this.silent) {
            nbt.method_10556("silent", true);
        }
        if (!this.feedbackMessage.isEmpty()) {
            nbt.method_10582("feedback_message", this.feedbackMessage);
        }
    }

    @Override
    public void readData(class_2487 nbt, class_7225.class_7874 provider) {
        super.readData(nbt, provider);
        this.command = nbt.method_10558("command");
        this.permissionLevel = nbt.method_10577("elevate_perms") ? 2 : nbt.method_10550("permission_level");
        this.silent = nbt.method_10577("silent");
        this.feedbackMessage = nbt.method_10558("feedback_message");
    }

    @Override
    public void writeNetData(class_9129 buffer) {
        super.writeNetData(buffer);
        buffer.method_10788(this.command, Short.MAX_VALUE);
        buffer.method_10804(this.permissionLevel);
        buffer.method_52964(this.silent);
        buffer.method_10788(this.feedbackMessage, Short.MAX_VALUE);
    }

    @Override
    public void readNetData(class_9129 buffer) {
        super.readNetData(buffer);
        this.command = buffer.method_10800(Short.MAX_VALUE);
        this.permissionLevel = buffer.method_10816();
        this.silent = buffer.readBoolean();
        this.feedbackMessage = buffer.method_10800(Short.MAX_VALUE);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addString("command", this.command, v -> {
            this.command = v;
        }, DEFAULT_COMMAND).setNameKey("ftbquests.reward.ftbquests.command");
        config.addInt("permission_level", this.permissionLevel, v -> {
            this.permissionLevel = v;
        }, 0, 0, 4);
        config.addBool("silent", this.silent, v -> {
            this.silent = v;
        }, false);
        config.addString("feedback_message", this.feedbackMessage, v -> {
            this.feedbackMessage = v;
        }, "");
    }

    @Override
    public void claim(class_3222 player, boolean notify) {
        HashMap<String, Object> overrides = new HashMap<String, Object>();
        overrides.put("p", player.method_7334().getName());
        class_2338 pos = player.method_24515();
        overrides.put("x", pos.method_10263());
        overrides.put("y", pos.method_10264());
        overrides.put("z", pos.method_10260());
        if (this.getQuestChapter() != null) {
            overrides.put("chapter", this.getQuestChapter());
        }
        overrides.put("quest", this.quest);
        FTBTeamsAPI.api().getManager().getTeamForPlayer(player).ifPresent(team -> {
            overrides.put("team", team.getName().getString());
            overrides.put("team_id", team.getShortName());
            overrides.put("long_team_id", team.getId().toString());
            overrides.put("member_count", team.getMembers().size());
            overrides.put("online_member_count", team.getOnlineMembers().size());
        });
        String cmd = CommandReward.format(this.command.trim(), overrides);
        class_2168 source = player.method_5671();
        if (this.permissionLevel > 0) {
            source = source.method_9206(this.permissionLevel);
        }
        if (this.silent) {
            source = source.method_9217();
        }
        player.field_13995.method_3734().method_44252(source, cmd);
        if (notify) {
            String key = this.feedbackMessage.isEmpty() ? "ftbquests.reward.ftbquests.command.success" : this.feedbackMessage;
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new NotifyRewardMessage(this.id, (class_2561)class_2561.method_43471((String)key), REWARD_ICON, this.disableRewardScreenBlur));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class_5250 getAltTitle() {
        return class_2561.method_43471((String)"ftbquests.reward.ftbquests.command").method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)this.command).method_27692(class_124.field_1061));
    }

    public static String format(String template, Map<String, Object> parameters) {
        StringBuilder newTemplate = new StringBuilder(template);
        ArrayList<Object> valueList = new ArrayList<Object>();
        Matcher matcher = PATTERN.matcher(template);
        while (matcher.find()) {
            String paramName;
            int index;
            String key = matcher.group(1);
            if (!parameters.containsKey(key) || (index = newTemplate.indexOf(paramName = "{" + key + "}")) == -1) continue;
            newTemplate.replace(index, index + paramName.length(), "%s");
            valueList.add(parameters.get(key));
        }
        return String.format(newTemplate.toString(), valueList.toArray());
    }
}

