/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.events;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbquests.net.NotifyCompletionMessage;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public final class QuestProgressEventData<T extends QuestObject> {
    private final Date time;
    private final TeamData teamData;
    private final T object;
    private final List<class_3222> onlineMembers;
    private final List<class_3222> notifiedPlayers;

    public QuestProgressEventData(Date date, TeamData teamData, T object, Collection<class_3222> online, Collection<class_3222> notified) {
        this.time = date;
        this.teamData = teamData;
        this.object = object;
        this.onlineMembers = new ArrayList<class_3222>(online);
        this.notifiedPlayers = new ArrayList<class_3222>(notified);
    }

    public void setStarted(long id) {
        this.teamData.setStarted(id, this.time);
    }

    public void setCompleted(long id) {
        this.teamData.setCompleted(id, this.time);
    }

    public void notifyPlayers(long id) {
        this.notifiedPlayers.forEach(player -> NetworkManager.sendToPlayer((class_3222)player, (class_8710)new NotifyCompletionMessage(id)));
    }

    public Date getTime() {
        return this.time;
    }

    public TeamData getTeamData() {
        return this.teamData;
    }

    public T getObject() {
        return this.object;
    }

    public List<class_3222> getOnlineMembers() {
        return this.onlineMembers;
    }

    public List<class_3222> getNotifiedPlayers() {
        return this.notifiedPlayers;
    }

    public <N extends QuestObject> QuestProgressEventData<N> withObject(N o) {
        return this.object == o ? this : new QuestProgressEventData<N>(this.time, this.teamData, o, this.onlineMembers, this.notifiedPlayers);
    }
}

