/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import dev.architectury.fluid.FluidStack;
import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.FluidConfig;
import dev.ftb.mods.ftblibrary.config.IntConfig;
import dev.ftb.mods.ftblibrary.config.ItemStackConfig;
import dev.ftb.mods.ftblibrary.config.LongConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.config.ui.EditStringConfigOverlay;
import dev.ftb.mods.ftblibrary.config.ui.SelectFluidScreen;
import dev.ftb.mods.ftblibrary.config.ui.SelectItemStackScreen;
import dev.ftb.mods.ftblibrary.ui.ModalPanel;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftbquests.client.gui.SelectQuestObjectScreen;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.reward.ItemReward;
import dev.ftb.mods.ftbquests.quest.reward.RandomReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.quest.reward.StageReward;
import dev.ftb.mods.ftbquests.quest.reward.XPLevelsReward;
import dev.ftb.mods.ftbquests.quest.reward.XPReward;
import dev.ftb.mods.ftbquests.quest.task.CheckmarkTask;
import dev.ftb.mods.ftbquests.quest.task.DimensionTask;
import dev.ftb.mods.ftbquests.quest.task.FluidTask;
import dev.ftb.mods.ftbquests.quest.task.ISingleLongValueTask;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.quest.task.LocationTask;
import dev.ftb.mods.ftbquests.quest.task.ObservationTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.quest.translation.TranslationKey;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import java.util.function.BiConsumer;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2633;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public class GuiProviders {
    public static RewardType.GuiProvider defaultRewardGuiProvider(RewardType.Provider provider) {
        return (gui, quest, callback) -> {
            Reward reward = provider.create(0L, quest);
            if (reward instanceof RandomReward) {
                RandomReward randomReward = (RandomReward)reward;
                ConfigQuestObject config = new ConfigQuestObject(QuestObjectType.REWARD_TABLE);
                SelectQuestObjectScreen s = new SelectQuestObjectScreen(config, accepted -> {
                    if (accepted) {
                        randomReward.setTable((RewardTable)config.getValue());
                        callback.accept(reward);
                    }
                    gui.run();
                });
                s.setTitle((class_2561)class_2561.method_43471((String)"ftbquests.gui.select_reward_table"));
                s.setHasSearchBox(true);
                s.openGui();
            } else {
                ConfigGroup group = new ConfigGroup("ftbquests", accepted -> {
                    if (accepted) {
                        callback.accept(reward);
                    }
                    gui.run();
                });
                group.setNameKey(reward.getType().getTypeId().method_42093("ftbquests.reward"));
                reward.fillConfigGroup(reward.createSubGroup(group));
                new EditConfigScreen(group).openGui();
            }
        };
    }

    public static TaskType.GuiProvider defaultTaskGuiProvider(TaskType.Provider provider) {
        return (panel, quest, callback) -> {
            Task task = provider.create(0L, quest);
            if (task instanceof ISingleLongValueTask) {
                ISingleLongValueTask slvTask = (ISingleLongValueTask)((Object)task);
                LongConfig c = new LongConfig(slvTask.getMinConfigValue(), slvTask.getMaxConfigValue());
                c.setValue((Object)slvTask.getMinConfigValue());
                EditStringConfigOverlay overlay = new EditStringConfigOverlay((Panel)panel.getGui(), (ConfigFromString)c, accepted -> {
                    if (accepted) {
                        slvTask.setValue((Long)c.getValue());
                        callback.accept(task, task.getType().makeExtraNBT());
                    }
                    panel.run();
                }, task.getType().getDisplayName()).atMousePosition();
                overlay.setExtraZlevel(300);
                panel.getGui().pushModalPanel((ModalPanel)overlay);
            } else {
                GuiProviders.openSetupGui((Runnable)panel.getGui(), callback, task);
            }
        };
    }

    public static void setTaskGuiProviders() {
        TaskTypes.ITEM.setGuiProvider((gui, quest, callback) -> {
            ItemStackConfig c = new ItemStackConfig(false, false);
            new SelectItemStackScreen(c, accepted -> {
                gui.run();
                if (accepted) {
                    ItemTask itemTask = new ItemTask(0L, quest).setStackAndCount(c.getValue(), c.getValue().method_7947());
                    callback.accept(itemTask, itemTask.getType().makeExtraNBT());
                }
            }).openGui();
        });
        TaskTypes.CHECKMARK.setGuiProvider((panel, quest, callback) -> {
            StringConfig c = new StringConfig(null);
            c.setValue((Object)"");
            EditStringConfigOverlay overlay = new EditStringConfigOverlay((Panel)panel.getGui(), (ConfigFromString)c, accepted -> {
                if (accepted) {
                    CheckmarkTask checkmarkTask = new CheckmarkTask(0L, quest);
                    checkmarkTask.setRawTitle((String)c.getValue());
                    class_2487 extra = checkmarkTask.getType().makeExtraNBT();
                    quest.getQuestFile().getTranslationManager().addInitialTranslation(extra, quest.getQuestFile().getLocale(), TranslationKey.TITLE, (String)c.getValue());
                    callback.accept(checkmarkTask, extra);
                }
                panel.run();
            }, TaskTypes.CHECKMARK.getDisplayName()).atMousePosition();
            overlay.setExtraZlevel(300);
            panel.getGui().pushModalPanel((ModalPanel)overlay);
        });
        TaskTypes.FLUID.setGuiProvider((gui, quest, callback) -> {
            FluidConfig c = new FluidConfig(false);
            new SelectFluidScreen(c, accepted -> {
                gui.run();
                if (accepted) {
                    FluidTask fluidTask = new FluidTask(0L, quest).setFluid((FluidStack)c.getValue());
                    callback.accept(fluidTask, fluidTask.getType().makeExtraNBT());
                }
            }).openGui();
        });
        TaskTypes.DIMENSION.setGuiProvider((gui, quest, callback) -> {
            DimensionTask task = new DimensionTask(0L, quest).withDimension((class_5321<class_1937>)class_310.method_1551().field_1687.method_27983());
            GuiProviders.openSetupGui((Runnable)gui, callback, task);
        });
        TaskTypes.OBSERVATION.setGuiProvider((gui, quest, callback) -> {
            ObservationTask task = new ObservationTask(0L, quest);
            class_239 patt0$temp = class_310.method_1551().field_1765;
            if (patt0$temp instanceof class_3965) {
                class_3965 bhr = (class_3965)patt0$temp;
                class_2248 block = class_310.method_1551().field_1687.method_8320(bhr.method_17777()).method_26204();
                task.setToObserve(class_7923.field_41175.method_10221((Object)block).toString());
            }
            GuiProviders.openSetupGui((Runnable)gui, callback, task);
        });
        TaskTypes.LOCATION.setGuiProvider((gui, quest, callback) -> {
            class_3965 bhr;
            class_2586 blockEntity;
            LocationTask task = new LocationTask(0L, quest);
            class_310 mc = class_310.method_1551();
            class_239 patt0$temp = mc.field_1765;
            if (patt0$temp instanceof class_3965 && (blockEntity = mc.field_1687.method_8321((bhr = (class_3965)patt0$temp).method_17777())) instanceof class_2633) {
                class_2633 structure = (class_2633)blockEntity;
                task.initFromStructure(structure);
                callback.accept(task, task.getType().makeExtraNBT());
                return;
            }
            GuiProviders.openSetupGui((Runnable)gui, callback, task);
        });
    }

    private static void openSetupGui(Runnable gui, BiConsumer<Task, class_2487> callback, Task task) {
        ConfigGroup group = new ConfigGroup("ftbquests", accepted -> {
            gui.run();
            if (accepted) {
                callback.accept(task, task.getType().makeExtraNBT());
            }
        });
        group.setNameKey(task.getType().getTypeId().method_42093("ftbquests.task"));
        task.fillConfigGroup(task.createSubGroup(group));
        new EditConfigScreen(group).openGui();
    }

    public static void setRewardGuiProviders() {
        RewardTypes.ITEM.setGuiProvider((gui, quest, callback) -> {
            ItemStackConfig c = new ItemStackConfig(false, false);
            new SelectItemStackScreen(c, accepted -> {
                if (accepted) {
                    class_1799 copy = c.getValue().method_7972();
                    copy.method_7939(1);
                    ItemReward reward = new ItemReward(0L, quest, copy, c.getValue().method_7947());
                    callback.accept(reward);
                }
                gui.run();
            }).openGui();
        });
        RewardTypes.XP.setGuiProvider((panel, quest, callback) -> {
            IntConfig c = new IntConfig(1, Integer.MAX_VALUE);
            c.setValue((Object)100);
            EditStringConfigOverlay overlay = new EditStringConfigOverlay((Panel)panel.getGui(), (ConfigFromString)c, accepted -> {
                if (accepted) {
                    callback.accept(new XPReward(0L, quest, (Integer)c.getValue()));
                }
                panel.run();
            }, RewardTypes.XP.getDisplayName()).atMousePosition();
            panel.getGui().pushModalPanel((ModalPanel)overlay);
        });
        RewardTypes.XP_LEVELS.setGuiProvider((panel, quest, callback) -> {
            IntConfig c = new IntConfig(1, Integer.MAX_VALUE);
            c.setValue((Object)5);
            EditStringConfigOverlay overlay = new EditStringConfigOverlay((Panel)panel.getGui(), (ConfigFromString)c, accepted -> {
                if (accepted) {
                    callback.accept(new XPLevelsReward(0L, quest, (Integer)c.getValue()));
                }
                panel.run();
            }, RewardTypes.XP_LEVELS.getDisplayName()).atMousePosition();
            panel.getGui().pushModalPanel((ModalPanel)overlay);
        });
        RewardTypes.STAGE.setGuiProvider((panel, quest, callback) -> {
            StringConfig c = new StringConfig();
            EditStringConfigOverlay overlay = new EditStringConfigOverlay((Panel)panel.getGui(), (ConfigFromString)c, accepted -> {
                if (accepted) {
                    callback.accept(new StageReward(0L, quest, (String)c.getValue()));
                }
                panel.run();
            }, RewardTypes.STAGE.getDisplayName()).atMousePosition();
            panel.getGui().pushModalPanel((ModalPanel)overlay);
        });
    }
}

