/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.block.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.config.BooleanConfig;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ItemStackConfig;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.block.TaskScreenBlock;
import dev.ftb.mods.ftbquests.block.entity.ITaskScreen;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.net.TaskScreenConfigResponseMessage;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.registry.ModBlockEntityTypes;
import dev.ftb.mods.ftbquests.registry.ModBlocks;
import dev.ftb.mods.ftbquests.registry.ModDataComponents;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3341;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskScreenBlockEntity
extends class_2586
implements ITaskScreen {
    private long taskId = 0L;
    private Task task = null;
    private boolean indestructible = false;
    private boolean inputOnly = false;
    private boolean textShadow = false;
    private class_1799 inputModeIcon = class_1799.field_8037;
    private class_1799 skin = class_1799.field_8037;
    @NotNull
    private UUID teamId = class_156.field_25140;
    public float[] fakeTextureUV = null;
    private TeamData cachedTeamData = null;

    public TaskScreenBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)ModBlockEntityTypes.CORE_TASK_SCREEN.get(), blockPos, blockState);
    }

    public Task getTask() {
        if (this.task == null && this.taskId != 0L || this.task != null && this.task.id != this.taskId) {
            this.task = FTBQuestsAPI.api().getQuestFile(this.field_11863.field_9236).getTask(this.taskId);
        }
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
        this.taskId = task == null ? 0L : task.id;
        this.method_5431();
    }

    @Override
    public boolean isInputOnly() {
        return this.inputOnly;
    }

    public void setInputOnly(boolean inputOnly) {
        this.inputOnly = inputOnly;
        this.method_5431();
    }

    public class_1799 getInputModeIcon() {
        return this.inputModeIcon;
    }

    public void setInputModeIcon(class_1799 inputModeIcon) {
        this.inputModeIcon = inputModeIcon;
        this.method_5431();
    }

    @Override
    public boolean isIndestructible() {
        return this.indestructible;
    }

    public void setIndestructible(boolean indestructible) {
        this.indestructible = indestructible;
        this.method_5431();
    }

    @Override
    public class_1799 getSkin() {
        return this.skin;
    }

    public void setSkin(class_1799 skin) {
        this.skin = skin;
        this.fakeTextureUV = null;
    }

    public boolean isTextShadow() {
        return this.textShadow;
    }

    public void setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
    }

    public void setTeamId(@NotNull UUID teamId) {
        this.teamId = teamId;
        this.cachedTeamData = null;
    }

    @Override
    @NotNull
    public UUID getTeamId() {
        return this.teamId;
    }

    public TeamData getCachedTeamData() {
        if (this.cachedTeamData == null) {
            BaseQuestFile f = FTBQuestsAPI.api().getQuestFile(this.field_11863.field_9236);
            this.cachedTeamData = f.getNullableTeamData(this.getTeamId());
        }
        return this.cachedTeamData;
    }

    @Override
    public Optional<TaskScreenBlockEntity> getCoreScreen() {
        return Optional.of(this);
    }

    public void removeAllAuxScreens() {
        class_2248 class_22482;
        if (this.field_11863 != null && (class_22482 = this.method_11010().method_26204()) instanceof TaskScreenBlock) {
            TaskScreenBlock tsb = (TaskScreenBlock)class_22482;
            class_2338.method_23627((class_3341)TaskScreenBlock.getMultiblockBounds(this.method_11016(), tsb.getSize(), (class_2350)this.method_11010().method_11654((class_2769)TaskScreenBlock.FACING))).forEach(pos -> {
                if (this.field_11863.method_8320(pos).method_26204() == ModBlocks.AUX_SCREEN.get()) {
                    this.field_11863.method_8650(pos, false);
                }
            });
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_38244(provider);
    }

    public void method_11014(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11014(compoundTag, provider);
        this.teamId = compoundTag.method_25928("TeamID") ? compoundTag.method_25926("TeamID") : class_156.field_25140;
        TaskScreenSaveData data = TaskScreenSaveData.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)compoundTag.method_10562("savedData")).result().orElse(TaskScreenSaveData.DEFAULT);
        this.applySavedData(data);
        this.task = null;
        this.fakeTextureUV = null;
    }

    protected void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11007(compoundTag, provider);
        if (this.teamId != class_156.field_25140) {
            compoundTag.method_25927("TeamID", this.teamId);
        }
        TaskScreenSaveData.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)TaskScreenSaveData.fromBlockEntity(this)).ifSuccess(tag -> compoundTag.method_10566("savedData", tag));
    }

    protected void method_57568(class_2586.class_9473 dataComponentInput) {
        super.method_57568(dataComponentInput);
        this.applySavedData((TaskScreenSaveData)dataComponentInput.method_58695((class_9331)ModDataComponents.TASK_SCREEN_SAVED.get(), (Object)TaskScreenSaveData.DEFAULT));
    }

    protected void method_57567(class_9323.class_9324 builder) {
        super.method_57567(builder);
        builder.method_57840((class_9331)ModDataComponents.TASK_SCREEN_SAVED.get(), (Object)TaskScreenSaveData.fromBlockEntity(this));
    }

    private void applySavedData(TaskScreenSaveData data) {
        this.taskId = data.taskId;
        this.skin = data.skin;
        this.indestructible = data.indestructible;
        this.inputOnly = data.inputOnly;
        this.inputModeIcon = data.inputModeIcon;
        this.textShadow = data.textShadow;
    }

    public ConfigGroup fillConfigGroup(TeamData data) {
        ConfigGroup cg0 = new ConfigGroup("task_screen", accepted -> {
            if (accepted) {
                NetworkManager.sendToServer((class_8710)new TaskScreenConfigResponseMessage(this.method_11016(), this.method_38244((class_7225.class_7874)this.method_10997().method_30349())));
            }
        });
        cg0.setNameKey(this.method_11010().method_26204().method_9539());
        ConfigGroup cg = cg0.getOrCreateSubgroup("screen");
        ((ConfigQuestObject)cg.add("task", new ConfigQuestObject<Task>(o -> this.isSuitableTask(data, (QuestObjectBase)o), this::formatLine), (Object)this.getTask(), this::setTask, null)).setNameKey("ftbquests.task");
        ((ItemStackConfig)cg.add("skin", (ConfigValue)new ItemStackConfig(true, true), (Object)this.getSkin(), this::setSkin, (Object)class_1799.field_8037)).setNameKey("block.ftbquests.screen.skin");
        ((BooleanConfig)cg.add("text_shadow", (ConfigValue)new BooleanConfig(), (Object)this.isTextShadow(), this::setTextShadow, (Object)false)).setNameKey("block.ftbquests.screen.text_shadow");
        ((BooleanConfig)cg.add("indestructible", (ConfigValue)new BooleanConfig(), (Object)this.isIndestructible(), this::setIndestructible, (Object)false)).setNameKey("block.ftbquests.screen.indestructible");
        ((BooleanConfig)cg.add("input_only", (ConfigValue)new BooleanConfig(), (Object)this.isInputOnly(), this::setInputOnly, (Object)false)).setNameKey("block.ftbquests.screen.input_only");
        ((ItemStackConfig)cg.add("input_icon", (ConfigValue)new ItemStackConfig(true, true), (Object)this.getInputModeIcon(), this::setInputModeIcon, (Object)class_1799.field_8037)).setNameKey("block.ftbquests.screen.input_mode_icon");
        return cg0;
    }

    private class_2561 formatLine(Task task) {
        if (this.task == null) {
            return class_2561.method_43473();
        }
        class_5250 questTxt = class_2561.method_43470((String)" [").method_10852(task.getQuest().getTitle()).method_27693("]").method_27692(class_124.field_1060);
        return ConfigQuestObject.formatEntry(task).method_27661().method_10852((class_2561)questTxt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSuitableTask(TeamData data, QuestObjectBase o) {
        if (!(o instanceof Task)) return false;
        Task t = (Task)o;
        if (!data.getCanEdit(FTBQuestsClient.getClientPlayer())) {
            if (!data.canStartTasks(t.getQuest())) return false;
        }
        if (!t.consumesResources()) return false;
        return true;
    }

    public float[] getFakeTextureUV() {
        if (this.fakeTextureUV == null) {
            class_1792 class_17922;
            if (!this.skin.method_7960() && (class_17922 = this.skin.method_7909()) instanceof class_1747) {
                class_1747 bi = (class_1747)class_17922;
                class_2680 state = bi.method_7711().method_9564();
                class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)TaskScreenBlock.FACING);
                if (state.method_28498((class_2769)class_2741.field_12481)) {
                    state = (class_2680)state.method_11657((class_2769)class_2741.field_12481, (Comparable)facing);
                } else if (state.method_28498((class_2769)class_2741.field_12525)) {
                    state = (class_2680)state.method_11657((class_2769)class_2741.field_12525, (Comparable)facing);
                }
                this.fakeTextureUV = FTBQuestsClient.getTextureUV(state, facing);
            } else {
                this.fakeTextureUV = new float[0];
            }
        }
        return this.fakeTextureUV;
    }

    public record TaskScreenSaveData(long taskId, class_1799 skin, boolean indestructible, boolean inputOnly, class_1799 inputModeIcon, boolean textShadow) {
        public static TaskScreenSaveData DEFAULT = new TaskScreenSaveData(0L, class_1799.field_8037, false, false, class_1799.field_8037, false);
        public static final Codec<TaskScreenSaveData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.LONG.optionalFieldOf("taskId", (Object)0L).forGetter(TaskScreenSaveData::taskId), (App)class_1799.field_24671.optionalFieldOf("skin", (Object)class_1799.field_8037).forGetter(TaskScreenSaveData::skin), (App)Codec.BOOL.optionalFieldOf("indestructible", (Object)false).forGetter(TaskScreenSaveData::indestructible), (App)Codec.BOOL.optionalFieldOf("input_only", (Object)false).forGetter(TaskScreenSaveData::inputOnly), (App)class_1799.field_24671.optionalFieldOf("skin", (Object)class_1799.field_8037).forGetter(TaskScreenSaveData::inputModeIcon), (App)Codec.BOOL.optionalFieldOf("text_shadow", (Object)false).forGetter(TaskScreenSaveData::textShadow)).apply((Applicative)builder, TaskScreenSaveData::new));
        public static class_9139<class_9129, TaskScreenSaveData> STREAM_CODEC = class_9139.method_58025((class_9139)class_9135.field_48551, TaskScreenSaveData::taskId, (class_9139)class_1799.field_49268, TaskScreenSaveData::skin, (class_9139)class_9135.field_48547, TaskScreenSaveData::indestructible, (class_9139)class_9135.field_48547, TaskScreenSaveData::inputOnly, (class_9139)class_1799.field_49268, TaskScreenSaveData::inputModeIcon, (class_9139)class_9135.field_48547, TaskScreenSaveData::textShadow, TaskScreenSaveData::new);

        public static TaskScreenSaveData fromBlockEntity(TaskScreenBlockEntity b) {
            return new TaskScreenSaveData(b.taskId, b.skin, b.indestructible, b.inputOnly, b.inputModeIcon, b.textShadow);
        }
    }
}

