/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import dev.ftb.mods.ftbteams.api.event.TeamCollectPropertiesEvent;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyCollection;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_151;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class TeamPropertyCollectionImpl
implements TeamPropertyCollection {
    private final PropertyMap map = new PropertyMap();
    public static final class_9139<class_9129, TeamPropertyCollection> STREAM_CODEC = class_9139.method_56437((buffer, props) -> {
        buffer.method_10804(props.size());
        props.forEach((prop, value) -> {
            TeamPropertyType.write(buffer, prop);
            prop.writeValue((class_9129)buffer, value.getValue());
        });
    }, buffer -> {
        TeamPropertyCollectionImpl props = new TeamPropertyCollectionImpl();
        int nProperties = buffer.method_10816();
        for (int i = 0; i < nProperties; ++i) {
            TeamProperty<?> tp = TeamPropertyType.read(buffer);
            props.map.putNetworkProperty(tp, (class_9129)buffer);
        }
        return props;
    });

    public void collectProperties() {
        this.map.clear();
        ((Consumer)TeamEvent.COLLECT_PROPERTIES.invoker()).accept(new TeamCollectPropertiesEvent(this.map::putDefaultProperty));
    }

    @Override
    public <T> void forEach(BiConsumer<TeamProperty<T>, TeamPropertyValue<T>> consumer) {
        this.map.forEachProperty(consumer);
    }

    @Override
    public TeamPropertyCollectionImpl copy() {
        TeamPropertyCollectionImpl p = new TeamPropertyCollectionImpl();
        this.map.forEachProperty((key, value) -> p.map.putProperty(key, value.copy()));
        return p;
    }

    @Override
    public void updateFrom(TeamPropertyCollection otherProperties) {
        otherProperties.forEach((key, value) -> this.set((TeamProperty)key, value.getValue()));
    }

    @Override
    public <T> T get(TeamProperty<T> key) {
        TeamPropertyValue<T> v = this.map.getProperty(key);
        return v == null ? key.getDefaultValue() : v.getValue();
    }

    @Override
    public <T> void set(TeamProperty<T> key, T value) {
        if (this.map.hasProperty(key)) {
            this.map.getProperty(key).setValue(value);
        } else {
            this.map.putProperty(key, new TeamPropertyValue<T>(key, value));
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public void write(class_9129 buffer) {
        STREAM_CODEC.encode((Object)buffer, (Object)this);
    }

    public void writeSyncableOnly(class_9129 buffer, List<TeamProperty<?>> syncableProps) {
        PropertyMap subMap = new PropertyMap();
        syncableProps.forEach((? super T prop) -> {
            if (this.map.hasProperty((TeamProperty<?>)prop)) {
                subMap.backingMap.put(prop, this.map.backingMap.get(prop));
            }
        });
        buffer.method_10804(subMap.size());
        subMap.forEachProperty((key, value) -> {
            TeamPropertyType.write(buffer, key);
            key.writeValue(buffer, value.getValue());
        });
    }

    public void read(class_2487 tag) {
        tag.method_10541().forEach((? super T key) -> this.map.findProperty((String)key).ifPresent(prop -> this.map.putNBTProperty((TeamProperty<?>)prop, tag.method_10580(key))));
    }

    public class_2487 write(class_2487 tag) {
        this.map.forEachProperty((key, value) -> tag.method_10566(key.getId().toString(), key.toNBT(value.getValue())));
        return tag;
    }

    private static class PropertyMap {
        final Map<Object, Object> backingMap = new LinkedHashMap<Object, Object>();
        final Map<class_2960, TeamProperty<?>> byId = new HashMap();

        private PropertyMap() {
        }

        void clear() {
            this.backingMap.clear();
            this.byId.clear();
        }

        boolean hasProperty(TeamProperty<?> prop) {
            return this.backingMap.containsKey(prop);
        }

        int size() {
            return this.backingMap.size();
        }

        <T> void putProperty(TeamProperty<T> prop, TeamPropertyValue<T> value) {
            this.backingMap.put(prop, value);
            this.byId.put(prop.getId(), prop);
        }

        void putDefaultProperty(TeamProperty<?> prop) {
            this.backingMap.put(prop, prop.createDefaultValue());
            this.byId.put(prop.getId(), prop);
        }

        void putNetworkProperty(TeamProperty<?> prop, class_9129 buffer) {
            this.backingMap.put(prop, prop.createValueFromNetwork(buffer));
            this.byId.put(prop.getId(), prop);
        }

        void putNBTProperty(TeamProperty<?> prop, class_2520 tag) {
            this.backingMap.put(prop, prop.createValueFromNBT(tag));
            this.byId.put(prop.getId(), prop);
        }

        <T> TeamPropertyValue<T> getProperty(TeamProperty<T> property) {
            return (TeamPropertyValue)this.backingMap.get(property);
        }

        <T> void forEachProperty(BiConsumer<TeamProperty<T>, TeamPropertyValue<T>> consumer) {
            this.backingMap.forEach((k, v) -> consumer.accept((TeamProperty)k, (TeamPropertyValue)v));
        }

        Optional<TeamProperty<?>> findProperty(String key) {
            try {
                return Optional.ofNullable(this.byId.get(class_2960.method_12829((String)key)));
            }
            catch (class_151 e) {
                return Optional.empty();
            }
        }
    }
}

