/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.particles;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.effect.SpawnSnowstormEntityParticlePacket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;

public class AlphaParticleEffect {
    private static final class_2960 ALPHA_PARTICLE = class_2960.method_60655((String)"cobblemon", (String)"alpha_burst");
    private static final class_2960 ALPHA_NEARBY_SOUND = class_2960.method_60655((String)"cobblemonalphas", (String)"alpha_spawn");
    private static final Map<UUID, Long> alphaAmbientTimer = new HashMap<UUID, Long>();
    private static final double particleDistance = 26.0;
    private static final int particleInterval = 20000;

    public static void tick(MinecraftServer server) {
        List players = server.method_3760().method_14571();
        server.method_3738().forEach(level -> level.method_27909().forEach(entity -> {
            Long startTime;
            PokemonEntity pokemonEntity;
            if (!(entity instanceof PokemonEntity) || !(pokemonEntity = (PokemonEntity)entity).getPokemon().getPersistentData().method_10577("IS_ALPHA")) {
                return;
            }
            boolean inRange = players.stream().anyMatch(player -> player.method_5858((class_1297)pokemonEntity) <= 676.0);
            class_3222 lookingAtAlpha = players.stream().filter(player -> pokemonEntity.getPokemon().isWild() && player.method_6057((class_1297)pokemonEntity)).findFirst().orElse(null);
            if (!inRange) {
                return;
            }
            if (!(!pokemonEntity.getPokemon().isWild() || pokemonEntity.isBattling() || pokemonEntity.isBusy() || lookingAtAlpha == null || (startTime = alphaAmbientTimer.get(pokemonEntity.method_5667())) != null && System.currentTimeMillis() - startTime < 20000L)) {
                AlphaParticleEffect.spawnParticles(pokemonEntity);
                alphaAmbientTimer.put(pokemonEntity.method_5667(), System.currentTimeMillis());
            }
        }));
    }

    public static void spawnParticles(PokemonEntity entity) {
        List<String> locator = List.of("root");
        SpawnSnowstormEntityParticlePacket packet = new SpawnSnowstormEntityParticlePacket(ALPHA_PARTICLE, entity.method_5628(), locator, Integer.valueOf(entity.method_5628()), List.of());
        packet.sendToPlayersAround(entity.method_23317(), entity.method_23318(), entity.method_23321(), 64.0, class_1937.field_25179, player -> false);
        class_3414 sound = class_3414.method_47909((class_2960)ALPHA_NEARBY_SOUND, (float)64.0f);
        entity.method_37908().method_45445((class_1297)entity, entity.method_24515(), sound, class_3419.field_15254, 2.0f, 1.0f);
    }
}

