/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.cudzer.cobblemonalphas.CobblemonAlphasMod;
import dev.cudzer.cobblemonalphas.entity.HerdMember;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.class_2960;
import net.minecraft.class_5699;

public class Alpha {
    public static Codec<Alpha> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("species").forGetter(t -> t.species), (App)Codec.STRING.fieldOf("level").forGetter(w -> w.levelRange), (App)Codec.BOOL.fieldOf("spawnUnderground").forGetter(s -> s.spawnUnderground), (App)HerdMember.CODEC.listOf().fieldOf("herdMembers").forGetter(h -> h.herdMembers), (App)class_5699.field_39274.listOf().optionalFieldOf("biome", Collections.emptyList()).forGetter(t -> t.biomeTags)).apply((Applicative)inst, Alpha::new));
    protected final String species;
    protected int level = 1;
    protected final String levelRange;
    protected final boolean spawnUnderground;
    protected final List<HerdMember> herdMembers;
    protected final List<class_2960> spawnBiome;
    protected final List<class_2960> spawnBiomeTags;
    protected final List<class_5699.class_7476> biomeTags;
    private class_2960 jsonLocation;
    private int minLevel = 1;
    private int maxLevel = 1;

    public Alpha(String species, String levelRange, boolean spawnUnderground, List<HerdMember> herdMembers, List<class_5699.class_7476> spawnBiome) {
        this.species = species;
        this.levelRange = levelRange;
        this.spawnUnderground = spawnUnderground;
        String[] levels = levelRange.split("-");
        if (levels.length == 1) {
            this.level = Integer.parseInt(levels[0]);
        } else if (levels.length == 2) {
            this.minLevel = Integer.parseInt(levels[0]);
            this.maxLevel = Integer.parseInt(levels[1]);
        } else {
            CobblemonAlphasMod.LOGGER.warn(String.format("Incorrect values defined for levels in alpha %s file. Assigning default values", species));
            this.minLevel = 40;
            this.maxLevel = 50;
        }
        this.herdMembers = herdMembers;
        ArrayList<class_2960> spawnBiomeTags = new ArrayList<class_2960>();
        ArrayList<class_2960> spawnBiomes = new ArrayList<class_2960>();
        for (class_5699.class_7476 tagOrElementLocation : spawnBiome) {
            if (tagOrElementLocation.comp_814()) {
                spawnBiomeTags.add(tagOrElementLocation.comp_813());
                continue;
            }
            spawnBiomes.add(tagOrElementLocation.comp_813());
        }
        this.spawnBiome = spawnBiomes;
        this.spawnBiomeTags = spawnBiomeTags;
        this.biomeTags = spawnBiome;
    }

    public void setJsonLocation(class_2960 jsonLocation) {
        this.jsonLocation = jsonLocation;
    }

    public class_2960 getJsonLocation() {
        try {
            return this.jsonLocation;
        }
        catch (Exception e) {
            CobblemonAlphasMod.LOGGER.error(String.format("Could not find json location due to %s", e));
            return class_2960.method_60654((String)"");
        }
    }

    public String getSpecies() {
        return this.species;
    }

    public boolean canSpawnUnderground() {
        return this.spawnUnderground;
    }

    public List<HerdMember> getHerdMembers() {
        return this.herdMembers;
    }

    public List<class_2960> getSpawnBiome() {
        return this.spawnBiome;
    }

    public List<class_2960> getSpawnBiomeTags() {
        return this.spawnBiomeTags;
    }

    public int getLevelFromRange() {
        if (this.level != 1) {
            return this.level;
        }
        return new Random().nextInt(this.minLevel, this.maxLevel);
    }
}

