/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.cudzer.cobblemonalphas.data.AlphaJsonDataManager;
import dev.cudzer.cobblemonalphas.entity.Alpha;
import dev.cudzer.cobblemonalphas.entity.spawner.AlphaSpawner;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class SpawnAlphaCommand {
    public static void registerCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"alphaspawn").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"pokemon", (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> class_2172.method_9265(SpawnAlphaCommand.getAlphaNames(), (SuggestionsBuilder)sb)).then(class_2170.method_9244((String)"spawnHerd", (ArgumentType)BoolArgumentType.bool()).executes(SpawnAlphaCommand::spawnAlpha))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"alphaspawn").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"random").then(class_2170.method_9244((String)"spawnHerd", (ArgumentType)BoolArgumentType.bool()).executes(SpawnAlphaCommand::spawnAlphaRandom))));
    }

    private static int spawnAlpha(CommandContext<class_2168> context) {
        return SpawnAlphaCommand.spawn(context, false);
    }

    private static int spawnAlphaRandom(CommandContext<class_2168> context) {
        return SpawnAlphaCommand.spawn(context, true);
    }

    private static int spawn(CommandContext<class_2168> context, boolean isRandom) {
        if (((class_2168)context.getSource()).method_43737()) {
            Alpha alpha = isRandom ? AlphaJsonDataManager.getRandomAlphaObj((class_1937)((class_2168)context.getSource()).method_9225()) : AlphaJsonDataManager.getAlphaObj((class_1937)((class_2168)context.getSource()).method_9225(), StringArgumentType.getString(context, (String)"pokemon"));
            boolean spawnHerd = BoolArgumentType.getBool(context, (String)"spawnHerd");
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (player == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Source player not found!"));
                return -1;
            }
            class_2382 spawnPos = new class_2382((int)player.method_23317(), (int)player.method_23318(), (int)player.method_23321());
            if (alpha == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Alpha not found!"));
                return -1;
            }
            AlphaSpawner.getInstance().spawnAlphaEntity(alpha, player.method_37908(), spawnPos, spawnHerd);
        }
        return 1;
    }

    private static Set<String> getAlphaNames() {
        Map<class_2960, Alpha> alphaData = AlphaJsonDataManager.getAlphaData();
        HashSet<String> names = new HashSet<String>();
        for (Alpha alpha : alphaData.values()) {
            names.add(alpha.getSpecies());
        }
        return names;
    }
}

