/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.CipherSink;
import okio.CipherSource;
import okio.FileSystem;
import okio.HashingSink;
import okio.HashingSource;
import okio.InputStreamSource;
import okio.Okio;
import okio.OutputStreamSink;
import okio.Path;
import okio.Sink;
import okio.SocketAsyncTimeout;
import okio.Source;
import okio.Timeout;
import okio.internal.ResourceFileSystem;
import okio.internal.ZipFilesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=5, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0011\u0010\u0006\u001a\u00020\u0005*\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0019\u0010\u000b\u001a\u00020\n*\u00020\u00012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u0019\u0010\u000f\u001a\u00020\u000e*\u00020\r2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u0019\u0010\u0014\u001a\u00020\u0013*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a\u0019\u0010\u0014\u001a\u00020\u0013*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0018\u001a\u0019\u0010\u001a\u001a\u00020\u0019*\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a\u0019\u0010\u001a\u001a\u00020\u0019*\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001c\u001a\u0019\u0010\u001f\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001f\u0010 \u001a\u001d\u0010#\u001a\u00020\u0001*\u00020\u00002\b\b\u0002\u0010\"\u001a\u00020!H\u0007\u00a2\u0006\u0004\b#\u0010$\u001a\u0011\u0010#\u001a\u00020\u0001*\u00020%\u00a2\u0006\u0004\b#\u0010&\u001a\u0011\u0010#\u001a\u00020\u0001*\u00020'\u00a2\u0006\u0004\b#\u0010(\u001a%\u0010#\u001a\u00020\u0001*\u00020)2\u0012\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0*\"\u00020+\u00a2\u0006\u0004\b#\u0010-\u001a\u0011\u0010.\u001a\u00020\r*\u00020\u0000\u00a2\u0006\u0004\b.\u0010/\u001a\u0011\u0010.\u001a\u00020\r*\u000200\u00a2\u0006\u0004\b.\u00101\u001a\u0011\u0010.\u001a\u00020\r*\u00020'\u00a2\u0006\u0004\b.\u00102\u001a%\u0010.\u001a\u00020\r*\u00020)2\u0012\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0*\"\u00020+\u00a2\u0006\u0004\b.\u00103\"\u001c\u00106\u001a\n 5*\u0004\u0018\u000104048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107\"\u001c\u0010:\u001a\u00020!*\u000608j\u0002`98@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;\u00a8\u0006<"}, d2={"Ljava/io/File;", "Lokio/Sink;", "appendingSink", "(Ljava/io/File;)Lokio/Sink;", "Ljava/lang/ClassLoader;", "Lokio/FileSystem;", "asResourceFileSystem", "(Ljava/lang/ClassLoader;)Lokio/FileSystem;", "Ljavax/crypto/Cipher;", "cipher", "Lokio/CipherSink;", "cipherSink", "(Lokio/Sink;Ljavax/crypto/Cipher;)Lokio/CipherSink;", "Lokio/Source;", "Lokio/CipherSource;", "cipherSource", "(Lokio/Source;Ljavax/crypto/Cipher;)Lokio/CipherSource;", "Ljava/security/MessageDigest;", "digest", "Lokio/HashingSink;", "hashingSink", "(Lokio/Sink;Ljava/security/MessageDigest;)Lokio/HashingSink;", "Ljavax/crypto/Mac;", "mac", "(Lokio/Sink;Ljavax/crypto/Mac;)Lokio/HashingSink;", "Lokio/HashingSource;", "hashingSource", "(Lokio/Source;Ljava/security/MessageDigest;)Lokio/HashingSource;", "(Lokio/Source;Ljavax/crypto/Mac;)Lokio/HashingSource;", "Lokio/Path;", "zipPath", "openZip", "(Lokio/FileSystem;Lokio/Path;)Lokio/FileSystem;", "", "append", "sink", "(Ljava/io/File;Z)Lokio/Sink;", "Ljava/io/OutputStream;", "(Ljava/io/OutputStream;)Lokio/Sink;", "Ljava/net/Socket;", "(Ljava/net/Socket;)Lokio/Sink;", "Ljava/nio/file/Path;", "", "Ljava/nio/file/OpenOption;", "options", "(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Lokio/Sink;", "source", "(Ljava/io/File;)Lokio/Source;", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)Lokio/Source;", "(Ljava/net/Socket;)Lokio/Source;", "(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Lokio/Source;", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "logger", "Ljava/util/logging/Logger;", "Ljava/lang/AssertionError;", "Lkotlin/AssertionError;", "isAndroidGetsocknameError", "(Ljava/lang/AssertionError;)Z", "okio"}, xs="okio/Okio")
final class Okio__JvmOkioKt {
    private static final Logger logger = Logger.getLogger("okio.Okio");

    @NotNull
    public static final Sink sink(@NotNull OutputStream $this$sink) {
        Intrinsics.checkNotNullParameter($this$sink, "<this>");
        return new OutputStreamSink($this$sink, new Timeout());
    }

    @NotNull
    public static final Source source(@NotNull InputStream $this$source) {
        Intrinsics.checkNotNullParameter($this$source, "<this>");
        return new InputStreamSource($this$source, new Timeout());
    }

    @NotNull
    public static final Sink sink(@NotNull Socket $this$sink) throws IOException {
        Intrinsics.checkNotNullParameter($this$sink, "<this>");
        SocketAsyncTimeout timeout2 = new SocketAsyncTimeout($this$sink);
        OutputStream outputStream2 = $this$sink.getOutputStream();
        Intrinsics.checkNotNullExpressionValue(outputStream2, "getOutputStream(...)");
        OutputStreamSink sink2 = new OutputStreamSink(outputStream2, timeout2);
        return timeout2.sink(sink2);
    }

    @NotNull
    public static final Source source(@NotNull Socket $this$source) throws IOException {
        Intrinsics.checkNotNullParameter($this$source, "<this>");
        SocketAsyncTimeout timeout2 = new SocketAsyncTimeout($this$source);
        InputStream inputStream2 = $this$source.getInputStream();
        Intrinsics.checkNotNullExpressionValue(inputStream2, "getInputStream(...)");
        InputStreamSource source2 = new InputStreamSource(inputStream2, timeout2);
        return timeout2.source(source2);
    }

    @JvmOverloads
    @NotNull
    public static final Sink sink(@NotNull File $this$sink, boolean append) throws FileNotFoundException {
        Intrinsics.checkNotNullParameter($this$sink, "<this>");
        return Okio.sink(new FileOutputStream($this$sink, append));
    }

    public static /* synthetic */ Sink sink$default(File file, boolean bl, int n, Object object) throws FileNotFoundException {
        if ((n & 1) != 0) {
            bl = false;
        }
        return Okio.sink(file, bl);
    }

    @NotNull
    public static final Sink appendingSink(@NotNull File $this$appendingSink) throws FileNotFoundException {
        Intrinsics.checkNotNullParameter($this$appendingSink, "<this>");
        return Okio.sink(new FileOutputStream($this$appendingSink, true));
    }

    @NotNull
    public static final Source source(@NotNull File $this$source) throws FileNotFoundException {
        Intrinsics.checkNotNullParameter($this$source, "<this>");
        return new InputStreamSource(new FileInputStream($this$source), Timeout.NONE);
    }

    @NotNull
    public static final Sink sink(@NotNull java.nio.file.Path $this$sink, OpenOption ... options) throws IOException {
        Intrinsics.checkNotNullParameter($this$sink, "<this>");
        Intrinsics.checkNotNullParameter(options, "options");
        OutputStream outputStream2 = Files.newOutputStream($this$sink, Arrays.copyOf(options, options.length));
        Intrinsics.checkNotNullExpressionValue(outputStream2, "newOutputStream(...)");
        return Okio.sink(outputStream2);
    }

    @NotNull
    public static final Source source(@NotNull java.nio.file.Path $this$source, OpenOption ... options) throws IOException {
        Intrinsics.checkNotNullParameter($this$source, "<this>");
        Intrinsics.checkNotNullParameter(options, "options");
        InputStream inputStream2 = Files.newInputStream($this$source, Arrays.copyOf(options, options.length));
        Intrinsics.checkNotNullExpressionValue(inputStream2, "newInputStream(...)");
        return Okio.source(inputStream2);
    }

    @NotNull
    public static final CipherSink cipherSink(@NotNull Sink $this$cipherSink, @NotNull Cipher cipher) {
        Intrinsics.checkNotNullParameter($this$cipherSink, "<this>");
        Intrinsics.checkNotNullParameter(cipher, "cipher");
        return new CipherSink(Okio.buffer($this$cipherSink), cipher);
    }

    @NotNull
    public static final CipherSource cipherSource(@NotNull Source $this$cipherSource, @NotNull Cipher cipher) {
        Intrinsics.checkNotNullParameter($this$cipherSource, "<this>");
        Intrinsics.checkNotNullParameter(cipher, "cipher");
        return new CipherSource(Okio.buffer($this$cipherSource), cipher);
    }

    @NotNull
    public static final HashingSink hashingSink(@NotNull Sink $this$hashingSink, @NotNull Mac mac) {
        Intrinsics.checkNotNullParameter($this$hashingSink, "<this>");
        Intrinsics.checkNotNullParameter(mac, "mac");
        return new HashingSink($this$hashingSink, mac);
    }

    @NotNull
    public static final HashingSource hashingSource(@NotNull Source $this$hashingSource, @NotNull Mac mac) {
        Intrinsics.checkNotNullParameter($this$hashingSource, "<this>");
        Intrinsics.checkNotNullParameter(mac, "mac");
        return new HashingSource($this$hashingSource, mac);
    }

    @NotNull
    public static final HashingSink hashingSink(@NotNull Sink $this$hashingSink, @NotNull MessageDigest digest) {
        Intrinsics.checkNotNullParameter($this$hashingSink, "<this>");
        Intrinsics.checkNotNullParameter(digest, "digest");
        return new HashingSink($this$hashingSink, digest);
    }

    @NotNull
    public static final HashingSource hashingSource(@NotNull Source $this$hashingSource, @NotNull MessageDigest digest) {
        Intrinsics.checkNotNullParameter($this$hashingSource, "<this>");
        Intrinsics.checkNotNullParameter(digest, "digest");
        return new HashingSource($this$hashingSource, digest);
    }

    @NotNull
    public static final FileSystem openZip(@NotNull FileSystem $this$openZip, @NotNull Path zipPath) throws IOException {
        Intrinsics.checkNotNullParameter($this$openZip, "<this>");
        Intrinsics.checkNotNullParameter(zipPath, "zipPath");
        return ZipFilesKt.openZip$default(zipPath, $this$openZip, null, 4, null);
    }

    @NotNull
    public static final FileSystem asResourceFileSystem(@NotNull ClassLoader $this$asResourceFileSystem) {
        Intrinsics.checkNotNullParameter($this$asResourceFileSystem, "<this>");
        return new ResourceFileSystem($this$asResourceFileSystem, true, null, 4, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isAndroidGetsocknameError(@NotNull AssertionError $this$isAndroidGetsocknameError) {
        Intrinsics.checkNotNullParameter($this$isAndroidGetsocknameError, "<this>");
        if (((Throwable)((Object)$this$isAndroidGetsocknameError)).getCause() == null) return false;
        String string = ((Throwable)((Object)$this$isAndroidGetsocknameError)).getMessage();
        if (string == null) return false;
        boolean bl = StringsKt.contains$default((CharSequence)string, "getsockname failed", false, 2, null);
        if (!bl) return false;
        return true;
    }

    @JvmOverloads
    @NotNull
    public static final Sink sink(@NotNull File $this$sink) throws FileNotFoundException {
        Intrinsics.checkNotNullParameter($this$sink, "<this>");
        return Okio.sink$default($this$sink, false, 1, null);
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }
}

