/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.-SegmentedByteString;
import okio.Buffer;
import okio.Segment;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u0000 $2\u00020\u0001:\u0002$%B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0006\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\u0003J\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\r\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0014\u00a2\u0006\u0004\b\r\u0010\u0007J\u0017\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\bH\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0003J'\u0010\u001c\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0018\u0010 \u001a\u0004\u0018\u00010\u00008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0016\u0010\"\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006&"}, d2={"Lokio/AsyncTimeout;", "Lokio/Timeout;", "<init>", "()V", "Ljava/io/IOException;", "cause", "access$newTimeoutException", "(Ljava/io/IOException;)Ljava/io/IOException;", "", "enter", "", "exit", "()Z", "newTimeoutException", "", "now", "remainingNanos", "(J)J", "Lokio/Sink;", "sink", "(Lokio/Sink;)Lokio/Sink;", "Lokio/Source;", "source", "(Lokio/Source;)Lokio/Source;", "timedOut", "T", "Lkotlin/Function0;", "block", "withTimeout", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "inQueue", "Z", "next", "Lokio/AsyncTimeout;", "timeoutAt", "J", "Companion", "Watchdog", "okio"})
public class AsyncTimeout
extends Timeout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean inQueue;
    @Nullable
    private AsyncTimeout next;
    private long timeoutAt;
    @NotNull
    private static final ReentrantLock lock = new ReentrantLock();
    @NotNull
    private static final Condition condition;
    private static final int TIMEOUT_WRITE_SIZE = 65536;
    private static final long IDLE_TIMEOUT_MILLIS;
    private static final long IDLE_TIMEOUT_NANOS;
    @Nullable
    private static AsyncTimeout head;

    public final void enter() {
        long timeoutNanos = this.timeoutNanos();
        boolean hasDeadline = this.hasDeadline();
        if (timeoutNanos == 0L && !hasDeadline) {
            return;
        }
        AsyncTimeout.Companion.scheduleTimeout(this, timeoutNanos, hasDeadline);
    }

    public final boolean exit() {
        return AsyncTimeout.Companion.cancelScheduledTimeout(this);
    }

    private final long remainingNanos(long now) {
        return this.timeoutAt - now;
    }

    protected void timedOut() {
    }

    @NotNull
    public final Sink sink(@NotNull Sink sink2) {
        Intrinsics.checkNotNullParameter(sink2, "sink");
        return new Sink(this, sink2){
            final /* synthetic */ AsyncTimeout this$0;
            final /* synthetic */ Sink $sink;
            {
                this.this$0 = $receiver;
                this.$sink = $sink;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void write(@NotNull Buffer source2, long byteCount) {
                long toWrite;
                Intrinsics.checkNotNullParameter(source2, "source");
                -SegmentedByteString.checkOffsetAndCount(source2.size(), 0L, byteCount);
                for (long remaining = byteCount; remaining > 0L; remaining -= toWrite) {
                    void this_$iv;
                    toWrite = 0L;
                    Intrinsics.checkNotNull(source2.head);
                    while (toWrite < 65536L) {
                        Segment s;
                        int segmentSize = s.limit - s.pos;
                        if ((toWrite += (long)segmentSize) >= remaining) {
                            toWrite = remaining;
                            break;
                        }
                        Intrinsics.checkNotNull(s.next);
                    }
                    AsyncTimeout segmentSize = this.this$0;
                    Sink sink2 = this.$sink;
                    boolean $i$f$withTimeout = false;
                    boolean throwOnTimeout$iv = false;
                    this_$iv.enter();
                    try {
                        boolean bl = false;
                        sink2.write(source2, toWrite);
                        Unit result$iv = Unit.INSTANCE;
                        throwOnTimeout$iv = true;
                        Unit unit = result$iv;
                        boolean timedOut$iv = this_$iv.exit();
                        if (!timedOut$iv) continue;
                    }
                    catch (IOException e$iv) {
                        try {
                            throw !this_$iv.exit() ? (Throwable)e$iv : (Throwable)this_$iv.access$newTimeoutException(e$iv);
                        }
                        catch (Throwable throwable) {
                            boolean timedOut$iv = this_$iv.exit();
                            if (timedOut$iv && throwOnTimeout$iv) {
                                throw this_$iv.access$newTimeoutException(null);
                            }
                            throw throwable;
                        }
                    }
                    throw this_$iv.access$newTimeoutException(null);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void flush() {
                void this_$iv;
                AsyncTimeout asyncTimeout = this.this$0;
                Sink sink2 = this.$sink;
                boolean $i$f$withTimeout = false;
                boolean throwOnTimeout$iv = false;
                this_$iv.enter();
                try {
                    boolean bl = false;
                    sink2.flush();
                    Unit result$iv = Unit.INSTANCE;
                    throwOnTimeout$iv = true;
                    Unit unit = result$iv;
                    boolean timedOut$iv = this_$iv.exit();
                    if (!timedOut$iv) return;
                }
                catch (IOException e$iv) {
                    try {
                        throw !this_$iv.exit() ? (Throwable)e$iv : (Throwable)this_$iv.access$newTimeoutException(e$iv);
                    }
                    catch (Throwable throwable) {
                        boolean timedOut$iv = this_$iv.exit();
                        if (!timedOut$iv || !throwOnTimeout$iv) throw throwable;
                        throw this_$iv.access$newTimeoutException(null);
                    }
                }
                throw this_$iv.access$newTimeoutException(null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void close() {
                void this_$iv;
                AsyncTimeout asyncTimeout = this.this$0;
                Sink sink2 = this.$sink;
                boolean $i$f$withTimeout = false;
                boolean throwOnTimeout$iv = false;
                this_$iv.enter();
                try {
                    boolean bl = false;
                    sink2.close();
                    Unit result$iv = Unit.INSTANCE;
                    throwOnTimeout$iv = true;
                    Unit unit = result$iv;
                    boolean timedOut$iv = this_$iv.exit();
                    if (!timedOut$iv) return;
                }
                catch (IOException e$iv) {
                    try {
                        throw !this_$iv.exit() ? (Throwable)e$iv : (Throwable)this_$iv.access$newTimeoutException(e$iv);
                    }
                    catch (Throwable throwable) {
                        boolean timedOut$iv = this_$iv.exit();
                        if (!timedOut$iv || !throwOnTimeout$iv) throw throwable;
                        throw this_$iv.access$newTimeoutException(null);
                    }
                }
                throw this_$iv.access$newTimeoutException(null);
            }

            @NotNull
            public AsyncTimeout timeout() {
                return this.this$0;
            }

            @NotNull
            public String toString() {
                return "AsyncTimeout.sink(" + this.$sink + ')';
            }
        };
    }

    @NotNull
    public final Source source(@NotNull Source source2) {
        Intrinsics.checkNotNullParameter(source2, "source");
        return new Source(this, source2){
            final /* synthetic */ AsyncTimeout this$0;
            final /* synthetic */ Source $source;
            {
                this.this$0 = $receiver;
                this.$source = $source;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public long read(@NotNull Buffer sink2, long byteCount) {
                void this_$iv;
                Intrinsics.checkNotNullParameter(sink2, "sink");
                AsyncTimeout asyncTimeout = this.this$0;
                Source source2 = this.$source;
                boolean $i$f$withTimeout = false;
                boolean throwOnTimeout$iv = false;
                this_$iv.enter();
                try {
                    boolean bl = false;
                    long result$iv = source2.read(sink2, byteCount);
                    throwOnTimeout$iv = true;
                    long l = result$iv;
                    boolean timedOut$iv = this_$iv.exit();
                    if (!timedOut$iv) return l;
                }
                catch (IOException e$iv) {
                    try {
                        throw !this_$iv.exit() ? (Throwable)e$iv : (Throwable)this_$iv.access$newTimeoutException(e$iv);
                    }
                    catch (Throwable throwable) {
                        boolean timedOut$iv = this_$iv.exit();
                        if (!timedOut$iv || !throwOnTimeout$iv) throw throwable;
                        throw this_$iv.access$newTimeoutException(null);
                    }
                }
                throw this_$iv.access$newTimeoutException(null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void close() {
                void this_$iv;
                AsyncTimeout asyncTimeout = this.this$0;
                Source source2 = this.$source;
                boolean $i$f$withTimeout = false;
                boolean throwOnTimeout$iv = false;
                this_$iv.enter();
                try {
                    boolean bl = false;
                    source2.close();
                    Unit result$iv = Unit.INSTANCE;
                    throwOnTimeout$iv = true;
                    Unit unit = result$iv;
                    boolean timedOut$iv = this_$iv.exit();
                    if (!timedOut$iv) return;
                }
                catch (IOException e$iv) {
                    try {
                        throw !this_$iv.exit() ? (Throwable)e$iv : (Throwable)this_$iv.access$newTimeoutException(e$iv);
                    }
                    catch (Throwable throwable) {
                        boolean timedOut$iv = this_$iv.exit();
                        if (!timedOut$iv || !throwOnTimeout$iv) throw throwable;
                        throw this_$iv.access$newTimeoutException(null);
                    }
                }
                throw this_$iv.access$newTimeoutException(null);
            }

            @NotNull
            public AsyncTimeout timeout() {
                return this.this$0;
            }

            @NotNull
            public String toString() {
                return "AsyncTimeout.source(" + this.$source + ')';
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withTimeout(@NotNull Function0<? extends T> block) {
        T t;
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$withTimeout = false;
        boolean throwOnTimeout = false;
        this.enter();
        try {
            T result = block.invoke();
            throwOnTimeout = true;
            t = result;
        }
        catch (IOException e) {
            try {
                throw !this.exit() ? (Throwable)e : (Throwable)this.access$newTimeoutException(e);
            }
            catch (Throwable throwable) {
                InlineMarker.finallyStart(1);
                boolean timedOut = this.exit();
                if (timedOut && throwOnTimeout) {
                    throw this.access$newTimeoutException(null);
                }
                InlineMarker.finallyEnd(1);
                throw throwable;
            }
        }
        InlineMarker.finallyStart(1);
        boolean timedOut = this.exit();
        if (timedOut) {
            throw this.access$newTimeoutException(null);
        }
        InlineMarker.finallyEnd(1);
        return t;
    }

    @PublishedApi
    @NotNull
    public final IOException access$newTimeoutException(@Nullable IOException cause) {
        return this.newTimeoutException(cause);
    }

    @NotNull
    protected IOException newTimeoutException(@Nullable IOException cause) {
        InterruptedIOException e = new InterruptedIOException("timeout");
        if (cause != null) {
            e.initCause(cause);
        }
        return e;
    }

    static {
        Condition condition = lock.newCondition();
        Intrinsics.checkNotNullExpressionValue(condition, "newCondition(...)");
        AsyncTimeout.condition = condition;
        IDLE_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(60L);
        IDLE_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(IDLE_TIMEOUT_MILLIS);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0019\u001a\u00020\u00188\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0017\u0010 \u001a\u00020\u001f8\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lokio/AsyncTimeout$Companion;", "", "<init>", "()V", "Lokio/AsyncTimeout;", "awaitTimeout$okio", "()Lokio/AsyncTimeout;", "awaitTimeout", "node", "", "cancelScheduledTimeout", "(Lokio/AsyncTimeout;)Z", "", "timeoutNanos", "hasDeadline", "", "scheduleTimeout", "(Lokio/AsyncTimeout;JZ)V", "IDLE_TIMEOUT_MILLIS", "J", "IDLE_TIMEOUT_NANOS", "", "TIMEOUT_WRITE_SIZE", "I", "Ljava/util/concurrent/locks/Condition;", "condition", "Ljava/util/concurrent/locks/Condition;", "getCondition", "()Ljava/util/concurrent/locks/Condition;", "head", "Lokio/AsyncTimeout;", "Ljava/util/concurrent/locks/ReentrantLock;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "okio"})
    @SourceDebugExtension(value={"SMAP\nAsyncTimeout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncTimeout.kt\nokio/AsyncTimeout$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,331:1\n1#2:332\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReentrantLock getLock() {
            return lock;
        }

        @NotNull
        public final Condition getCondition() {
            return condition;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void scheduleTimeout(AsyncTimeout node, long timeoutNanos, boolean hasDeadline) {
            Lock lock = Companion.getLock();
            lock.lock();
            try {
                boolean bl = false;
                if (!(!node.inQueue)) {
                    boolean bl2 = false;
                    String string = "Unbalanced enter/exit";
                    throw new IllegalStateException(string.toString());
                }
                node.inQueue = true;
                if (head == null) {
                    head = new AsyncTimeout();
                    new Watchdog().start();
                }
                long now = System.nanoTime();
                if (timeoutNanos != 0L && hasDeadline) {
                    node.timeoutAt = now + Math.min(timeoutNanos, node.deadlineNanoTime() - now);
                } else if (timeoutNanos != 0L) {
                    node.timeoutAt = now + timeoutNanos;
                } else if (hasDeadline) {
                    node.timeoutAt = node.deadlineNanoTime();
                } else {
                    throw new AssertionError();
                }
                long remainingNanos = node.remainingNanos(now);
                AsyncTimeout asyncTimeout = head;
                Intrinsics.checkNotNull(asyncTimeout);
                AsyncTimeout prev = asyncTimeout;
                while (true) {
                    block17: {
                        block16: {
                            if (prev.next == null) break block16;
                            AsyncTimeout asyncTimeout2 = prev.next;
                            Intrinsics.checkNotNull(asyncTimeout2);
                            if (remainingNanos >= asyncTimeout2.remainingNanos(now)) break block17;
                        }
                        node.next = prev.next;
                        prev.next = node;
                        if (prev != head) break;
                        Companion.getCondition().signal();
                        break;
                    }
                    Intrinsics.checkNotNull(prev.next);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean cancelScheduledTimeout(AsyncTimeout node) {
            Lock lock = Companion.getLock();
            lock.lock();
            try {
                boolean bl = false;
                if (!node.inQueue) {
                    boolean bl2 = false;
                    return bl2;
                }
                node.inQueue = false;
                AsyncTimeout prev = head;
                while (prev != null) {
                    if (prev.next == node) {
                        prev.next = node.next;
                        node.next = null;
                        boolean bl3 = false;
                        return bl3;
                    }
                    prev = prev.next;
                }
                boolean bl4 = true;
                return bl4;
            }
            finally {
                lock.unlock();
            }
        }

        @Nullable
        public final AsyncTimeout awaitTimeout$okio() throws InterruptedException {
            AsyncTimeout asyncTimeout = head;
            Intrinsics.checkNotNull(asyncTimeout);
            AsyncTimeout node = asyncTimeout.next;
            if (node == null) {
                long startNanos = System.nanoTime();
                this.getCondition().await(IDLE_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
                AsyncTimeout asyncTimeout2 = head;
                Intrinsics.checkNotNull(asyncTimeout2);
                return asyncTimeout2.next == null && System.nanoTime() - startNanos >= IDLE_TIMEOUT_NANOS ? head : null;
            }
            long waitNanos = node.remainingNanos(System.nanoTime());
            if (waitNanos > 0L) {
                this.getCondition().await(waitNanos, TimeUnit.NANOSECONDS);
                return null;
            }
            AsyncTimeout asyncTimeout3 = head;
            Intrinsics.checkNotNull(asyncTimeout3);
            asyncTimeout3.next = node.next;
            node.next = null;
            return node;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lokio/AsyncTimeout$Watchdog;", "Ljava/lang/Thread;", "<init>", "()V", "", "run", "okio"})
    private static final class Watchdog
    extends Thread {
        public Watchdog() {
            super("Okio Watchdog");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    AsyncTimeout timedOut = null;
                    Lock lock = Companion.getLock();
                    lock.lock();
                    try {
                        boolean bl = false;
                        timedOut = Companion.awaitTimeout$okio();
                        if (timedOut == head) {
                            head = null;
                            return;
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        lock.unlock();
                    }
                    AsyncTimeout asyncTimeout = timedOut;
                    if (asyncTimeout != null) {
                        asyncTimeout.timedOut();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

