/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Hpack;
import okhttp3.internal.http2.Http2;
import okhttp3.internal.http2.Settings;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 L2\u00020\u0001:\u0001LB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\n\u00a2\u0006\u0004\b\u000f\u0010\u000eJ/\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0016\u0010\u0017J/\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u001c\u001a\u00020\n\u00a2\u0006\u0004\b\u001c\u0010\u000eJ-\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001f\u0010 J%\u0010&\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\"2\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b&\u0010'J+\u0010+\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00112\f\u0010*\u001a\b\u0012\u0004\u0012\u00020)0(\u00a2\u0006\u0004\b+\u0010,J\r\u0010-\u001a\u00020\u0011\u00a2\u0006\u0004\b-\u0010.J%\u00102\u001a\u00020\n2\u0006\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u00112\u0006\u00101\u001a\u00020\u0011\u00a2\u0006\u0004\b2\u00103J+\u00106\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u00104\u001a\u00020\u00112\f\u00105\u001a\b\u0012\u0004\u0012\u00020)0(\u00a2\u0006\u0004\b6\u00107J\u001d\u00108\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b8\u00109J\u0015\u0010:\u001a\u00020\n2\u0006\u0010:\u001a\u00020\b\u00a2\u0006\u0004\b:\u0010\fJ\u001d\u0010=\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010<\u001a\u00020;\u00a2\u0006\u0004\b=\u0010>J\u001f\u0010?\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020;H\u0002\u00a2\u0006\u0004\b?\u0010>R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010@R\u0016\u0010A\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bA\u0010@R\u0014\u0010B\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u0017\u0010E\u001a\u00020D8\u0006\u00a2\u0006\f\n\u0004\bE\u0010F\u001a\u0004\bG\u0010HR\u0016\u0010I\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bI\u0010JR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010K\u00a8\u0006M"}, d2={"Lokhttp3/internal/http2/Http2Writer;", "Ljava/io/Closeable;", "Lokio/BufferedSink;", "sink", "", "client", "<init>", "(Lokio/BufferedSink;Z)V", "Lokhttp3/internal/http2/Settings;", "peerSettings", "", "applyAndAckSettings", "(Lokhttp3/internal/http2/Settings;)V", "close", "()V", "connectionPreface", "outFinished", "", "streamId", "Lokio/Buffer;", "source", "byteCount", "data", "(ZILokio/Buffer;I)V", "flags", "buffer", "dataFrame", "(IILokio/Buffer;I)V", "flush", "length", "type", "frameHeader", "(IIII)V", "lastGoodStreamId", "Lokhttp3/internal/http2/ErrorCode;", "errorCode", "", "debugData", "goAway", "(ILokhttp3/internal/http2/ErrorCode;[B)V", "", "Lokhttp3/internal/http2/Header;", "headerBlock", "headers", "(ZILjava/util/List;)V", "maxDataLength", "()I", "ack", "payload1", "payload2", "ping", "(ZII)V", "promisedStreamId", "requestHeaders", "pushPromise", "(IILjava/util/List;)V", "rstStream", "(ILokhttp3/internal/http2/ErrorCode;)V", "settings", "", "windowSizeIncrement", "windowUpdate", "(IJ)V", "writeContinuationFrames", "Z", "closed", "hpackBuffer", "Lokio/Buffer;", "Lokhttp3/internal/http2/Hpack$Writer;", "hpackWriter", "Lokhttp3/internal/http2/Hpack$Writer;", "getHpackWriter", "()Lokhttp3/internal/http2/Hpack$Writer;", "maxFrameSize", "I", "Lokio/BufferedSink;", "Companion", "okhttp"})
@SourceDebugExtension(value={"SMAP\nHttp2Writer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Writer.kt\nokhttp3/internal/http2/Http2Writer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,317:1\n1#2:318\n*E\n"})
public final class Http2Writer
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferedSink sink;
    private final boolean client;
    @NotNull
    private final Buffer hpackBuffer;
    private int maxFrameSize;
    private boolean closed;
    @NotNull
    private final Hpack.Writer hpackWriter;
    private static final Logger logger = Logger.getLogger(Http2.class.getName());

    public Http2Writer(@NotNull BufferedSink sink2, boolean client) {
        Intrinsics.checkNotNullParameter(sink2, "sink");
        this.sink = sink2;
        this.client = client;
        this.hpackBuffer = new Buffer();
        this.maxFrameSize = 16384;
        this.hpackWriter = new Hpack.Writer(0, false, this.hpackBuffer, 3, null);
    }

    @NotNull
    public final Hpack.Writer getHpackWriter() {
        return this.hpackWriter;
    }

    public final synchronized void connectionPreface() throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (!this.client) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Util.format(">> CONNECTION " + Http2.CONNECTION_PREFACE.hex(), new Object[0]));
        }
        this.sink.write(Http2.CONNECTION_PREFACE);
        this.sink.flush();
    }

    public final synchronized void applyAndAckSettings(@NotNull Settings peerSettings) throws IOException {
        Intrinsics.checkNotNullParameter(peerSettings, "peerSettings");
        if (this.closed) {
            throw new IOException("closed");
        }
        this.maxFrameSize = peerSettings.getMaxFrameSize(this.maxFrameSize);
        if (peerSettings.getHeaderTableSize() != -1) {
            this.hpackWriter.resizeHeaderTable(peerSettings.getHeaderTableSize());
        }
        this.frameHeader(0, 0, 4, 1);
        this.sink.flush();
    }

    public final synchronized void pushPromise(int streamId, int promisedStreamId, @NotNull List<Header> requestHeaders) throws IOException {
        Intrinsics.checkNotNullParameter(requestHeaders, "requestHeaders");
        if (this.closed) {
            throw new IOException("closed");
        }
        this.hpackWriter.writeHeaders(requestHeaders);
        long byteCount = this.hpackBuffer.size();
        int length = (int)Math.min((long)this.maxFrameSize - 4L, byteCount);
        this.frameHeader(streamId, length + 4, 5, byteCount == (long)length ? 4 : 0);
        this.sink.writeInt(promisedStreamId & Integer.MAX_VALUE);
        this.sink.write(this.hpackBuffer, (long)length);
        if (byteCount > (long)length) {
            this.writeContinuationFrames(streamId, byteCount - (long)length);
        }
    }

    public final synchronized void flush() throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.sink.flush();
    }

    public final synchronized void rstStream(int streamId, @NotNull ErrorCode errorCode) throws IOException {
        Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
        if (this.closed) {
            throw new IOException("closed");
        }
        if (!(errorCode.getHttpCode() != -1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.frameHeader(streamId, 4, 3, 0);
        this.sink.writeInt(errorCode.getHttpCode());
        this.sink.flush();
    }

    public final int maxDataLength() {
        return this.maxFrameSize;
    }

    public final synchronized void data(boolean outFinished, int streamId, @Nullable Buffer source2, int byteCount) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        int flags = 0;
        if (outFinished) {
            flags |= 1;
        }
        this.dataFrame(streamId, flags, source2, byteCount);
    }

    public final void dataFrame(int streamId, int flags, @Nullable Buffer buffer, int byteCount) throws IOException {
        this.frameHeader(streamId, byteCount, 0, flags);
        if (byteCount > 0) {
            Buffer buffer2 = buffer;
            Intrinsics.checkNotNull(buffer2);
            this.sink.write(buffer2, (long)byteCount);
        }
    }

    public final synchronized void settings(@NotNull Settings settings) throws IOException {
        Intrinsics.checkNotNullParameter(settings, "settings");
        if (this.closed) {
            throw new IOException("closed");
        }
        this.frameHeader(0, settings.size() * 6, 4, 0);
        for (int i = 0; i < 10; ++i) {
            int n;
            if (!settings.isSet(i)) continue;
            switch (i) {
                case 4: {
                    n = 3;
                    break;
                }
                case 7: {
                    n = 4;
                    break;
                }
                default: {
                    n = i;
                }
            }
            int id = n;
            this.sink.writeShort(id);
            this.sink.writeInt(settings.get(i));
        }
        this.sink.flush();
    }

    public final synchronized void ping(boolean ack, int payload1, int payload2) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.frameHeader(0, 8, 6, ack ? 1 : 0);
        this.sink.writeInt(payload1);
        this.sink.writeInt(payload2);
        this.sink.flush();
    }

    public final synchronized void goAway(int lastGoodStreamId, @NotNull ErrorCode errorCode, @NotNull byte[] debugData) throws IOException {
        Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
        Intrinsics.checkNotNullParameter(debugData, "debugData");
        if (this.closed) {
            throw new IOException("closed");
        }
        if (!(errorCode.getHttpCode() != -1)) {
            boolean bl = false;
            String string = "errorCode.httpCode == -1";
            throw new IllegalArgumentException(string.toString());
        }
        this.frameHeader(0, 8 + debugData.length, 7, 0);
        this.sink.writeInt(lastGoodStreamId);
        this.sink.writeInt(errorCode.getHttpCode());
        if (!(debugData.length == 0)) {
            this.sink.write(debugData);
        }
        this.sink.flush();
    }

    public final synchronized void windowUpdate(int streamId, long windowSizeIncrement) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (!(windowSizeIncrement != 0L && windowSizeIncrement <= Integer.MAX_VALUE)) {
            boolean bl = false;
            String string = "windowSizeIncrement == 0 || windowSizeIncrement > 0x7fffffffL: " + windowSizeIncrement;
            throw new IllegalArgumentException(string.toString());
        }
        this.frameHeader(streamId, 4, 8, 0);
        this.sink.writeInt((int)windowSizeIncrement);
        this.sink.flush();
    }

    public final void frameHeader(int streamId, int length, int type, int flags) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Http2.INSTANCE.frameLog(false, streamId, length, type, flags));
        }
        if (!(length <= this.maxFrameSize)) {
            boolean $i$a$-require-Http2Writer$frameHeader$32 = false;
            String $i$a$-require-Http2Writer$frameHeader$32 = "FRAME_SIZE_ERROR length > " + this.maxFrameSize + ": " + length;
            throw new IllegalArgumentException($i$a$-require-Http2Writer$frameHeader$32.toString());
        }
        if (!((streamId & Integer.MIN_VALUE) == 0)) {
            boolean bl = false;
            String string = "reserved bit set: " + streamId;
            throw new IllegalArgumentException(string.toString());
        }
        Util.writeMedium(this.sink, length);
        this.sink.writeByte(type & 0xFF);
        this.sink.writeByte(flags & 0xFF);
        this.sink.writeInt(streamId & Integer.MAX_VALUE);
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        this.sink.close();
    }

    private final void writeContinuationFrames(int streamId, long byteCount) throws IOException {
        long byteCount2 = byteCount;
        while (byteCount2 > 0L) {
            long length = Math.min((long)this.maxFrameSize, byteCount2);
            this.frameHeader(streamId, (int)length, 9, (byteCount2 -= length) == 0L ? 4 : 0);
            this.sink.write(this.hpackBuffer, length);
        }
    }

    public final synchronized void headers(boolean outFinished, int streamId, @NotNull List<Header> headerBlock) throws IOException {
        int flags;
        Intrinsics.checkNotNullParameter(headerBlock, "headerBlock");
        if (this.closed) {
            throw new IOException("closed");
        }
        this.hpackWriter.writeHeaders(headerBlock);
        long byteCount = this.hpackBuffer.size();
        long length = Math.min((long)this.maxFrameSize, byteCount);
        int n = flags = byteCount == length ? 4 : 0;
        if (outFinished) {
            flags |= 1;
        }
        this.frameHeader(streamId, (int)length, 1, flags);
        this.sink.write(this.hpackBuffer, length);
        if (byteCount > length) {
            this.writeContinuationFrames(streamId, byteCount - length);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lokhttp3/internal/http2/Http2Writer$Companion;", "", "<init>", "()V", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "logger", "Ljava/util/logging/Logger;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

