/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.world.data.save;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.bit.BitBuffer;
import abeshutt.staracademy.data.serializable.ISerializable;
import abeshutt.staracademy.init.ModWorldData;
import abeshutt.staracademy.net.UpdateOutfitS2CPacket;
import abeshutt.staracademy.world.data.save.WorldData;
import com.google.gson.JsonObject;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.networking.NetworkManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class WardrobeData
extends WorldData {
    public static final WardrobeData CLIENT = new WardrobeData();
    private final Map<UUID, Entry> entries = new HashMap<UUID, Entry>();

    public Map<UUID, Entry> getEntries() {
        return this.entries;
    }

    public Optional<Entry> get(UUID uuid) {
        return Optional.ofNullable(this.entries.get(uuid));
    }

    public Entry getOrCreate(UUID uuid) {
        return this.entries.computeIfAbsent(uuid, key -> new Entry());
    }

    public boolean isUnlocked(UUID uuid, String id) {
        return this.get(uuid).map(entry -> entry.getUnlocked().contains(id)).orElse(false);
    }

    public boolean isEquipped(UUID uuid, String id) {
        return this.get(uuid).map(entry -> entry.getEquipped().contains(id)).orElse(false);
    }

    public boolean setUnlocked(class_3222 player, String id, boolean unlocked) {
        if (this.setUnlocked(player.method_5667(), id, unlocked)) {
            if (player.method_5682() != null) {
                for (class_3222 other : player.method_5682().method_3760().method_14571()) {
                    other.method_43496((class_2561)class_2561.method_43473().method_10852(player.method_5477()).method_10852((class_2561)class_2561.method_43470((String)" unlocked a new outfit: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43471((String)("item.academy.outfit." + id))).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
                }
            }
            return true;
        }
        return false;
    }

    public boolean setUnlocked(UUID uuid, String id, boolean unlocked) {
        Entry entry = this.getOrCreate(uuid);
        if (unlocked && entry.getUnlocked().add(id) || !unlocked && entry.getUnlocked().remove(id)) {
            entry.setDirty(true);
            this.method_78(true);
            return true;
        }
        return false;
    }

    public boolean setEquipped(UUID uuid, String id, boolean equipped) {
        Entry entry = this.getOrCreate(uuid);
        if (equipped && !entry.getUnlocked().contains(id)) {
            return false;
        }
        if (equipped && entry.getEquipped().add(id) || !equipped && entry.getEquipped().remove(id)) {
            entry.setDirty(true);
            this.method_78(true);
            return true;
        }
        return false;
    }

    private void onJoin(class_3222 player) {
        NetworkManager.sendToPlayer((class_3222)player, (class_8710)new UpdateOutfitS2CPacket(player.method_5667(), this.getOrCreate(player.method_5667())));
    }

    public void onTick(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            this.get(player.method_5667()).ifPresent(entry -> entry.getEquipped().removeIf(s -> {
                if (!entry.getUnlocked().contains(s)) {
                    entry.setDirty(true);
                    this.method_78(true);
                    return true;
                }
                return false;
            }));
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            this.get(player.method_5667()).ifPresent(entry -> {
                if (!entry.isDirty()) {
                    return;
                }
                NetworkManager.sendToPlayers((Iterable)server.method_3760().method_14571(), (class_8710)new UpdateOutfitS2CPacket(player.method_5667(), (Entry)entry));
                entry.setDirty(false);
            });
        }
    }

    @Override
    public Optional<class_2487> writeNbt() {
        return Optional.of(new class_2487()).map(nbt -> {
            class_2487 entries = new class_2487();
            this.entries.forEach((uuid, entry) -> entry.writeNbt().ifPresent(tag -> entries.method_10566(uuid.toString(), (class_2520)tag)));
            nbt.method_10566("entries", (class_2520)entries);
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.entries.clear();
        class_2487 entries = nbt.method_10562("entries");
        for (String key : entries.method_10541()) {
            Entry entry = new Entry();
            entry.readNbt(entries.method_10562(key));
            this.entries.put(UUID.fromString(key), entry);
        }
    }

    public static void init() {
        PlayerEvent.PLAYER_JOIN.register(player -> {
            WardrobeData data = ModWorldData.WARDROBE.getGlobal(player.method_37908());
            data.onJoin(player);
        });
        TickEvent.SERVER_POST.register(server -> {
            WardrobeData data = ModWorldData.WARDROBE.getGlobal((MinecraftServer)server);
            data.onTick((MinecraftServer)server);
        });
    }

    public static class Entry
    implements ISerializable<class_2487, JsonObject> {
        private final Set<String> unlocked = new HashSet<String>();
        private final Set<String> equipped = new HashSet<String>();
        private boolean dirty;

        public Set<String> getUnlocked() {
            return this.unlocked;
        }

        public Set<String> getEquipped() {
            return this.equipped;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.INT_SEGMENTED_7.writeBits(this.unlocked.size(), buffer);
            for (String id : this.unlocked) {
                Adapters.UTF_8.writeBits(id, buffer);
            }
            Adapters.INT_SEGMENTED_7.writeBits(this.equipped.size(), buffer);
            for (String id : this.equipped) {
                Adapters.UTF_8.writeBits(id, buffer);
            }
        }

        @Override
        public void readBits(BitBuffer buffer) {
            int i;
            this.unlocked.clear();
            int size = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
            for (i = 0; i < size; ++i) {
                Adapters.UTF_8.readBits(buffer).ifPresent(this.unlocked::add);
            }
            this.equipped.clear();
            size = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
            for (i = 0; i < size; ++i) {
                Adapters.UTF_8.readBits(buffer).ifPresent(this.equipped::add);
            }
        }

        @Override
        public Optional<class_2487> writeNbt() {
            return Optional.of(new class_2487()).map(nbt -> {
                class_2499 unlocked = new class_2499();
                for (String id : this.unlocked) {
                    Adapters.UTF_8.writeNbt(id).ifPresent(arg_0 -> unlocked.add(arg_0));
                }
                nbt.method_10566("unlocked", (class_2520)unlocked);
                class_2499 equipped = new class_2499();
                for (String id : this.equipped) {
                    Adapters.UTF_8.writeNbt(id).ifPresent(arg_0 -> equipped.add(arg_0));
                }
                nbt.method_10566("equipped", (class_2520)equipped);
                return nbt;
            });
        }

        @Override
        public void readNbt(class_2487 nbt) {
            this.unlocked.clear();
            Object object = nbt.method_10580("unlocked");
            if (object instanceof class_2499) {
                class_2499 unlocked = (class_2499)object;
                for (class_2520 element : unlocked) {
                    Adapters.UTF_8.readNbt(element).ifPresent(this.unlocked::add);
                }
            }
            this.equipped.clear();
            object = nbt.method_10580("equipped");
            if (object instanceof class_2499) {
                class_2499 equipped = (class_2499)object;
                for (class_2520 element : equipped) {
                    Adapters.UTF_8.readNbt(element).ifPresent(this.equipped::add);
                }
            }
        }
    }
}

