/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.world.data.save;

import abeshutt.staracademy.StarAcademyMod;
import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.serializable.ISerializable;
import abeshutt.staracademy.init.ModConfigs;
import abeshutt.staracademy.init.ModWorldData;
import abeshutt.staracademy.net.WorldKeysUpdateS2CPacket;
import abeshutt.staracademy.world.VirtualWorld;
import abeshutt.staracademy.world.data.save.WorldData;
import com.google.gson.JsonObject;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.networking.NetworkManager;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class VirtualWorldData
extends WorldData {
    private final Map<class_2960, Entry> entries = new LinkedHashMap<class_2960, Entry>();

    public VirtualWorld instantiate(MinecraftServer server, class_2960 id, Set<String> tags) {
        if (tags.contains("island")) {
            return VirtualWorld.create(server, id, (class_5363)server.method_46221().method_45926().method_30530(class_7924.field_41224).method_29107(class_5321.method_29179((class_5321)class_7924.field_41224, (class_2960)StarAcademyMod.id("island"))));
        }
        throw new UnsupportedOperationException();
    }

    public boolean has(class_2960 id) {
        return this.entries.containsKey(id);
    }

    public Optional<VirtualWorld> get(MinecraftServer server, class_2960 id) {
        Entry entry = this.entries.get(id);
        if (entry != null) {
            if (entry.getWorld() != null) {
                return Optional.of(entry.getWorld());
            }
            VirtualWorld world = this.instantiate(server, id, entry.getTags());
            entry.setWorld(world);
            this.load(world);
            return Optional.of(world);
        }
        return Optional.empty();
    }

    public void add(class_2960 id, String ... tags) {
        Entry entry = this.entries.get(id);
        if (entry != null && entry.getWorld() != null) {
            this.unload(entry.getWorld());
        }
        this.entries.put(id, new Entry(false, tags));
        this.method_80();
    }

    public void remove(class_2960 id) {
        Entry entry = this.entries.remove(id);
        if (entry != null && entry.getWorld() != null) {
            this.unload(entry.getWorld());
        }
        if (entry != null) {
            this.method_80();
        }
    }

    public void load(VirtualWorld world) {
        world.method_8503().field_4589.put(world.method_27983(), world);
        ((LifecycleEvent.ServerLevelState)LifecycleEvent.SERVER_LEVEL_LOAD.invoker()).act((class_1937)world);
        for (class_3222 player : world.method_8503().method_3760().method_14571()) {
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new WorldKeysUpdateS2CPacket(Set.of(world.getId()), Set.of()));
        }
    }

    public void unload(VirtualWorld world) {
        world.method_8503().field_4589.remove(world.method_27983());
        ((LifecycleEvent.ServerLevelState)LifecycleEvent.SERVER_LEVEL_UNLOAD.invoker()).act((class_1937)world);
        for (class_3222 player : world.method_8503().method_3760().method_14571()) {
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new WorldKeysUpdateS2CPacket(Set.of(), Set.of(world.getId())));
        }
    }

    public void onTick(MinecraftServer server) {
        if (ModConfigs.ISLAND.isEnabled()) {
            for (class_3222 player : server.method_3760().method_14571()) {
                class_2960 id2 = VirtualWorld.island((class_1657)player);
                if (this.has(id2)) continue;
                this.add(id2, "island");
            }
        }
        this.entries.forEach((id, entry) -> this.get(server, (class_2960)id));
    }

    @Override
    public Optional<class_2487> writeNbt() {
        return Optional.of(new class_2487()).map(nbt -> {
            class_2487 entries = new class_2487();
            this.entries.forEach((id, entry) -> entry.writeNbt().ifPresent(compound -> entries.method_10566(id.toString(), (class_2520)compound)));
            nbt.method_10566("entries", (class_2520)entries);
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.entries.clear();
        class_2520 class_25202 = nbt.method_10580("entries");
        if (class_25202 instanceof class_2487) {
            class_2487 entries = (class_2487)class_25202;
            for (String key : entries.method_10541()) {
                Entry entry = new Entry();
                entry.readNbt(entries.method_10562(key));
                this.entries.put(class_2960.method_60654((String)key), entry);
            }
        }
    }

    public static void init() {
        TickEvent.SERVER_POST.register(server -> {
            VirtualWorldData data = ModWorldData.VIRTUAL_WORLD.getGlobal((MinecraftServer)server);
            data.onTick((MinecraftServer)server);
        });
    }

    public static class Entry
    implements ISerializable<class_2487, JsonObject> {
        private VirtualWorld world;
        private boolean deleted;
        private final Set<String> tags;

        public Entry() {
            this.tags = new LinkedHashSet<String>();
        }

        public Entry(boolean deleted, String ... tags) {
            this.deleted = deleted;
            this.tags = new LinkedHashSet<String>();
            this.tags.addAll(Arrays.asList(tags));
        }

        public VirtualWorld getWorld() {
            return this.world;
        }

        public Entry setWorld(VirtualWorld world) {
            this.world = world;
            return this;
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public Set<String> getTags() {
            return this.tags;
        }

        @Override
        public Optional<class_2487> writeNbt() {
            return Optional.of(new class_2487()).map(nbt -> {
                Adapters.BOOLEAN.writeNbt(this.deleted).ifPresent(tag -> nbt.method_10566("deleted", tag));
                class_2499 tags = new class_2499();
                for (String tag2 : this.tags) {
                    Adapters.UTF_8.writeNbt(tag2).ifPresent(arg_0 -> tags.add(arg_0));
                }
                nbt.method_10566("tags", (class_2520)tags);
                return nbt;
            });
        }

        @Override
        public void readNbt(class_2487 nbt) {
            this.deleted = Adapters.BOOLEAN.readNbt(nbt.method_10580("deleted")).orElseThrow();
            this.tags.clear();
            class_2520 class_25202 = nbt.method_10580("tags");
            if (class_25202 instanceof class_2499) {
                class_2499 tags = (class_2499)class_25202;
                for (class_2520 tag : tags) {
                    Adapters.UTF_8.readNbt(tag).ifPresent(this.tags::add);
                }
            }
        }
    }
}

