/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.world.data.save;

import abeshutt.staracademy.config.StarterKitConfig;
import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.bit.BitBuffer;
import abeshutt.staracademy.data.serializable.ISerializable;
import abeshutt.staracademy.init.ModConfigs;
import abeshutt.staracademy.init.ModWorldData;
import abeshutt.staracademy.world.data.save.WorldData;
import com.google.gson.JsonObject;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.hooks.item.ItemStackHooks;
import java.lang.invoke.LambdaMetafactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;

public class StarterKitData
extends WorldData {
    private final Map<UUID, Entry> entries = new LinkedHashMap<UUID, Entry>();

    public boolean isGranted(UUID uuid) {
        Entry entry = this.entries.get(uuid);
        if (entry == null) {
            return false;
        }
        return entry.isGranted();
    }

    public void setGranted(UUID uuid, boolean granted) {
        this.entries.computeIfAbsent((UUID)uuid, (Function<UUID, Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$setGranted$0(java.util.UUID ), (Ljava/util/UUID;)Labeshutt/staracademy/world/data/save/StarterKitData$Entry;)()).granted = granted;
        this.method_80();
    }

    private void onJoin(class_3222 player) {
        if (!this.isGranted(player.method_5667())) {
            ModConfigs.STARTER_KIT.getEquipment().forEach((slot, stack) -> {
                if (player.method_6118(slot).method_7960()) {
                    player.method_5673(slot, stack.method_7972());
                } else {
                    ItemStackHooks.giveItem((class_3222)player, (class_1799)stack.method_7972());
                }
                this.setGranted(player.method_5667(), true);
            });
        }
    }

    @Override
    public Optional<class_2487> writeNbt() {
        return Optional.of(new class_2487()).map(nbt -> {
            class_2487 entries = new class_2487();
            this.entries.forEach((uuid, entry) -> entry.writeNbt().ifPresent(tag -> entries.method_10566(uuid.toString(), (class_2520)tag)));
            nbt.method_10566("entries", (class_2520)entries);
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.entries.clear();
        class_2487 entries = nbt.method_10562("entries");
        for (String key : entries.method_10541()) {
            Entry entry = new Entry();
            entry.readNbt(entries.method_10562(key));
            this.entries.put(UUID.fromString(key), entry);
        }
    }

    public static void init() {
        PlayerEvent.PLAYER_JOIN.register(player -> {
            StarterKitData data = ModWorldData.STARTER_KIT.getGlobal(player.method_37908());
            data.onJoin(player);
        });
        LifecycleEvent.SERVER_BEFORE_START.register(server -> {
            ModConfigs.STARTER_KIT = (StarterKitConfig)new StarterKitConfig().read();
        });
    }

    private static /* synthetic */ Entry lambda$setGranted$0(UUID k) {
        return new Entry();
    }

    public static class Entry
    implements ISerializable<class_2487, JsonObject> {
        private boolean granted;

        public boolean isGranted() {
            return this.granted;
        }

        public void setGranted(boolean granted) {
            this.granted = granted;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.BOOLEAN.writeBits(this.granted, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            this.granted = Adapters.BOOLEAN.readBits(buffer).orElseThrow();
        }

        @Override
        public Optional<class_2487> writeNbt() {
            return Optional.of(new class_2487()).map(nbt -> {
                Adapters.BOOLEAN.writeNbt(this.granted).ifPresent(tag -> nbt.method_10566("granted", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(class_2487 nbt) {
            this.granted = Adapters.BOOLEAN.readNbt(nbt.method_10580("granted")).orElseThrow();
        }
    }
}

