/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.world.data.save;

import abeshutt.staracademy.StarAcademyMod;
import abeshutt.staracademy.block.entity.SafariPortalBlockEntity;
import abeshutt.staracademy.config.SafariConfig;
import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.bit.BitBuffer;
import abeshutt.staracademy.data.serializable.ISerializable;
import abeshutt.staracademy.init.ModBlocks;
import abeshutt.staracademy.init.ModConfigs;
import abeshutt.staracademy.init.ModWorldData;
import abeshutt.staracademy.net.UpdateSafariConfigS2CPacket;
import abeshutt.staracademy.net.UpdateSafariS2CPacket;
import abeshutt.staracademy.world.data.EntityState;
import abeshutt.staracademy.world.data.save.WorldData;
import abeshutt.staracademy.world.generator.DummyWorldGenerationProgressListener;
import com.cobblemon.mod.common.CobblemonItems;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.networking.NetworkManager;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_27;
import net.minecraft.class_2780;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3949;
import net.minecraft.class_4543;
import net.minecraft.class_5268;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9797;
import net.minecraft.server.MinecraftServer;

public class SafariData
extends WorldData {
    public static final SafariData CLIENT = new SafariData(false);
    private long timeLeft;
    private boolean paused;
    private long lastUpdated;
    private final Map<class_5321<class_1937>, Set<class_2338>> portals;
    private final Map<UUID, Entry> entries;
    private SafariConfig lastConfig;

    private SafariData(boolean paused) {
        this.paused = paused;
        this.portals = new HashMap<class_5321<class_1937>, Set<class_2338>>();
        this.entries = new HashMap<UUID, Entry>();
    }

    public SafariData() {
        this(ModConfigs.SAFARI.isPaused());
    }

    public long getTimeLeft() {
        return this.timeLeft;
    }

    public void setTimeLeft(long timeLeft) {
        this.timeLeft = timeLeft;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean setPaused(boolean paused) {
        boolean changed = this.paused != paused;
        this.paused = paused;
        return changed;
    }

    public Map<UUID, Entry> getEntries() {
        return this.entries;
    }

    public Optional<Entry> get(UUID uuid) {
        return Optional.ofNullable(this.entries.get(uuid));
    }

    public Entry getOrCreate(UUID uuid) {
        return this.entries.computeIfAbsent(uuid, key -> {
            this.method_80();
            Entry entry = new Entry();
            entry.setTimeLeft(ModConfigs.SAFARI.getPlayerDuration());
            return entry;
        });
    }

    public void joinSafari(class_3222 player) {
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return;
        }
        class_3218 destination = server.method_3847(StarAcademyMod.SAFARI);
        if (destination != null) {
            this.getOrCreate(player.method_5667()).setLastState(new EntityState(player));
            player.method_60697((class_9797)ModBlocks.SAFARI_PORTAL.get(), player.method_24515());
        }
    }

    public void leaveSafari(class_3222 player) {
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return;
        }
        player.method_60697((class_9797)ModBlocks.SAFARI_PORTAL.get(), player.method_24515());
    }

    public void addPortal(class_1937 world, class_2338 pos) {
        this.portals.computeIfAbsent((class_5321<class_1937>)world.method_27983(), key -> new HashSet()).add(pos);
    }

    public void onStart(MinecraftServer server) {
        class_3218 world = server.method_3847(StarAcademyMod.SAFARI);
        if (world == null) {
            return;
        }
        for (class_3222 player : new ArrayList(world.method_18456())) {
            this.leaveSafari(player);
        }
        if (ModConfigs.SAFARI.isResetWorld()) {
            final Path folder = world.method_8503().field_23784.method_27424(world.method_27983());
            server.field_4589.remove(StarAcademyMod.SAFARI);
            try {
                Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attributes) throws IOException {
                        StarAcademyMod.LOGGER.debug("Deleting {}", (Object)path);
                        Files.delete(path);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path path, IOException exception) throws IOException {
                        if (exception != null) {
                            throw exception;
                        }
                        if (path.equals(folder)) {
                            Files.deleteIfExists(path);
                        }
                        Files.delete(path);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException player) {
                // empty catch block
            }
            class_27 worldProperties = new class_27(server.method_27728(), server.method_27728().method_27859());
            class_5363 options = (class_5363)server.method_46221().method_45926().method_30530(class_7924.field_41224).method_10223(StarAcademyMod.SAFARI.method_29177());
            class_3218 newWorld = new class_3218(server, (Executor)class_156.method_18349(), server.field_23784, (class_5268)worldProperties, world.method_27983(), options, (class_3949)new DummyWorldGenerationProgressListener(), server.method_27728().method_45556(), class_4543.method_27984((long)server.method_27728().method_28057().method_28028()), (List)ImmutableList.of(), false, server.method_30002().method_52168());
            server.method_30002().method_8621().method_11983((class_2780)new class_2780.class_3976(newWorld.method_8621()));
            server.field_4589.put(world.method_27983(), newWorld);
        }
        this.timeLeft = ModConfigs.SAFARI.getTimeLeft(this.lastUpdated) / 50L;
        ArrayList<UUID> keys2 = new ArrayList<UUID>(this.entries.keySet());
        for (UUID key : keys2) {
            this.entries.compute(key, (k, v) -> {
                this.method_80();
                Entry entry = new Entry();
                entry.setTimeLeft(ModConfigs.SAFARI.getPlayerDuration());
                if (v != null) {
                    entry.setLastState(v.getLastState());
                    entry.setUnlocked(v.isUnlocked());
                    entry.setPrompted(v.isPrompted());
                }
                return entry;
            });
        }
    }

    private void onJoin(class_3222 player) {
        NetworkManager.sendToPlayer((class_3222)player, (class_8710)new UpdateSafariConfigS2CPacket(ModConfigs.SAFARI.getTickets()));
    }

    public void onTick(MinecraftServer server) {
        this.timeLeft = ModConfigs.SAFARI.getTimeLeft(this.lastUpdated) / 50L;
        if (this.timeLeft <= 0L) {
            this.lastUpdated = System.currentTimeMillis();
            this.onStart(server);
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            this.getOrCreate(player.method_5667());
            this.get(player.method_5667()).ifPresent(entry -> {
                if (player.method_37908().method_27983() == StarAcademyMod.SAFARI && (entry.getTimeLeft() <= 0L || !entry.isUnlocked() || player.method_23318() < (double)player.method_37908().method_31607())) {
                    player.field_6017 = 0.0f;
                    this.leaveSafari(player);
                }
            });
        }
        this.portals.forEach((key, positions) -> {
            class_3218 world = server.method_3847(key);
            if (world == null) {
                return;
            }
            positions.removeIf(pos -> {
                class_2791 chunk = world.method_8402(pos.method_10263() >> 4, pos.method_10260() >> 4, class_2806.field_12803, false);
                if (chunk == null) {
                    return false;
                }
                return !(world.method_8321(pos) instanceof SafariPortalBlockEntity);
            });
        });
        HashSet dirty = new HashSet();
        this.entries.forEach((uuid, entry) -> {
            class_3222 player = server.method_3760().method_14602(uuid);
            if (player == null) {
                return;
            }
            if (player.method_37908().method_27983() == StarAcademyMod.SAFARI) {
                if (entry.getBallsGiven() < ModConfigs.SAFARI.getProvidedSafariBalls()) {
                    int missing = ModConfigs.SAFARI.getProvidedSafariBalls() - entry.getBallsGiven();
                    class_1799 stack = new class_1799((class_1935)CobblemonItems.SAFARI_BALL, missing);
                    player.method_31548().method_7394(stack);
                    entry.setBallsGiven(entry.getBallsGiven() + (missing - stack.method_7947()));
                    dirty.add(uuid);
                }
                if (entry.getTimeLeft() > 0L) {
                    entry.setTimeLeft(entry.getTimeLeft() - 1L);
                    entry.setTimeLeft(Math.min(entry.getTimeLeft(), this.timeLeft));
                    dirty.add(uuid);
                }
            }
            class_2338 nearestPortal = null;
            double nearestDistance = Double.MAX_VALUE;
            Set positions = this.portals.getOrDefault(player.method_37908().method_27983(), new HashSet());
            for (class_2338 position : positions) {
                double dz;
                double dy;
                double dx = player.method_5836((float)1.0f).field_1352 - (double)position.method_10263() + 0.5;
                double distance = dx * dx + (dy = player.method_5836((float)1.0f).field_1351 - (double)position.method_10264() + 0.5) * dy + (dz = player.method_5836((float)1.0f).field_1350 - (double)position.method_10260() + 0.5) * dz;
                if (!(distance < nearestDistance)) continue;
                nearestPortal = position;
                nearestDistance = distance;
            }
            entry.setNearestPortal(nearestPortal);
            dirty.add(uuid);
        });
        for (class_3222 player : server.method_3760().method_14571()) {
            if (dirty.contains(player.method_5667())) {
                NetworkManager.sendToPlayer((class_3222)player, (class_8710)new UpdateSafariS2CPacket(this.timeLeft, this.paused, player.method_5667(), this.entries.get(player.method_5667())));
                continue;
            }
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new UpdateSafariS2CPacket(this.timeLeft, this.paused, new HashMap<UUID, Entry>()));
        }
        if (this.lastConfig != ModConfigs.SAFARI) {
            NetworkManager.sendToPlayers((Iterable)server.method_3760().method_14571(), (class_8710)new UpdateSafariConfigS2CPacket(ModConfigs.SAFARI.getTickets()));
            this.lastConfig = ModConfigs.SAFARI;
        }
        this.method_80();
    }

    @Override
    public Optional<class_2487> writeNbt() {
        return Optional.of(new class_2487()).map(nbt -> {
            class_2487 portals = new class_2487();
            this.portals.forEach((key, positions) -> {
                class_2499 entry = new class_2499();
                for (class_2338 position : positions) {
                    Adapters.BLOCK_POS.writeNbt(position).ifPresent(arg_0 -> entry.add(arg_0));
                }
                portals.method_10566(key.method_29177().toString(), (class_2520)entry);
            });
            nbt.method_10566("portals", (class_2520)portals);
            class_2487 entries = new class_2487();
            this.entries.forEach((uuid, entry) -> entry.writeNbt().ifPresent(tag -> entries.method_10566(uuid.toString(), (class_2520)tag)));
            nbt.method_10566("entries", (class_2520)entries);
            Adapters.LONG.writeNbt(this.timeLeft).ifPresent(tag -> nbt.method_10566("timeLeft", tag));
            Adapters.LONG.writeNbt(this.lastUpdated).ifPresent(tag -> nbt.method_10566("lastUpdated", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.portals.clear();
        for (String s : nbt.method_10562("portals").method_10541()) {
            class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)s));
            HashSet positions = new HashSet();
            class_2520 class_25202 = nbt.method_10562("portals").method_10580(s);
            if (class_25202 instanceof class_2499) {
                class_2499 entry = (class_2499)class_25202;
                for (class_2520 child : entry) {
                    Adapters.BLOCK_POS.readNbt(child).ifPresent(positions::add);
                }
            }
            this.portals.put((class_5321<class_1937>)key, positions);
        }
        this.entries.clear();
        for (String key : nbt.method_10562("entries").method_10541()) {
            Entry entry = new Entry();
            entry.readNbt(nbt.method_10562("entries").method_10562(key));
            this.entries.put(UUID.fromString(key), entry);
        }
        this.timeLeft = Adapters.LONG.readNbt(nbt.method_10580("timeLeft")).orElse(0L);
        this.lastUpdated = Adapters.LONG.readNbt(nbt.method_10580("lastUpdated")).orElse(0L);
    }

    public static void init() {
        PlayerEvent.PLAYER_JOIN.register(player -> {
            SafariData data = ModWorldData.SAFARI.getGlobal(player.method_37908());
            data.onJoin(player);
        });
        TickEvent.SERVER_POST.register(server -> {
            SafariData data = ModWorldData.SAFARI.getGlobal((MinecraftServer)server);
            data.onTick((MinecraftServer)server);
        });
    }

    public static class Entry
    implements ISerializable<class_2487, JsonObject> {
        private EntityState lastState;
        private long timeLeft;
        private int ballsGiven;
        private class_2338 nearestPortal;
        protected boolean prompted;
        protected boolean unlocked;

        public EntityState getLastState() {
            return this.lastState;
        }

        public void setLastState(EntityState lastState) {
            this.lastState = lastState;
        }

        public long getTimeLeft() {
            return this.timeLeft;
        }

        public void setTimeLeft(long timeLeft) {
            this.timeLeft = timeLeft;
        }

        public int getBallsGiven() {
            return this.ballsGiven;
        }

        public void setBallsGiven(int ballsGiven) {
            this.ballsGiven = ballsGiven;
        }

        public class_2338 getNearestPortal() {
            return this.nearestPortal;
        }

        public void setNearestPortal(class_2338 nearestPortal) {
            this.nearestPortal = nearestPortal;
        }

        public boolean isPrompted() {
            return this.prompted;
        }

        public void setPrompted(boolean prompted) {
            this.prompted = prompted;
        }

        public boolean isUnlocked() {
            return this.unlocked;
        }

        public void setUnlocked(boolean unlocked) {
            this.unlocked = unlocked;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.BOOLEAN.writeBits(this.lastState != null, buffer);
            if (this.lastState != null) {
                this.lastState.writeBits(buffer);
            }
            Adapters.LONG.writeBits(this.timeLeft, buffer);
            Adapters.INT.writeBits(this.ballsGiven, buffer);
            Adapters.BLOCK_POS.asNullable().writeBits(this.nearestPortal, buffer);
            Adapters.BOOLEAN.writeBits(this.unlocked, buffer);
            Adapters.BOOLEAN.writeBits(this.prompted, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            if (Adapters.BOOLEAN.readBits(buffer).orElseThrow().booleanValue()) {
                this.lastState = new EntityState();
                this.lastState.readBits(buffer);
            } else {
                this.lastState = null;
            }
            this.timeLeft = (Long)Adapters.LONG.readBits(buffer).orElseThrow();
            this.ballsGiven = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
            this.nearestPortal = Adapters.BLOCK_POS.asNullable().readBits(buffer).orElse(null);
            this.unlocked = Adapters.BOOLEAN.readBits(buffer).orElseThrow();
            this.prompted = Adapters.BOOLEAN.readBits(buffer).orElseThrow();
        }

        @Override
        public Optional<class_2487> writeNbt() {
            return Optional.of(new class_2487()).map(nbt -> {
                if (this.lastState != null) {
                    this.lastState.writeNbt().ifPresent(tag -> nbt.method_10566("lastState", (class_2520)tag));
                }
                Adapters.LONG.writeNbt(this.timeLeft).ifPresent(tag -> nbt.method_10566("timeLeft", tag));
                Adapters.INT.writeNbt(this.ballsGiven).ifPresent(tag -> nbt.method_10566("ballsGiven", tag));
                Adapters.BLOCK_POS.writeNbt(this.nearestPortal).ifPresent(tag -> nbt.method_10566("nearestPortal", tag));
                Adapters.BOOLEAN.writeNbt(this.unlocked).ifPresent(tag -> nbt.method_10566("unlocked", tag));
                Adapters.BOOLEAN.writeNbt(this.prompted).ifPresent(tag -> nbt.method_10566("prompted", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(class_2487 nbt) {
            if (nbt.method_10545("lastState")) {
                this.lastState = new EntityState();
                this.lastState.readNbt(nbt.method_10562("lastState"));
            } else {
                this.lastState = null;
            }
            this.timeLeft = Adapters.LONG.readNbt(nbt.method_10580("timeLeft")).orElse(0L);
            this.ballsGiven = Adapters.INT.readNbt(nbt.method_10580("ballsGiven")).orElse(0);
            this.nearestPortal = Adapters.BLOCK_POS.readNbt(nbt.method_10580("nearestPortal")).orElse(null);
            this.unlocked = Adapters.BOOLEAN.readNbt(nbt.method_10580("unlocked")).orElse(false);
            this.prompted = Adapters.BOOLEAN.readNbt(nbt.method_10580("unlocked")).orElse(false);
        }
    }
}

