/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.world.data.save;

import abeshutt.staracademy.compat.cobblemon.GameStarterHandler;
import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.basic.EnumAdapter;
import abeshutt.staracademy.init.ModConfigs;
import abeshutt.staracademy.init.ModWorldData;
import abeshutt.staracademy.net.UpdateStarterRaffleS2CPacket;
import abeshutt.staracademy.world.data.StarterEntry;
import abeshutt.staracademy.world.data.StarterId;
import abeshutt.staracademy.world.data.StarterMode;
import abeshutt.staracademy.world.data.StarterPokemon;
import abeshutt.staracademy.world.data.save.WorldData;
import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.advancement.CobblemonCriteria;
import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.starter.StarterChosenEvent;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.starter.StarterHandler;
import com.cobblemon.mod.common.api.storage.player.GeneralPlayerData;
import com.cobblemon.mod.common.api.storage.player.InstancedPlayerData;
import com.cobblemon.mod.common.api.storage.player.PlayerInstancedDataStoreTypes;
import com.cobblemon.mod.common.config.starter.StarterCategory;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.starter.CobblemonStarterHandler;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.world.gamerules.CobblemonGameRules;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import kotlin.Unit;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class PokemonStarterData
extends WorldData {
    public static final PokemonStarterData CLIENT = new PokemonStarterData(0L, StarterMode.RAFFLE_PAUSED);
    private List<StarterPokemon> starters = new ArrayList<StarterPokemon>();
    private final Map<UUID, StarterEntry> entries = new HashMap<UUID, StarterEntry>();
    private long timeInterval;
    private long timeLeft;
    private StarterMode mode;
    private StarterMode lastMode;
    private int allocations;
    private boolean changed;

    private PokemonStarterData(long timeInterval, StarterMode mode) {
        this.timeLeft = this.timeInterval = timeInterval;
        this.mode = mode;
        this.lastMode = null;
    }

    public PokemonStarterData() {
        this(ModConfigs.STARTER_RAFFLE.getTimeInterval(), ModConfigs.STARTER_RAFFLE.getMode());
    }

    public List<StarterPokemon> getStarters() {
        return this.starters;
    }

    public boolean setStarters(List<StarterPokemon> starters) {
        boolean changed = !this.starters.equals(starters);
        this.starters = starters;
        if (changed) {
            this.setChanged(true);
            return true;
        }
        return false;
    }

    public Map<UUID, StarterEntry> getEntries() {
        return this.entries;
    }

    public StarterId getPick(UUID uuid) {
        StarterEntry entry = this.entries.get(uuid);
        if (entry == null) {
            return null;
        }
        return entry.getPick();
    }

    public void setPick(UUID uuid, StarterId pick) {
        StarterEntry entry = this.entries.computeIfAbsent(uuid, key -> new StarterEntry());
        entry.setPick(pick);
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    public void setTimeInterval(long timeInterval) {
        this.timeLeft = this.timeInterval = timeInterval;
        this.setChanged(true);
    }

    public long getTimeLeft() {
        return this.timeLeft;
    }

    public void setTimeLeft(long timeLeft) {
        this.timeLeft = timeLeft;
        this.setChanged(true);
    }

    public StarterMode getMode() {
        return this.mode;
    }

    public boolean setMode(StarterMode mode) {
        boolean changed = this.mode != mode;
        this.mode = mode;
        if (changed) {
            this.setChanged(true);
            return true;
        }
        return false;
    }

    public int getAllocations() {
        return this.allocations;
    }

    public boolean setAllocations(int allocations) {
        boolean changed = this.allocations != allocations;
        this.allocations = allocations;
        if (changed) {
            this.setChanged(true);
            return true;
        }
        return false;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
        this.method_80();
    }

    public int getRemainingAllocations(StarterId starter) {
        int allocations = 0;
        for (Map.Entry<UUID, StarterEntry> entry : this.entries.entrySet()) {
            if (!starter.equals(entry.getValue().getGranted())) continue;
            ++allocations;
        }
        return this.allocations - allocations;
    }

    public void onTick(MinecraftServer server) {
        if (this.mode != this.lastMode) {
            Cobblemon.INSTANCE.setStarterHandler((StarterHandler)(switch (this.mode) {
                default -> throw new MatchException(null, null);
                case StarterMode.DEFAULT -> new CobblemonStarterHandler();
                case StarterMode.RAFFLE_ENABLED, StarterMode.RAFFLE_PAUSED -> new GameStarterHandler();
            }));
            this.lastMode = this.mode;
        }
        if (this.mode == StarterMode.RAFFLE_ENABLED) {
            if (this.getTimeLeft() <= 0L) {
                this.onRaffle(server);
                this.setTimeLeft(this.getTimeInterval());
            } else {
                this.setTimeLeft(this.getTimeLeft() - 1L);
            }
        }
        this.setAllocations(ModConfigs.STARTER_RAFFLE.getAllocations());
        for (class_3222 player : server.method_3760().method_14571()) {
            StarterEntry entry2 = this.getEntries().get(player.method_5667());
            if (entry2 == null) continue;
            GeneralPlayerData playerData = Cobblemon.playerDataManager.getGenericData(player);
            entry2.setAvailable(!playerData.getStarterSelected() && !playerData.getStarterLocked());
        }
        HashMap<UUID, StarterEntry> changes = new HashMap<UUID, StarterEntry>();
        this.entries.forEach((uuid, entry) -> {
            if (entry.isChanged()) {
                changes.put((UUID)uuid, (StarterEntry)entry);
                entry.setChanged(false);
                this.method_80();
            }
        });
        if (!changes.isEmpty() || this.isChanged()) {
            for (class_3222 player : server.method_3760().method_14571()) {
                HashMap<UUID, StarterEntry> message = new HashMap<UUID, StarterEntry>();
                changes.forEach((uuid, entry) -> {
                    if (entry.getGranted() != null || player.method_5667().equals(uuid)) {
                        message.put((UUID)uuid, (StarterEntry)entry);
                    }
                });
                NetworkManager.sendToPlayer((class_3222)player, (class_8710)new UpdateStarterRaffleS2CPacket(null, message, this.timeInterval, this.timeLeft, this.mode, this.allocations));
            }
        }
    }

    private void onJoin(class_3222 player) {
        this.entries.putIfAbsent(player.method_5667(), new StarterEntry());
        HashMap<UUID, StarterEntry> message = new HashMap<UUID, StarterEntry>();
        this.entries.forEach((uuid, entry) -> {
            if (entry.getGranted() != null || player.method_5667().equals(uuid)) {
                message.put((UUID)uuid, (StarterEntry)entry);
            }
        });
        ArrayList<StarterPokemon> starters = new ArrayList<StarterPokemon>();
        List categories = Cobblemon.INSTANCE.getStarterHandler().getStarterList(player);
        for (StarterCategory category : categories) {
            for (int i = 0; i < category.getPokemon().size(); ++i) {
                starters.add(new StarterPokemon(new StarterId(category.getName(), i), ((PokemonProperties)category.getPokemon().get(i)).asRenderablePokemon().getSpecies(), ((PokemonProperties)category.getPokemon().get(i)).getAspects()));
            }
        }
        NetworkManager.sendToPlayer((class_3222)player, (class_8710)new UpdateStarterRaffleS2CPacket(starters, message, this.timeInterval, this.timeLeft, this.mode, this.allocations));
    }

    private void onRaffle(MinecraftServer server) {
        HashMap<StarterId, Set> picks = new HashMap<StarterId, Set>();
        this.entries.forEach((uuid, entry) -> {
            if (entry.getPick() == null) {
                return;
            }
            picks.computeIfAbsent(entry.getPick(), k -> new HashSet()).add(uuid);
        });
        picks.forEach((pick, pickers) -> {
            if (pickers.size() > this.getRemainingAllocations((StarterId)pick)) {
                return;
            }
            for (UUID picker : pickers) {
                StarterEntry entry = this.getEntries().get(picker);
                class_3222 player = server.method_3760().method_14602(picker);
                if (player == null) {
                    return;
                }
                this.giveStarter(player, (StarterId)pick).ifPresent(pokemon -> {
                    entry.setGranted((StarterId)pick);
                    for (class_3222 other : server.method_3760().method_14571()) {
                        other.method_43496((class_2561)class_2561.method_43473().method_10852(player.method_5477()).method_10852((class_2561)class_2561.method_43470((String)" has claimed ").method_27692(class_124.field_1080)).method_10852((class_2561)pokemon.getDisplayName().method_10862(class_2583.field_24360.method_36139(pokemon.getSpecies().getPrimaryType().getHue()))).method_10852((class_2561)class_2561.method_43470((String)" as their starter!").method_27692(class_124.field_1080)));
                    }
                });
            }
        });
        for (StarterEntry entry2 : this.entries.values()) {
            entry2.onCompleteRound();
        }
    }

    public Optional<Pokemon> giveStarter(class_3222 player, StarterId starter) {
        GeneralPlayerData playerData = Cobblemon.playerDataManager.getGenericData(player);
        if (playerData.getStarterSelected()) {
            player.method_7353((class_2561)LocalizationUtilsKt.lang((String)"ui.starter.alreadyselected", (Object[])new Object[0]).method_27692(class_124.field_1061), true);
            return Optional.empty();
        }
        if (playerData.getStarterLocked()) {
            player.method_7353((class_2561)LocalizationUtilsKt.lang((String)"ui.starter.cannotchoose", (Object[])new Object[0]).method_27692(class_124.field_1061), true);
            return Optional.empty();
        }
        PokemonProperties properties = null;
        for (StarterCategory category : Cobblemon.starterConfig.getStarters()) {
            if (!category.getName().equals(starter.getCategory())) continue;
            List pokemons = category.getPokemon();
            if (starter.getIndex() < 0 || starter.getIndex() >= pokemons.size()) {
                return Optional.empty();
            }
            properties = (PokemonProperties)pokemons.get(starter.getIndex());
            break;
        }
        if (properties == null) {
            return Optional.empty();
        }
        Pokemon pokemon = properties.create();
        CobblemonEvents.STARTER_CHOSEN.postThen((Cancelable)new StarterChosenEvent(player, properties, pokemon), event -> Unit.INSTANCE, event -> {
            Pokemon eventPokemon = event.getPokemon();
            playerData.setStarterSelected(true);
            playerData.setStarterUUID(eventPokemon.getUuid());
            if (player.method_37908().method_8450().method_8355(CobblemonGameRules.SHINY_STARTERS)) {
                pokemon.setShiny(true);
            }
            Cobblemon.INSTANCE.getStorage().getParty(player).add(eventPokemon);
            CobblemonCriteria.INSTANCE.getPICK_STARTER().trigger(player, (Object)pokemon);
            Cobblemon.playerDataManager.saveSingle((InstancedPlayerData)playerData, PlayerInstancedDataStoreTypes.INSTANCE.getGENERAL());
            playerData.sendToPlayer(player);
            return Unit.INSTANCE;
        });
        return Optional.of(pokemon);
    }

    @Override
    public Optional<class_2487> writeNbt() {
        return Optional.of(new class_2487()).map(nbt -> {
            class_2487 entries = new class_2487();
            for (Map.Entry<UUID, StarterEntry> entry : this.entries.entrySet()) {
                entry.getValue().writeNbt().ifPresent(tag -> entries.method_10566(((UUID)entry.getKey()).toString(), (class_2520)tag));
            }
            nbt.method_10566("entries", (class_2520)entries);
            Adapters.LONG.writeNbt(this.timeInterval).ifPresent(tag -> nbt.method_10566("timeInterval", tag));
            Adapters.LONG.writeNbt(this.timeLeft).ifPresent(tag -> nbt.method_10566("timeLeft", tag));
            Adapters.ofEnum(StarterMode.class, EnumAdapter.Mode.NAME).writeNbt(this.mode).ifPresent(tag -> nbt.method_10566("mode", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2487 nbt) {
        class_2487 entries = nbt.method_10562("entries");
        this.entries.clear();
        for (String key : entries.method_10541()) {
            StarterEntry entry = new StarterEntry();
            entry.readNbt(entries.method_10562(key));
            this.entries.put(UUID.fromString(key), entry);
        }
        this.timeInterval = Adapters.LONG.readNbt(nbt.method_10580("timeInterval")).orElseGet(ModConfigs.STARTER_RAFFLE::getTimeInterval);
        this.timeLeft = Math.min(Adapters.LONG.readNbt(nbt.method_10580("timeLeft")).orElse(this.timeInterval), this.timeInterval);
        this.mode = nbt.method_10545("mode") ? Adapters.ofEnum(StarterMode.class, EnumAdapter.Mode.NAME).readNbt(nbt.method_10580("mode")).orElseGet(ModConfigs.STARTER_RAFFLE::getMode) : (Adapters.BOOLEAN.readNbt(nbt.method_10580("paused")).orElse(false) != false ? StarterMode.RAFFLE_PAUSED : StarterMode.RAFFLE_ENABLED);
    }

    public static void init() {
        PlayerEvent.PLAYER_JOIN.register(player -> {
            PokemonStarterData data = ModWorldData.POKEMON_STARTER.getGlobal(player.method_37908());
            data.onJoin(player);
        });
        TickEvent.SERVER_POST.register(server -> {
            PokemonStarterData data = ModWorldData.POKEMON_STARTER.getGlobal((MinecraftServer)server);
            data.onTick((MinecraftServer)server);
        });
    }
}

